/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.inspect;

import org.basex.io.IO;
import org.basex.query.LibraryModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryText;
import org.basex.query.StaticScope;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.inspect.Inspect;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class PlainDoc
extends Inspect {
    public PlainDoc(QueryContext qc, InputInfo ii) {
        super(qc, ii);
    }

    public FElem context() throws QueryException {
        FElem context = this.elem("context", null);
        for (StaticVar sv : this.ctx.vars) {
            this.variable(sv, context);
        }
        for (StaticFunc sf : this.ctx.funcs.funcs()) {
            this.function(sf.name, sf, sf.funcType(), context);
        }
        return context;
    }

    @Override
    public FElem parse(IO io) throws QueryException {
        TokenObjMap<TokenList> doc;
        QueryParser qp = this.parseQuery(io);
        FElem mod = this.elem("module", null);
        if (this.module instanceof LibraryModule) {
            QNm name = ((LibraryModule)this.module).name;
            mod.add("prefix", name.string());
            mod.add("uri", name.uri());
        }
        if ((doc = this.module.doc()) != null) {
            this.comment(doc, mod);
        }
        for (StaticVar sv : qp.vars) {
            this.variable(sv, mod);
        }
        for (StaticFunc sf : qp.funcs) {
            this.function(sf.name, sf, sf.funcType(), mod);
        }
        return mod;
    }

    private FElem variable(StaticVar sv, FElem parent) throws QueryException {
        FElem variable = this.elem("variable", parent);
        variable.add("name", sv.name.string());
        if (sv.name.uri().length != 0) {
            variable.add("uri", sv.name.uri());
        }
        PlainDoc.type(sv.type(), variable);
        this.comment(sv, variable);
        this.annotation(sv.ann, variable, true);
        return variable;
    }

    public FElem function(QNm fname, StaticFunc sf, FuncType ftype, FElem parent) throws QueryException {
        TokenList returns;
        FElem function = this.elem("function", parent);
        if (fname != null) {
            function.add("name", fname.string());
            if (fname.uri().length != 0) {
                function.add("uri", fname.uri());
            }
        }
        TokenObjMap<TokenList> doc = sf != null ? sf.doc() : null;
        int al = ftype.args.length;
        QNm[] names = null;
        if (sf != null) {
            names = new QNm[al];
            for (int n = 0; n < al; ++n) {
                names[n] = sf.args[n].name;
            }
        }
        for (int a = 0; a < al; ++a) {
            FElem argument = this.elem("argument", function);
            if (names != null) {
                byte[] pdoc;
                byte[] name = names[a].string();
                byte[] uri = names[a].uri();
                argument.add("name", name);
                if (uri.length != 0) {
                    argument.add("uri", uri);
                }
                if ((pdoc = PlainDoc.doc(doc, name)) != null) {
                    PlainDoc.add(pdoc, this.ctx.context, argument);
                }
            }
            PlainDoc.type(ftype.args[a], argument);
        }
        if (sf != null) {
            this.annotation(sf.ann, function, true);
        }
        if (doc != null) {
            for (byte[] key : doc) {
                if (Token.eq(key, QueryText.DOC_PARAM, QueryText.DOC_RETURN)) continue;
                for (byte[] value : doc.get(key)) {
                    FElem elem = Token.eq(key, QueryText.DOC_TAGS) ? this.elem(Token.string(key), function) : this.elem("tag", function).add("name", key);
                    PlainDoc.add(value, this.ctx.context, elem);
                }
            }
        }
        SeqType rt = sf != null ? sf.type() : ftype.ret;
        FElem ret = PlainDoc.type(rt, this.elem("return", function));
        TokenList tokenList = returns = doc != null ? doc.get(QueryText.DOC_RETURN) : null;
        if (returns != null) {
            for (byte[] val : returns) {
                PlainDoc.add(val, this.ctx.context, ret);
            }
        }
        return function;
    }

    @Override
    protected FElem elem(String name, FElem parent) {
        FElem elem = new FElem(name);
        if (parent != null) {
            parent.add(elem);
        }
        return elem;
    }

    private void comment(StaticScope scope, FElem parent) {
        TokenObjMap<TokenList> tags = scope.doc();
        if (tags != null) {
            this.comment(tags, parent);
        }
    }

    @Override
    protected FElem tag(byte[] tag, FElem parent) {
        String t = Token.string(tag);
        return this.elem(Token.eq(tag, QueryText.DOC_TAGS) ? t : t + "_tag", parent);
    }

    private static FElem type(SeqType st, FElem elem) {
        if (st != null) {
            elem.add("type", st.typeString());
            String occ = st.occ.toString();
            if (!occ.isEmpty()) {
                elem.add("occurrence", occ);
            }
        }
        return elem;
    }
}

