/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.unit;

import java.util.ArrayList;
import java.util.Collections;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.unit.Constants;
import org.basex.query.util.unit.UnitException;
import org.basex.query.value.Value;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;

public final class Unit {
    private final QueryContext ctx;
    private final InputInfo info;
    private StaticFunc current;

    public Unit(QueryContext qc, InputInfo ii) {
        this.info = ii;
        this.ctx = qc;
    }

    public FElem test(StaticContext sc) throws QueryException {
        ArrayList<StaticFunc> funcs = new ArrayList<StaticFunc>();
        Collections.addAll(funcs, this.ctx.funcs.funcs());
        return this.test(sc, funcs);
    }

    public FElem test(StaticContext sc, ArrayList<StaticFunc> funcs) throws QueryException {
        FElem testsuite = new FElem(Constants.TESTSUITE).add(Constants.NAME, sc.baseURI().string());
        ArrayList<StaticFunc> before = new ArrayList<StaticFunc>(1);
        ArrayList<StaticFunc> after = new ArrayList<StaticFunc>(1);
        ArrayList<StaticFunc> beforeModule = new ArrayList<StaticFunc>(1);
        ArrayList<StaticFunc> afterModule = new ArrayList<StaticFunc>(1);
        ArrayList<StaticFunc> tests = new ArrayList<StaticFunc>(1);
        Performance p = new Performance();
        for (StaticFunc uf : funcs) {
            Ann ann = uf.ann;
            int as = ann.size();
            boolean xq = false;
            for (int a = 0; !xq && a < as; xq |= Token.eq(ann.names[a].uri(), QueryText.UNITURI), ++a) {
            }
            if (!xq) continue;
            if (uf.updating) {
                throw Err.UNIT_UPDATE.get(this.info, new Object[]{uf.name.local()});
            }
            if (uf.args.length > 0) {
                throw Err.UNIT_ARGS.get(this.info, new Object[]{uf.name.local()});
            }
            if (this.indexOf(uf, Constants.BEFORE) != -1) {
                before.add(uf);
            }
            if (this.indexOf(uf, Constants.AFTER) != -1) {
                after.add(uf);
            }
            if (this.indexOf(uf, Constants.BEFORE_MODULE) != -1) {
                beforeModule.add(uf);
            }
            if (this.indexOf(uf, Constants.AFTER_MODULE) != -1) {
                afterModule.add(uf);
            }
            if (this.indexOf(uf, Constants.TEST) == -1) continue;
            tests.add(uf);
        }
        int s = 0;
        int f = 0;
        int e = 0;
        int t = 0;
        try {
            for (StaticFunc uf : beforeModule) {
                this.eval(uf);
            }
            for (StaticFunc uf : tests) {
                Performance pt;
                FElem testcase;
                block27: {
                    Value values = uf.ann.values[this.indexOf(uf, Constants.TEST)];
                    long vs = values.size();
                    byte[] code = null;
                    if (vs != 0L) {
                        if (vs == 2L && Token.eq(Constants.EXPECTED, values.itemAt(0L).string(this.info))) {
                            code = values.itemAt(1L).string(this.info);
                        } else {
                            throw Err.UNIT_ANN.get(this.info, Character.valueOf('%'), uf.ann.names[0]);
                        }
                    }
                    testcase = new FElem(Constants.TESTCASE).add(Constants.NAME, uf.name.local());
                    ++t;
                    pt = new Performance();
                    int skip = this.indexOf(uf, Constants.IGNORE);
                    if (skip == -1) {
                        try {
                            for (StaticFunc fn : before) {
                                this.eval(fn);
                            }
                            this.eval(uf);
                            for (StaticFunc fn : after) {
                                this.eval(fn);
                            }
                            if (code != null) {
                                ++f;
                                testcase.add(new FElem(Constants.FAILURE).add(new FElem(Constants.EXPECTED).add(code)));
                            }
                            break block27;
                        }
                        catch (QueryException ex) {
                            QNm name = ex.qname();
                            if (code == null || !Token.eq(code, name.local())) {
                                boolean failure = Token.eq(name.uri(), QueryText.UNITURI);
                                if (failure) {
                                    ++f;
                                } else {
                                    ++e;
                                }
                                FElem error = new FElem(failure ? Constants.FAILURE : Constants.ERROR);
                                error.add(Constants.LINE, Token.token(ex.line()));
                                error.add(Constants.COLUMN, Token.token(ex.column()));
                                if (ex instanceof UnitException) {
                                    UnitException ue = (UnitException)ex;
                                    error.add(this.elem(ue.returned, Constants.RETURNED, ue.count));
                                    error.add(this.elem(ue.expected, Constants.EXPECTED, ue.count));
                                } else {
                                    error.add(Constants.TYPE, ex.qname().local());
                                    error.add(ex.getLocalizedMessage());
                                }
                                testcase.add(error);
                            }
                            break block27;
                        }
                    }
                    Value sv = uf.ann.values[skip];
                    testcase.add(Constants.SKIPPED, sv.isEmpty() ? Token.EMPTY : sv.itemAt(0L).string(this.info));
                    ++s;
                }
                testcase.add(Constants.TIME, this.time(pt));
                testsuite.add(testcase);
            }
            for (StaticFunc uf : afterModule) {
                this.eval(uf);
            }
        }
        catch (QueryException ex) {
            FElem test = new FElem(Constants.TESTCASE).add(Constants.NAME, this.current.name.local());
            test.add(Constants.TIME, this.time(p));
            testsuite.add(test);
        }
        testsuite.add(Constants.TIME, this.time(p));
        testsuite.add(Constants.TESTS, Token.token(t));
        testsuite.add(Constants.FAILURES, Token.token(f));
        testsuite.add(Constants.ERRORS, Token.token(e));
        testsuite.add(Constants.SKIPPED, Token.token(s));
        return testsuite;
    }

    private FElem elem(Item it, byte[] name, int c) throws QueryException {
        FElem exp = new FElem(name);
        if (it instanceof ANode) {
            exp.add((ANode)it);
        } else if (it != null) {
            exp.add(it.string(this.info));
        }
        exp.add(Constants.ITEM, Token.token(c));
        return exp;
    }

    private void eval(StaticFunc fn) throws QueryException {
        Item it;
        this.current = fn;
        ValueIter ir = fn.invokeValue(this.ctx, this.info, new Value[0]).iter();
        while ((it = ((Iter)ir).next()) != null) {
            it.materialize(this.info);
        }
    }

    private int indexOf(StaticFunc func, byte[] name) throws QueryException {
        Ann ann = func.ann;
        int as = ann.size();
        int pos = -1;
        for (int a = 0; a < as; ++a) {
            QNm nm = ann.names[a];
            if (!Token.eq(nm.uri(), QueryText.UNITURI) || !Token.eq(nm.local(), name)) continue;
            if (pos != -1) {
                throw Err.UNIT_TWICE.get(this.info, Character.valueOf('%'), nm.local());
            }
            pos = a;
        }
        return pos;
    }

    private byte[] time(Performance p) {
        return new DTDur(p.time() / 1000000L).string(this.info);
    }
}

