/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.Duration;
import org.basex.query.QueryException;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class Dur
extends ADateDur {
    static final String DP = "(\\d+)";
    private static final Pattern DUR = Pattern.compile("(-?)P((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+|\\d*\\.\\d+)?S)?)?");
    long mon;

    public Dur(byte[] v, InputInfo ii) throws QueryException {
        this(v, AtomType.DUR, ii);
    }

    Dur(Type t) {
        super(t);
    }

    public Dur(Dur d) {
        this(d, AtomType.DUR);
    }

    private Dur(Dur d, Type t) {
        this(t);
        this.mon = d.mon;
        this.sec = d.sec == null ? BigDecimal.ZERO : d.sec;
    }

    private Dur(byte[] vl, Type t, InputInfo ii) throws QueryException {
        this(t);
        String val = Token.string(vl).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P") || val.endsWith("T")) {
            this.dateErr(vl, "P2000Y12MT23H12M34S", ii);
        }
        this.yearMonth(vl, mt, ii);
        this.dayTime(vl, mt, 6, ii);
    }

    void yearMonth(byte[] vl, Matcher mt, InputInfo ii) throws QueryException {
        long y = mt.group(2) != null ? this.toLong(mt.group(3), true, ii) : 0L;
        long m = mt.group(4) != null ? this.toLong(mt.group(5), true, ii) : 0L;
        this.mon = y * 12L + m;
        double v = (double)y * 12.0 + (double)m;
        if (!mt.group(1).isEmpty()) {
            this.mon = -this.mon;
            v = -v;
        }
        if (v <= -9.223372036854776E18 || v >= 9.223372036854776E18) {
            throw Err.DURRANGE.get(ii, this.type, vl);
        }
    }

    void dayTime(byte[] vl, Matcher mt, int p, InputInfo ii) throws QueryException {
        double v;
        long d = mt.group(p) != null ? this.toLong(mt.group(p + 1), true, ii) : 0L;
        long h = mt.group(p + 3) != null ? this.toLong(mt.group(p + 4), true, ii) : 0L;
        long m = mt.group(p + 5) != null ? this.toLong(mt.group(p + 6), true, ii) : 0L;
        BigDecimal s = mt.group(p + 7) != null ? this.toDecimal(mt.group(p + 8), true, ii) : BigDecimal.ZERO;
        this.sec = s.add(BigDecimal.valueOf(d).multiply(DAYSECONDS)).add(BigDecimal.valueOf(h).multiply(BD3600)).add(BigDecimal.valueOf(m).multiply(BD60));
        if (!mt.group(1).isEmpty()) {
            this.sec = this.sec.negate();
        }
        if ((v = this.sec.doubleValue()) <= -9.223372036854776E18 || v >= 9.223372036854776E18) {
            throw Err.DURRANGE.get(ii, this.type, vl);
        }
    }

    @Override
    public final long yea() {
        return this.mon / 12L;
    }

    @Override
    public final long mon() {
        return this.mon % 12L;
    }

    @Override
    public final long day() {
        return this.sec.divideToIntegralValue(DAYSECONDS).longValue();
    }

    @Override
    public final long hou() {
        return this.tim() / 3600L;
    }

    @Override
    public final long min() {
        return this.tim() % 3600L / 60L;
    }

    @Override
    public final BigDecimal sec() {
        return this.sec.remainder(BD60);
    }

    private long tim() {
        return this.sec.remainder(DAYSECONDS).longValue();
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        int ss = this.sec.signum();
        if (this.mon < 0L || ss < 0) {
            tb.add(45);
        }
        this.date(tb);
        this.time(tb);
        if (this.mon == 0L && ss == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    final void date(TokenBuilder tb) {
        long d;
        long m;
        tb.add(80);
        long y = this.yea();
        if (y != 0L) {
            tb.addLong(Math.abs(y));
            tb.add(89);
        }
        if ((m = this.mon()) != 0L) {
            tb.addLong(Math.abs(m));
            tb.add(77);
        }
        if ((d = this.day()) != 0L) {
            tb.addLong(Math.abs(d));
            tb.add(68);
        }
    }

    final void time(TokenBuilder tb) {
        BigDecimal sc;
        long m;
        if (this.sec.remainder(DAYSECONDS).signum() == 0) {
            return;
        }
        tb.add(84);
        long h = this.hou();
        if (h != 0L) {
            tb.addLong(Math.abs(h));
            tb.add(72);
        }
        if ((m = this.min()) != 0L) {
            tb.addLong(Math.abs(m));
            tb.add(77);
        }
        if ((sc = this.sec()).signum() == 0) {
            return;
        }
        tb.add(Token.chopNumber(Token.token(sc.abs().toPlainString()))).add(83);
    }

    @Override
    public final boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        Dur d = (Dur)(it instanceof Dur ? it : this.type.cast(it, null, null, ii));
        BigDecimal s1 = this.sec == null ? BigDecimal.ZERO : this.sec;
        BigDecimal s2 = d.sec == null ? BigDecimal.ZERO : d.sec;
        return this.mon == d.mon && s1.compareTo(s2) == 0;
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        throw Err.diffError(ii, it, this);
    }

    @Override
    public final Duration toJava() {
        return ADate.df.newDuration(Token.string(this.string(null)));
    }

    @Override
    public final int hash(InputInfo ii) {
        return (int)((double)(31L * this.mon) + (this.sec == null ? 0.0 : this.sec.doubleValue()));
    }

    @Override
    public final String toString() {
        return Util.info("\"%\"", new Object[]{this.string(null)});
    }
}

