/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.GDt;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.Uri;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public enum AtomType implements Type
{
    ITEM("item", null, Token.EMPTY, false, false, false, Type.ID.ITEM),
    UTY("untyped", null, QueryText.XSURI, false, false, false, Type.ID.UTY),
    ATY("anyType", null, QueryText.XSURI, false, false, false, Type.ID.ATY),
    AST("anySimpleType", null, QueryText.XSURI, false, false, false, Type.ID.AST),
    AAT("anyAtomicType", ITEM, QueryText.XSURI, false, false, false, Type.ID.AAT){

        @Override
        public Atm cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Atm(it.string(ii));
        }

        @Override
        public Atm cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return new Atm(o.toString());
        }
    }
    ,
    ATM("untypedAtomic", AAT, QueryText.XSURI, false, true, false, Type.ID.ATM){

        @Override
        public Atm cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Atm(it.string(ii));
        }

        @Override
        public Atm cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return new Atm(o.toString());
        }
    }
    ,
    STR("string", AAT, QueryText.XSURI, false, false, true, Type.ID.STR){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Str.get(it.string(ii));
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Str.get(o, ctx, ii);
        }
    }
    ,
    NST("normalizedString", STR, QueryText.XSURI, false, false, true, Type.ID.NST){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            byte[] str = it.string(ii);
            for (int s = 0; s < str.length; ++s) {
                byte b = str[s];
                if (b != 9 && b != 13 && b != 10) continue;
                str[s] = 32;
            }
            return new Str(str, this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    TOK("token", NST, QueryText.XSURI, false, false, true, Type.ID.TOK){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Str(Token.norm(it.string(ii)), this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    LAN("language", TOK, QueryText.XSURI, false, false, true, Type.ID.LAN){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!LANGPATTERN.matcher(Token.string(v)).matches()) {
                this.invValue(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    NMT("NMTOKEN", TOK, QueryText.XSURI, false, false, true, Type.ID.NMT){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!XMLToken.isNMToken(v)) {
                this.invValue(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    NAM("Name", TOK, QueryText.XSURI, false, false, true, Type.ID.NAM){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.string(ii));
            if (!XMLToken.isName(v)) {
                this.invValue(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    NCN("NCName", NAM, QueryText.XSURI, false, false, true, Type.ID.NCN){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    ID("ID", NCN, QueryText.XSURI, false, false, true, Type.ID.ID){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    IDR("IDREF", NCN, QueryText.XSURI, false, false, true, Type.ID.IDR){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    ENT("ENTITY", NCN, QueryText.XSURI, false, false, true, Type.ID.ENT){

        @Override
        public Str cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    FLT("float", AAT, QueryText.XSURI, true, false, false, Type.ID.FLT){

        @Override
        public Flt cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Flt.get(this.checkNum(it, ii).flt(ii));
        }

        @Override
        public Flt cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DBL("double", AAT, QueryText.XSURI, true, false, false, Type.ID.DBL){

        @Override
        public Dbl cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Dbl.get(this.checkNum(it, ii).dbl(ii));
        }

        @Override
        public Dbl cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DEC("decimal", AAT, QueryText.XSURI, true, false, false, Type.ID.DEC){

        @Override
        public Dec cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Dec.get(this.checkNum(it, ii).dec(ii));
        }

        @Override
        public Dec cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return Dec.get(new BigDecimal(o.toString()));
        }
    }
    ,
    PDC("precisionDecimal", null, QueryText.XSURI, false, false, false, Type.ID.PDC),
    ITR("integer", DEC, QueryText.XSURI, true, false, false, Type.ID.ITR){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return Int.get(this.checkLong(o, 0L, 0L, ii));
        }
    }
    ,
    NPI("nonPositiveInteger", ITR, QueryText.XSURI, true, false, false, Type.ID.NPI){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Long.MIN_VALUE, 0L, ii), this);
        }
    }
    ,
    NIN("negativeInteger", NPI, QueryText.XSURI, true, false, false, Type.ID.NIN){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Long.MIN_VALUE, -1L, ii), this);
        }
    }
    ,
    LNG("long", ITR, QueryText.XSURI, true, false, false, Type.ID.LNG){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 0L, ii), this);
        }
    }
    ,
    INT("int", LNG, QueryText.XSURI, true, false, false, Type.ID.INT){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, Integer.MIN_VALUE, Integer.MAX_VALUE, ii), this);
        }
    }
    ,
    SHR("short", INT, QueryText.XSURI, true, false, false, Type.ID.SHR){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, -32768L, 32767L, ii), this);
        }
    }
    ,
    BYT("byte", SHR, QueryText.XSURI, true, false, false, Type.ID.BYT){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, -128L, 127L, ii), this);
        }
    }
    ,
    NNI("nonNegativeInteger", ITR, QueryText.XSURI, true, false, false, Type.ID.NNI){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    ULN("unsignedLong", NNI, QueryText.XSURI, true, false, false, Type.ID.ULN){

        @Override
        public Dec cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Dec cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            Item it = o instanceof Item ? (Item)o : Str.get(o.toString());
            BigDecimal v = this.checkNum(it, ii).dec(ii);
            BigDecimal i = v.setScale(0, 1);
            if (v.signum() < 0 || v.compareTo(Dec.MAXULNG) > 0 || it.type.isStringOrUntyped() && !v.equals(i)) {
                throw Err.FUNCAST.get(ii, this, Err.chop(it));
            }
            return new Dec(i, this);
        }
    }
    ,
    UIN("unsignedInt", ULN, QueryText.XSURI, true, false, false, Type.ID.UIN){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 0xFFFFFFFFL, ii), this);
        }
    }
    ,
    USH("unsignedShort", UIN, QueryText.XSURI, true, false, false, Type.ID.USH){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 65535L, ii), this);
        }
    }
    ,
    UBY("unsignedByte", USH, QueryText.XSURI, true, false, false, Type.ID.UBY){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 0L, 255L, ii), this);
        }
    }
    ,
    PIN("positiveInteger", NNI, QueryText.XSURI, true, false, false, Type.ID.PIN){

        @Override
        public Int cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast((Object)it, ctx, sc, ii);
        }

        @Override
        public Int cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Int(this.checkLong(o, 1L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    DUR("duration", AAT, QueryText.XSURI, false, false, false, Type.ID.DUR){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof Dur ? new Dur((Dur)it) : (29.str(it) ? new Dur(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    YMD("yearMonthDuration", DUR, QueryText.XSURI, false, false, false, Type.ID.YMD){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof Dur ? new YMDur((Dur)it) : (30.str(it) ? new YMDur(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DTD("dayTimeDuration", DUR, QueryText.XSURI, false, false, false, Type.ID.DTD){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof Dur ? new DTDur((Dur)it) : (31.str(it) ? new DTDur(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DTM("dateTime", AAT, QueryText.XSURI, false, false, false, Type.ID.DTM){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DAT ? new Dtm((ADate)it) : (32.str(it) ? new Dtm(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DTS("dateTimeStamp", null, QueryText.XSURI, false, false, false, Type.ID.DTS),
    DAT("date", AAT, QueryText.XSURI, false, false, false, Type.ID.DAT){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Dat((ADate)it) : (33.str(it) ? new Dat(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    TIM("time", AAT, QueryText.XSURI, false, false, false, Type.ID.TIM){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Tim((ADate)it) : (34.str(it) ? new Tim(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    YMO("gYearMonth", AAT, QueryText.XSURI, false, false, false, Type.ID.YMO){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (35.str(it) ? new GDt(it.string(ii), this, ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    YEA("gYear", AAT, QueryText.XSURI, false, false, false, Type.ID.YEA){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (36.str(it) ? new GDt(it.string(ii), this, ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    MDA("gMonthDay", AAT, QueryText.XSURI, false, false, false, Type.ID.MDA){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (37.str(it) ? new GDt(it.string(ii), this, ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    DAY("gDay", AAT, QueryText.XSURI, false, false, false, Type.ID.DAY){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (38.str(it) ? new GDt(it.string(ii), this, ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    MON("gMonth", AAT, QueryText.XSURI, false, false, false, Type.ID.MON){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new GDt((ADate)it, this) : (39.str(it) ? new GDt(it.string(ii), this, ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
        }
    }
    ,
    BLN("boolean", AAT, QueryText.XSURI, false, false, false, Type.ID.BLN){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof ANum ? Bln.get(it.bool(ii)) : (40.str(it) ? Bln.get(Bln.parse(it.string(ii), ii)) : this.invCast(it, ii));
        }

        @Override
        public Bln cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return o instanceof Boolean ? Bln.get((Boolean)o) : Bln.get(Boolean.parseBoolean(o.toString()));
        }
    }
    ,
    BIN("binary", AAT, QueryText.BASEXURI, false, false, false, Type.ID.BIN),
    B64("base64Binary", BIN, QueryText.XSURI, false, false, false, Type.ID.B64){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof Bin ? new B64((Bin)it, ii) : (41.str(it) ? new B64(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new B64(o instanceof byte[] ? (byte[])o : Token.token(o.toString()), ii);
        }
    }
    ,
    HEX("hexBinary", BIN, QueryText.XSURI, false, false, false, Type.ID.HEX){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return it instanceof Bin ? new Hex((Bin)it, ii) : (42.str(it) ? new Hex(it.string(ii), ii) : this.invCast(it, ii));
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return new Hex(o instanceof byte[] ? (byte[])o : Token.token(o.toString()), ii);
        }
    }
    ,
    URI("anyURI", AAT, QueryText.XSURI, false, false, true, Type.ID.URI){

        @Override
        public Uri cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            Uri u;
            if (!it.type.isStringOrUntyped()) {
                this.invCast(it, ii);
            }
            if (!(u = Uri.uri(it.string(ii))).isValid()) {
                throw Err.FUNCAST.get(ii, this, Err.chop(it));
            }
            return u;
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return Uri.uri(o.toString());
        }
    }
    ,
    QNM("QName", AAT, QueryText.XSURI, false, false, false, Type.ID.QNM){

        @Override
        public QNm cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            byte[] nm;
            if (!(it.type == STR || sc.xquery3() && it.type.isUntyped())) {
                this.invCast(it, ii);
            }
            if (!XMLToken.isQName(nm = Token.trim(it.string(ii)))) {
                throw Err.FUNCAST.get(ii, this, Err.chop(nm));
            }
            QNm qn = new QNm(nm, sc);
            if (!qn.hasURI() && qn.hasPrefix()) {
                throw Err.NSDECL.get(ii, new Object[]{qn.prefix()});
            }
            return qn;
        }

        @Override
        public QNm cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return o instanceof QName ? new QNm((QName)o) : new QNm(o.toString());
        }
    }
    ,
    NOT("NOTATION", AAT, QueryText.XSURI, false, false, false, Type.ID.NOT),
    JAVA("java", ITEM, QueryText.BASEXURI, true, true, true, Type.ID.JAVA){

        @Override
        public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return new Jav(it, ctx);
        }

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            return new Jav(o, null);
        }
    };

    static final Pattern LANGPATTERN;
    public static final AtomType[] VALUES;
    public final QNm name;
    public final AtomType par;
    private final Type.ID id;
    private final boolean num;
    private final boolean unt;
    private final boolean str;
    private SeqType seq;

    private AtomType(String nm, AtomType pr, byte[] ur, boolean n2, boolean u, boolean s, Type.ID i) {
        this.name = new QNm(nm, ur);
        this.par = pr;
        this.num = n2;
        this.unt = u;
        this.str = s;
        this.id = i;
    }

    @Override
    public boolean isNumber() {
        return this.num;
    }

    @Override
    public boolean isUntyped() {
        return this.unt;
    }

    @Override
    public boolean isNumberOrUntyped() {
        return this.num || this.unt;
    }

    @Override
    public boolean isStringOrUntyped() {
        return this.str || this.unt;
    }

    @Override
    public byte[] string() {
        return this.name.string();
    }

    @Override
    public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return it.type == this ? it : this.invCast(it, ii);
    }

    @Override
    public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        throw Util.notExpected(o);
    }

    @Override
    public Item castString(String o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(o, ctx, sc, ii);
    }

    @Override
    public SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public boolean eq(Type t) {
        return this == t;
    }

    @Override
    public final boolean instanceOf(Type t) {
        return this == t || this.par != null && this.par.instanceOf(t);
    }

    @Override
    public Type union(Type t) {
        if (this.instanceOf(t)) {
            return t;
        }
        if (t.instanceOf(this)) {
            return this;
        }
        if (t instanceof AtomType) {
            ArrayList<AtomType> arr = new ArrayList<AtomType>();
            AtomType at = (AtomType)t;
            while ((at = at.par) != null) {
                arr.add(at);
            }
            AtomType p = this;
            while ((p = p.par) != null) {
                if (!arr.contains(p)) continue;
                return p;
            }
        }
        return ITEM;
    }

    @Override
    public Type intersect(Type t) {
        return this.instanceOf(t) ? this : (t.instanceOf(this) ? t : null);
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public Type.ID id() {
        return this.id;
    }

    @Override
    public String toString() {
        boolean xs = Token.eq(QueryText.XSURI, this.name.uri());
        TokenBuilder tb = new TokenBuilder();
        if (xs) {
            tb.add(NSGlobal.prefix(this.name.uri())).add(58);
        }
        tb.add(this.name.string());
        if (!xs) {
            tb.add("()");
        }
        return tb.toString();
    }

    Item checkNum(Item it, InputInfo ii) throws QueryException {
        Type ip = it.type;
        return it instanceof ANum || ip.isStringOrUntyped() && ip != URI || ip == BLN ? it : this.invCast(it, ii);
    }

    long checkLong(Object o, long min, long max, InputInfo ii) throws QueryException {
        double d;
        Item it = o instanceof Item ? (Item)o : Str.get(o.toString());
        this.checkNum(it, ii);
        Type ip = it.type;
        if (ip == DBL || ip == FLT) {
            double d2 = it.dbl(ii);
            if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                throw Err.valueError(ii, this, it);
            }
            if (min != max && (d2 < (double)min || d2 > (double)max)) {
                throw Err.FUNCAST.get(ii, this, Err.chop(it));
            }
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                throw Err.INTRANGE.get(ii, d2);
            }
            return (long)d2;
        }
        if (min == max && ((d = it.dbl(ii)) < -9.223372036854776E18 || d > 9.223372036854776E18)) {
            throw Err.FUNCAST.get(ii, this, Err.chop(it));
        }
        long l = it.itr(ii);
        if (min != max && (l < min || l > max)) {
            throw Err.FUNCAST.get(ii, this, Err.chop(it));
        }
        return l;
    }

    static boolean str(Item it) {
        Type ip = it.type;
        return ip.isStringOrUntyped() && ip != URI;
    }

    byte[] checkName(Item it, InputInfo ii) throws QueryException {
        byte[] v = Token.norm(it.string(ii));
        if (!XMLToken.isNCName(v)) {
            this.invValue(it, ii);
        }
        return v;
    }

    Item invCast(Item it, InputInfo ii) throws QueryException {
        throw Err.castError(ii, this, it);
    }

    Item invValue(Item it, InputInfo ii) throws QueryException {
        throw Err.FUNCCASTEX.get(ii, it.type(), this, it);
    }

    public static AtomType find(QNm type, boolean all) {
        if (!Token.eq(type.uri(), QueryText.BASEXURI)) {
            for (AtomType t : VALUES) {
                if (!t.name.eq(type) || !all && t.par == null) continue;
                return t;
            }
        }
        return null;
    }

    @Override
    public boolean nsSensitive() {
        return this.instanceOf(QNM) || this.instanceOf(NOT);
    }

    static Type getType(Type.ID id) {
        for (AtomType t : VALUES) {
            if (t.id != id) continue;
            return t;
        }
        return null;
    }

    static {
        LANGPATTERN = Pattern.compile("[A-Za-z]{1,8}(-[A-Za-z0-9]{1,8})*");
        VALUES = AtomType.values();
    }
}

