/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

public final class BitArray {
    static final int WORD_POWER = 6;
    static final int WORD_SIZE = 64;
    static final long WORD_MASK = -1L;
    private long[] words;
    private int size;

    public BitArray() {
        this.init();
    }

    public BitArray(int n) {
        this.init(new long[(Math.max(0, n - 1) >>> 6) + 1], n);
    }

    public BitArray(int n, boolean set) {
        this(n);
        if (set) {
            int i;
            int p = Math.max(0, n - 1) >>> 6;
            for (i = 0; i < p; ++i) {
                this.words[i] = -1L;
            }
            for (i = p << 6; i < n; ++i) {
                this.set(i);
            }
        }
    }

    public BitArray(long[] a, int l) {
        this.init(a, l);
    }

    public void init() {
        this.init(new long[1], 0);
    }

    public void init(long[] a, int l) {
        this.words = a;
        this.size = l;
    }

    public long[] toArray() {
        int i = this.words.length;
        while (--i >= 0 && this.words[i] == 0L) {
        }
        long[] result = new long[++i];
        System.arraycopy(this.words, 0, result, 0, i);
        return result;
    }

    public int cardinality() {
        int sum = 0;
        int inUse = this.size + 64 - 1 >>> 6;
        for (int i = 0; i < inUse; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public boolean get(int i) {
        if (i >= this.size) {
            return false;
        }
        int wi = i >>> 6;
        return (this.words[wi] & 1L << i) != 0L;
    }

    public void set(int i) {
        int wi = i >>> 6;
        if (wi >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] | 1L << i;
        if (i >= this.size) {
            this.size = i + 1;
        }
    }

    public void clear(int i) {
        int wi = i >>> 6;
        if (wi >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int nextFree(int i) {
        int wi = i >>> 6;
        long word = (this.words[wi] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << i;
        if (word != 0L) {
            return (wi << 6) + Long.numberOfTrailingZeros(word);
        }
        while (++wi < this.words.length) {
            word = this.words[wi] ^ 0xFFFFFFFFFFFFFFFFL;
            if (word == 0L) continue;
            return (wi << 6) + Long.numberOfTrailingZeros(word);
        }
        return wi << 6;
    }

    public int nextSet(int i) {
        if (i >= this.size) {
            return -1;
        }
        int inUse = this.size + 64 - 1 >>> 6;
        int wi = i >>> 6;
        long word = this.words[wi] & -1L << i;
        while (word == 0L) {
            if (++wi == inUse) {
                return -1;
            }
            word = this.words[wi];
        }
        return (wi << 6) + Long.numberOfTrailingZeros(word);
    }

    private void resize(int s) {
        long[] tmp = new long[Math.max(this.words.length << 1, s)];
        System.arraycopy(this.words, 0, tmp, 0, this.words.length);
        this.words = tmp;
    }
}

