/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.basex.core.MainOptions;
import org.basex.util.JarManifest;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Prop {
    public static final String USERHOME;
    public static final URL LOCATION;
    public static final String NAME = "BaseX";
    public static final String VERSION;
    public static final String AUTHOR = "Christian Gr\u00fcn";
    public static final String TEAM1 = "Alexander Holupirek, Michael Seiferle";
    public static final String TEAM2 = "Lukas Kircher, Leo W\u00f6rteler";
    public static final String ENTITY = "BaseX Team";
    public static final String NL;
    public static final String ENCODING;
    public static final String TMP;
    private static final String OS;
    public static final boolean MAC;
    public static final boolean WIN;
    public static final boolean CASE;
    public static final String DBPREFIX = "org.basex.";
    public static final String PATH = "org.basex.path";
    public static final String HOME;
    public static String language;
    public static boolean langkeys;
    public static boolean langright;
    public static boolean debug;
    public static boolean gui;

    private Prop() {
    }

    private static String homePath() {
        String dir = System.getProperty(PATH);
        if (dir != null) {
            return dir;
        }
        dir = System.getProperty("user.dir");
        String home = ".basexhome";
        File file = new File(dir, ".basexhome");
        if (!file.exists()) {
            file = new File(dir, ".basex");
        }
        if (file.exists()) {
            return file.getParent();
        }
        dir = Prop.applicationPath();
        if (dir != null) {
            file = new File(dir);
            file = new File(dir = file.isFile() ? file.getParent() : file.getPath(), ".basexhome");
            if (!file.exists()) {
                file = new File(dir, ".basex");
            }
            if (file.exists()) {
                return file.getParent();
            }
        }
        return USERHOME;
    }

    private static String applicationPath() {
        if (LOCATION == null) {
            return null;
        }
        String path = LOCATION.getPath();
        TokenBuilder tb = new TokenBuilder();
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            char ch = path.charAt(p);
            if (ch == '%' && p + 2 < pl) {
                tb.addByte((byte)Integer.parseInt(path.substring(p + 1, p + 3), 16));
                p += 2;
                continue;
            }
            tb.add(ch);
        }
        try {
            return new String(tb.finish(), ENCODING);
        }
        catch (Exception ex) {
            Util.stack(ex);
            return tb.toString();
        }
    }

    private static String dir(String dir) {
        return dir.endsWith("\\") || dir.endsWith("/") ? dir : dir + File.separator;
    }

    private static String version(String devVersion) {
        String version = Prop.class.getPackage().getImplementationVersion();
        if (version == null) {
            return devVersion;
        }
        if (!version.contains("-SNAPSHOT")) {
            return version;
        }
        StringBuilder result = new StringBuilder(version.replace("-SNAPSHOT", " beta"));
        Object revision = JarManifest.get("Implementation-Build");
        if (revision != null) {
            result.append(' ').append(revision);
        }
        return result.toString();
    }

    static {
        CodeSource cs;
        String home = System.getenv("HOME");
        USERHOME = Prop.dir(home != null ? home : System.getProperty("user.home"));
        URL loc = null;
        ProtectionDomain pd = MainOptions.class.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            loc = cs.getLocation();
        }
        LOCATION = loc;
        VERSION = Prop.version("7.8.2");
        NL = System.getProperty("line.separator");
        ENCODING = System.getProperty("file.encoding");
        TMP = Prop.dir(System.getProperty("java.io.tmpdir"));
        OS = System.getProperty("os.name");
        MAC = OS.startsWith("Mac");
        WIN = OS.startsWith("Windows");
        CASE = !MAC && !WIN;
        HOME = Prop.dir(Prop.homePath());
        language = "English";
    }
}

