/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class TokenObjMap<E>
extends TokenSet {
    private Object[] values = new Object[8];

    public void put(byte[] key, E val) {
        int i = this.put(key);
        this.values[i] = val;
    }

    public E get(byte[] key) {
        return (E)(key != null ? this.values[this.id(key)] : null);
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    public int delete(byte[] key) {
        int i = super.delete(key);
        this.values[i] = null;
        return i;
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.values = Array.copy(this.values, new Object[s]);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : this) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            if (key == null) continue;
            Object val = this.values[this.id(key)];
            tb.add(123).add(key).add(44).add(val == null ? "null" : val.toString()).add(125);
        }
        return new TokenBuilder(Util.className(this.getClass())).add(91).add(tb.finish()).add(93).toString();
    }
}

