/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.export.ExportException;
import nl.mpi.kinnate.export.ModifiedFileSearch;

public class EntityUploader {
    private SessionStorage sessionStorage;
    private EntityCollection.SearchResults searchResults = null;
    private File[] modifiedFiles = null;
    URI workspaceUri = null;
    private EntityCollection entityCollection;

    public EntityUploader(SessionStorage sessionStorage, EntityCollection entityCollection) {
        this.sessionStorage = sessionStorage;
        this.entityCollection = entityCollection;
    }

    public boolean canUpload() {
        return this.searchResults != null && this.searchResults.resultCount > 0 || this.modifiedFiles != null && this.modifiedFiles.length > 0;
    }

    public boolean isUploadComplete() {
        return this.workspaceUri != null;
    }

    public URI getWorkspaceUri() {
        return this.workspaceUri;
    }

    public String getFoundMessage() {
        String messageString = "";
        if (this.searchResults != null) {
            messageString = messageString + "Found " + this.searchResults.resultCount + " new files to upload\n";
        }
        if (this.modifiedFiles != null) {
            messageString = messageString + "Found " + this.modifiedFiles.length + " modified files to upload\n";
        }
        if (this.searchResults == null && this.modifiedFiles == null) {
            messageString = messageString + "No results found\n";
        }
        return messageString;
    }

    public String getSearchMessage() {
        return this.searchResults.statusMessage;
    }

    public void findLocalEntities(final ActionListener actionListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    EntityUploader.this.searchResults = EntityUploader.this.entityCollection.searchForLocalEntites();
                    actionListener.actionPerformed(new ActionEvent(this, 0, "seachcomplete"));
                }
                catch (EntityServiceException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                }
            }
        }.start();
    }

    public void findModifiedEntities(final ActionListener actionListener) {
        new Thread(){

            @Override
            public void run() {
                ModifiedFileSearch modifiedFileSearch = new ModifiedFileSearch();
                modifiedFileSearch.setSearchType(ModifiedFileSearch.SearchType.kmdi);
                EntityUploader.access$202(EntityUploader.this, modifiedFileSearch.getModifiedFiles(EntityUploader.this.sessionStorage.getProjectWorkingDirectory()).toArray(new File[0]));
                actionListener.actionPerformed(new ActionEvent(this, 0, "seachcomplete"));
            }
        }.start();
    }

    public URI getCreateUrl(String workspaceName) {
        try {
            return new URI("http://localhost:8080/kinoath-rest/kinoath/kinspace/" + workspaceName + "/create");
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            return null;
        }
    }

    public void uploadLocalEntites(final ActionListener actionListener, final JProgressBar uploadProgress, final JTextArea outputArea, final String workspaceName, final char[] workspacePassword) {
        new Thread(){

            @Override
            public void run() {
                try {
                    URL serverRestUrl = new URL("http://localhost:8080/kinoath-rest/kinoath/kinspace/" + workspaceName);
                    uploadProgress.setIndeterminate(false);
                    uploadProgress.setMinimum(0);
                    int maxCount = 0;
                    if (EntityUploader.this.searchResults != null) {
                        maxCount += ((EntityUploader)EntityUploader.this).searchResults.resultCount;
                    }
                    if (EntityUploader.this.modifiedFiles != null) {
                        maxCount += EntityUploader.this.modifiedFiles.length;
                    }
                    uploadProgress.setMaximum(maxCount);
                    uploadProgress.setValue(0);
                    if (EntityUploader.this.searchResults != null) {
                        for (String resultLine : ((EntityUploader)EntityUploader.this).searchResults.resultsPathArray) {
                            try {
                                EntityUploader.this.uploadFile(serverRestUrl, outputArea, new File(new URI(resultLine)));
                            }
                            catch (URISyntaxException exception) {
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                outputArea.append(exception.getMessage() + "\n");
                            }
                            uploadProgress.setValue(uploadProgress.getValue() + 1);
                        }
                    }
                    if (EntityUploader.this.modifiedFiles != null) {
                        for (File uploadFile : EntityUploader.this.modifiedFiles) {
                            EntityUploader.this.uploadFile(serverRestUrl, outputArea, uploadFile);
                            uploadProgress.setValue(uploadProgress.getValue() + 1);
                        }
                    }
                    EntityUploader.this.workspaceUri = serverRestUrl.toURI();
                    EntityUploader.this.searchResults = null;
                    EntityUploader.access$202(EntityUploader.this, null);
                    actionListener.actionPerformed(new ActionEvent(this, 0, "seachcomplete"));
                }
                catch (MalformedURLException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    outputArea.append(exception.getMessage() + "\n");
                    actionListener.actionPerformed(new ActionEvent(this, 0, "uploadaborted"));
                }
                catch (URISyntaxException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    outputArea.append(exception.getMessage() + "\n");
                    actionListener.actionPerformed(new ActionEvent(this, 0, "uploadaborted"));
                }
                catch (ExportException exception) {
                    outputArea.append(exception.getMessage() + "\n");
                    actionListener.actionPerformed(new ActionEvent(this, 0, "uploadaborted"));
                }
                uploadProgress.setValue(0);
                for (int charCount = 0; charCount < workspacePassword.length; ++charCount) {
                    workspacePassword[charCount] = '\u0000';
                }
            }
        }.start();
    }

    private void uploadFile(URL serverRestUrl, JTextArea outputArea, File uploadFile) throws ExportException {
        try {
            int bytesRead;
            HttpURLConnection httpURLConnection = (HttpURLConnection)serverRestUrl.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("PUT");
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(uploadFile));
            while ((bytesRead = bufferedInputStream.read()) > 0) {
                bufferedOutputStream.write(bytesRead);
            }
            bufferedOutputStream.close();
            bufferedInputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String responseLine = bufferedReader.readLine();
            while (responseLine != null) {
                outputArea.append(responseLine + "\n");
                responseLine = bufferedReader.readLine();
            }
            outputArea.append("\n");
            if (httpURLConnection.getResponseCode() != 200) {
                throw new ExportException(httpURLConnection.getResponseCode() + "\n" + httpURLConnection.getResponseMessage());
            }
            this.stripHistoryFiles(uploadFile);
            this.convertLocalIdentifierToUnique(null, null);
        }
        catch (IOException exception) {
            throw new ExportException(exception.getMessage());
        }
    }

    private void convertLocalIdentifierToUnique(String localIdentifier, String uniqueIdentifier) {
    }

    private void stripHistoryFiles(File targetFile) {
        ModifiedFileSearch modifiedFileSearch = new ModifiedFileSearch();
        modifiedFileSearch.stripHistoryFiles(targetFile);
    }

    static /* synthetic */ File[] access$202(EntityUploader x0, File[] x1) {
        x0.modifiedFiles = x1;
        return x1;
    }
}

