/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindata;

import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import nl.mpi.kinnate.kindata.EntityDateException;

public class EntityDate
implements Comparable<EntityDate> {
    @XmlValue
    private String fullDateString;
    @XmlTransient
    Boolean dateIsValid = null;

    public EntityDate() {
    }

    public EntityDate(String fullDateString) {
        this.fullDateString = fullDateString;
    }

    public EntityDate(String yearString, String monthString, String dayString, String qualifierString) throws EntityDateException {
        if (yearString == null) {
            throw new EntityDateException("cannot create date without a year");
        }
        if (dayString != null && monthString == null) {
            throw new EntityDateException("cannot create date with a day but no month");
        }
        this.fullDateString = dayString != null ? yearString + "/" + monthString + "/" + dayString : (monthString != null ? yearString + "/" + monthString : yearString);
        if (qualifierString != null) {
            boolean foundValidQualifier = false;
            for (String prefixString : new String[]{"abt", "bef", "aft"}) {
                if (!qualifierString.startsWith(prefixString)) continue;
                foundValidQualifier = true;
            }
            if (!foundValidQualifier) {
                throw new EntityDateException("invalid prefix: " + foundValidQualifier);
            }
            this.fullDateString = this.fullDateString + " " + qualifierString;
        }
    }

    private void checkDateString() {
        this.dateIsValid = this.fullDateString.matches("([0-9]{4}(/[0-9]{2}){0,2}(\\sabt|\\sbef|\\saft){0,1}(-[0-9]{4}(/[0-9]{2}){0,2})?(\\sabt|\\sbef|\\saft){0,1}$){0,1}");
    }

    @XmlTransient
    public String getDateString() {
        return this.fullDateString;
    }

    public boolean dateIsValid() {
        if (this.dateIsValid == null) {
            this.checkDateString();
        }
        return this.dateIsValid;
    }

    @Override
    public int compareTo(EntityDate o) {
        if (o == null) {
            return -1;
        }
        if (!this.dateIsValid() && !o.dateIsValid()) {
            return 0;
        }
        if (this.dateIsValid() && !o.dateIsValid()) {
            return -1;
        }
        if (!this.dateIsValid() && o.dateIsValid()) {
            return 1;
        }
        return this.fullDateString.compareTo(o.fullDateString);
    }
}

