/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.projects;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import nl.mpi.kinnate.projects.ProjectRecord;

@XmlRootElement(name="RecentProjects")
public class RecentProjects {
    private final int maxRecentCount = 9;
    @XmlElement(name="ProjectRecord")
    public ArrayList<ProjectRecord> recentProjects = new ArrayList();

    public void moveProjectRecordToTop(ProjectRecord projectRecord) {
        ProjectRecord existingRecord = this.recentProjects.contains(projectRecord) ? this.recentProjects.get(this.recentProjects.indexOf(projectRecord)) : projectRecord;
        this.recentProjects.remove(existingRecord);
        while (this.recentProjects.size() > 9) {
            this.recentProjects.remove(this.recentProjects.size() - 1);
        }
        this.recentProjects.add(0, existingRecord);
    }

    public void updateProjectRecord(ProjectRecord projectRecord) {
        this.recentProjects.remove(projectRecord);
        while (this.recentProjects.size() > 9) {
            this.recentProjects.remove(this.recentProjects.size() - 1);
        }
        this.recentProjects.add(0, projectRecord);
    }

    public void removeMissingProjects() {
        for (ProjectRecord projectRecord : this.recentProjects.toArray(new ProjectRecord[0])) {
            if (new File(projectRecord.getProjectDirectory(), "kinoath.proj").exists()) continue;
            this.recentProjects.remove(projectRecord);
        }
    }

    public void clearList() {
        this.recentProjects.clear();
    }

    public List<ProjectRecord> getProjectRecords() {
        return Collections.unmodifiableList(this.recentProjects);
    }
}

