/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.mpi.kinnate.svg.DiagramTranscoder;

public class DiagramTranscoderPanel
extends JPanel {
    DiagramTranscoder diagramTranscoder;
    JComboBox formatComboBox;
    JLabel ouputSizeLabel;

    public DiagramTranscoderPanel(DiagramTranscoder diagramTranscoder) {
        this.setLayout(new BorderLayout());
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 3));
        this.add((Component)outerPanel, "First");
        this.diagramTranscoder = diagramTranscoder;
        this.formatComboBox = new JComboBox();
        for (DiagramTranscoder.OutputType outputType : DiagramTranscoder.OutputType.values()) {
            this.formatComboBox.addItem(outputType.name());
        }
        this.formatComboBox.setSelectedItem(this.diagramTranscoder.getOutputType().name());
        outerPanel.add(this.formatComboBox);
        this.ouputSizeLabel = new JLabel(this.getSizeString(), 0);
        outerPanel.add(this.ouputSizeLabel);
        this.formatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagramTranscoderPanel.this.updateSettings();
            }
        });
    }

    protected void updateSettings() {
        this.diagramTranscoder.setOutputType(DiagramTranscoder.OutputType.valueOf(this.formatComboBox.getSelectedItem().toString()));
        this.ouputSizeLabel.setText(this.getSizeString());
    }

    private String getSizeString() {
        Dimension currentSize = this.diagramTranscoder.getCurrentSize();
        if (currentSize != null) {
            return (int)((Dimension2D)currentSize).getWidth() + " x " + (int)((Dimension2D)currentSize).getHeight() + " ";
        }
        return "";
    }
}

