/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;

public class KinTermTableModel
extends AbstractTableModel
implements ActionListener {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");
    SavePanel savePanel;
    KinTermGroup kinTerms;
    HashSet<KinTerm> checkBoxSet = new HashSet();
    String defaultKinType = "";
    JButton deleteSelectedButton;

    public KinTermTableModel(SavePanel savePanel, KinTermGroup kinTerms, JButton deleteSelectedButton) {
        this.savePanel = savePanel;
        this.kinTerms = kinTerms;
        this.deleteSelectedButton = deleteSelectedButton;
        deleteSelectedButton.setEnabled(false);
        deleteSelectedButton.addActionListener(this);
    }

    public void setDefaultKinType(String defaultKinType) {
        this.defaultKinType = defaultKinType;
        this.setValueAt(defaultKinType, this.kinTerms.getKinTerms().length, 1);
        this.fireTableCellUpdated(this.kinTerms.getKinTerms().length, 1);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return widgets.getString("KIN TERM");
            }
            case 1: {
                return widgets.getString("REFERENT KIN TYPE STRINGS");
            }
            case 2: {
                return widgets.getString("PROPOSITUS KIN TYPE STRINGS");
            }
            case 3: {
                return widgets.getString("DESCRIPTION");
            }
            case 4: {
                return "";
            }
        }
        throw new UnsupportedOperationException(widgets.getString("TOO MANY COLUMNS"));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.kinTerms.getKinTerms().length + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.kinTerms.getKinTerms().length <= rowIndex) {
            switch (columnIndex) {
                case 1: {
                    return this.defaultKinType;
                }
                case 4: {
                    return false;
                }
            }
            return "";
        }
        KinTerm kinTerm = this.kinTerms.getKinTerms()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return kinTerm.kinTerm;
            }
            case 1: {
                return kinTerm.alterKinTypeStrings;
            }
            case 2: {
                return kinTerm.propositusKinTypeStrings;
            }
            case 3: {
                return kinTerm.kinTermDescription;
            }
            case 4: {
                return this.checkBoxSet.contains(kinTerm);
            }
        }
        throw new UnsupportedOperationException(widgets.getString("TOO MANY COLUMNS"));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        KinTerm kinTerm;
        if (this.kinTerms.getKinTerms().length <= rowIndex) {
            switch (columnIndex) {
                case 4: {
                    if (this.checkBoxSet.isEmpty()) {
                        this.checkBoxSet.addAll(Arrays.asList(this.kinTerms.getKinTerms()));
                    } else {
                        this.checkBoxSet.clear();
                    }
                    this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
                    this.fireTableDataChanged();
                    return;
                }
                case 1: {
                    if (!this.defaultKinType.equals(aValue)) break;
                    return;
                }
            }
            if ("".equals(aValue)) {
                return;
            }
            kinTerm = new KinTerm();
            kinTerm.alterKinTypeStrings = this.defaultKinType;
            this.kinTerms.addKinTerm(kinTerm);
        } else {
            kinTerm = this.kinTerms.getKinTerms()[rowIndex];
        }
        switch (columnIndex) {
            case 0: {
                kinTerm.kinTerm = aValue.toString();
                break;
            }
            case 1: {
                kinTerm.alterKinTypeStrings = aValue.toString();
                break;
            }
            case 2: {
                kinTerm.propositusKinTypeStrings = aValue.toString();
                break;
            }
            case 3: {
                kinTerm.kinTermDescription = aValue.toString();
                break;
            }
            case 4: {
                if (((Boolean)aValue).booleanValue()) {
                    this.checkBoxSet.add(kinTerm);
                    break;
                }
                this.checkBoxSet.remove(kinTerm);
                break;
            }
            default: {
                throw new UnsupportedOperationException(widgets.getString("TOO MANY COLUMNS"));
            }
        }
        this.deleteSelectedButton.setEnabled(!this.checkBoxSet.isEmpty());
        super.setValueAt(aValue, rowIndex, columnIndex);
        this.savePanel.updateGraph();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (KinTerm kinTerm : this.checkBoxSet) {
            this.kinTerms.removeKinTerm(kinTerm);
        }
        this.checkBoxSet.clear();
        this.fireTableDataChanged();
        this.savePanel.updateGraph();
    }
}

