/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DiagramOptionsMenu
extends JMenu {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");

    public DiagramOptionsMenu(final AbstractDiagramManager diagramWindowManager, final Component parentComponent) {
        this.setText(menus.getString("DIAGRAM OPTIONS"));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                SavePanel currentSavePanel = diagramWindowManager.getCurrentSavePanel(parentComponent);
                DiagramOptionsMenu.this.removeAll();
                if (currentSavePanel != null) {
                    DiagramOptionsMenu.this.setupMenuItems(currentSavePanel, currentSavePanel.getGraphPanel());
                } else {
                    JMenuItem noItemsMenu = new JMenuItem(menus.getString("<NO ITEMS AVAILABLE IN THIS CONTEXT>"));
                    noItemsMenu.setEnabled(false);
                    DiagramOptionsMenu.this.add(noItemsMenu);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void setupMenuItems(final SavePanel currentSavePanel, final GraphPanel graphPanel) {
        JCheckBoxMenuItem snapToGridMenuItem = new JCheckBoxMenuItem(menus.getString("SNAP TO GRID"));
        snapToGridMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.snapToGrid = !graphPanel.dataStoreSvg.snapToGrid;
            }
        });
        this.add(snapToGridMenuItem);
        JCheckBoxMenuItem highlightRelationsMenuItem = new JCheckBoxMenuItem(menus.getString("HIGHLIGHT SELECTED RELATIONS"));
        highlightRelationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.highlightRelationLines = !graphPanel.dataStoreSvg.highlightRelationLines;
                graphPanel.drawNodes(false);
            }
        });
        this.add(highlightRelationsMenuItem);
        JCheckBoxMenuItem showBorderMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW DIAGRAM BORDER"));
        showBorderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showDiagramBorder = !graphPanel.dataStoreSvg.showDiagramBorder;
                graphPanel.drawNodes(true);
            }
        });
        this.add(showBorderMenuItem);
        JCheckBoxMenuItem showSanguineLinesMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW SANGUIN LINES"));
        showSanguineLinesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showSanguineLines = !graphPanel.dataStoreSvg.showSanguineLines;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showSanguineLinesMenuItem);
        this.add(new JPopupMenu.Separator());
        JCheckBoxMenuItem showLabelssMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW ENTITY LABELS"));
        showLabelssMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showLabels = !graphPanel.dataStoreSvg.showLabels;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showLabelssMenuItem);
        JCheckBoxMenuItem showKinTypeLabelssMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW KIN TYPE LABELS"));
        showKinTypeLabelssMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showKinTypeLabels = !graphPanel.dataStoreSvg.showKinTypeLabels;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showKinTypeLabelssMenuItem);
        JCheckBoxMenuItem showIdLabelsMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW ID LABELS"));
        showIdLabelsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showIdLabels = !graphPanel.dataStoreSvg.showIdLabels;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showIdLabelsMenuItem);
        JCheckBoxMenuItem showDateLabelsMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW DATE LABELS"));
        showDateLabelsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showDateLabels = !graphPanel.dataStoreSvg.showDateLabels;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showDateLabelsMenuItem);
        JCheckBoxMenuItem showArchiveLinksMenuItem = new JCheckBoxMenuItem(menus.getString("SHOW EXTERNAL LINK LABELS"));
        showArchiveLinksMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphPanel.dataStoreSvg.showExternalLinks = !graphPanel.dataStoreSvg.showExternalLinks;
                graphPanel.drawNodes(false);
            }
        });
        this.add(showArchiveLinksMenuItem);
        this.add(new JPopupMenu.Separator());
        JMenuItem diagramSettings = new JMenuItem(menus.getString("SETTINGS"));
        diagramSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                currentSavePanel.showSettings();
            }
        });
        this.add(diagramSettings);
        snapToGridMenuItem.setSelected(graphPanel.dataStoreSvg.snapToGrid);
        highlightRelationsMenuItem.setSelected(graphPanel.dataStoreSvg.highlightRelationLines);
        showBorderMenuItem.setSelected(graphPanel.dataStoreSvg.showDiagramBorder);
        showSanguineLinesMenuItem.setSelected(graphPanel.dataStoreSvg.showSanguineLines);
        showLabelssMenuItem.setSelected(graphPanel.dataStoreSvg.showLabels);
        showKinTypeLabelssMenuItem.setSelected(graphPanel.dataStoreSvg.showKinTypeLabels);
        showIdLabelsMenuItem.setSelected(graphPanel.dataStoreSvg.showIdLabels);
        showDateLabelsMenuItem.setSelected(graphPanel.dataStoreSvg.showDateLabels);
        showArchiveLinksMenuItem.setSelected(graphPanel.dataStoreSvg.showExternalLinks);
    }
}

