/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class DiagramPanelsMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private AbstractDiagramManager diagramWindowManager;
    private Component parentComponent;

    public DiagramPanelsMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.setText(menus.getString("PANELS"));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                DiagramPanelsMenu.this.setupMenuItems();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void setupMenuItems() {
        this.removeAll();
        boolean menuItemsAdded = false;
        KinTermSavePanel kinTermPanel = this.diagramWindowManager.getKinTermPanel(this.parentComponent);
        if (kinTermPanel != null) {
            Object[] visiblePanelsArray = kinTermPanel.getVisiblePanels();
            Arrays.sort(visiblePanelsArray);
            for (Object panelSetting : visiblePanelsArray) {
                if (((VisiblePanelSetting)panelSetting).getPanelType() == null) continue;
                menuItemsAdded = true;
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(((VisiblePanelSetting)panelSetting).getDisplayName());
                menuItem.setSelected(((VisiblePanelSetting)panelSetting).isPanelShown());
                menuItem.setActionCommand(((VisiblePanelSetting)panelSetting).getPanelType().name());
                menuItem.addActionListener(this);
                menuItem.setEnabled(((VisiblePanelSetting)panelSetting).isMenuEnabled());
                this.add(menuItem);
            }
        }
        if (!menuItemsAdded) {
            JMenuItem noItemsMenu = new JMenuItem(menus.getString("<NO ITEMS AVAILABLE IN THIS CONTEXT>"));
            noItemsMenu.setEnabled(false);
            this.add(noItemsMenu);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VisiblePanelSetting.PanelType selectedPanelType = VisiblePanelSetting.PanelType.valueOf(e.getActionCommand());
        KinTermSavePanel kinTermPanel = this.diagramWindowManager.getKinTermPanel(this.parentComponent);
        if (kinTermPanel != null) {
            for (VisiblePanelSetting panelSetting : kinTermPanel.getVisiblePanels()) {
                if (!selectedPanelType.equals((Object)panelSetting.getPanelType())) continue;
                panelSetting.setPanelShown(!panelSetting.isPanelShown());
            }
        }
    }
}

