/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.svg.MouseListenerSvg;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class EditMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    JMenuItem selectAllMenu = null;
    JMenuItem selectRelatedMenu = null;
    JMenuItem expandSelectionMenu = null;
    JMenuItem deselectAllMenu = null;
    JMenuItem recalculateDiagramMenuItem = null;
    SavePanel menuSavePanel = null;
    AbstractDiagramManager diagramWindowManager;
    private Component parentComponent;

    public EditMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.setText(menus.getString("EDIT"));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
                EditMenu.this.enableMenuKeys();
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
                EditMenu.this.enableMenuKeys();
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                EditMenu.this.initMenu();
            }
        });
        this.selectAllMenu = new JMenuItem(menus.getString("SELECT ALL"));
        this.selectAllMenu.setActionCommand(MouseListenerSvg.ActionCode.selectAll.name());
        this.selectAllMenu.addActionListener(this);
        this.selectAllMenu.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectRelatedMenu = new JMenuItem(menus.getString("SELECT RELATED"));
        this.selectRelatedMenu.setActionCommand(MouseListenerSvg.ActionCode.selectRelated.name());
        this.selectRelatedMenu.addActionListener(this);
        this.selectRelatedMenu.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.expandSelectionMenu = new JMenuItem(menus.getString("EXPAND SELECTION"));
        this.expandSelectionMenu.setActionCommand(MouseListenerSvg.ActionCode.expandSelection.name());
        this.expandSelectionMenu.addActionListener(this);
        this.expandSelectionMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.deselectAllMenu = new JMenuItem(menus.getString("DESELECT ALL"));
        this.deselectAllMenu.setActionCommand(MouseListenerSvg.ActionCode.deselectAll.name());
        this.deselectAllMenu.addActionListener(this);
        this.deselectAllMenu.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.recalculateDiagramMenuItem = new JMenuItem(menus.getString("RECALCULATE THE DIAGRAM"));
        this.recalculateDiagramMenuItem.setActionCommand("RecalculateDiagram");
        this.recalculateDiagramMenuItem.addActionListener(this);
        this.add(this.selectAllMenu);
        this.add(this.selectRelatedMenu);
        this.add(this.expandSelectionMenu);
        this.add(this.deselectAllMenu);
        this.add(this.recalculateDiagramMenuItem);
        this.enableMenuKeys();
    }

    private void initMenu() {
        this.menuSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        boolean savePanelFocused = this.menuSavePanel != null;
        this.selectAllMenu.setEnabled(savePanelFocused);
        this.selectRelatedMenu.setEnabled(savePanelFocused);
        this.expandSelectionMenu.setEnabled(savePanelFocused);
        this.deselectAllMenu.setEnabled(savePanelFocused);
        this.recalculateDiagramMenuItem.setEnabled(savePanelFocused);
    }

    private void enableMenuKeys() {
        this.menuSavePanel = null;
        this.selectAllMenu.setEnabled(true);
        this.selectRelatedMenu.setEnabled(true);
        this.expandSelectionMenu.setEnabled(true);
        this.deselectAllMenu.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.menuSavePanel == null) {
            this.menuSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        }
        if (this.menuSavePanel != null) {
            if (e.getActionCommand().equals("RecalculateDiagram")) {
                this.menuSavePanel.updateGraph();
            } else {
                this.menuSavePanel.doActionCommand(MouseListenerSvg.ActionCode.valueOf(e.getActionCommand()));
            }
        }
        this.enableMenuKeys();
    }
}

