/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.plugins.KinOathPluginManager;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.ui.menu.DiagramOptionsMenu;
import nl.mpi.kinnate.ui.menu.DiagramPanelsMenu;
import nl.mpi.kinnate.ui.menu.EditMenu;
import nl.mpi.kinnate.ui.menu.FileMenu;
import nl.mpi.kinnate.ui.menu.HelpMenu;
import nl.mpi.kinnate.ui.menu.KinTermsMenu;
import nl.mpi.kinnate.ui.menu.WindowMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.pluginloader.PluginManager;
import nl.mpi.pluginloader.PluginService;
import nl.mpi.pluginloader.ui.PluginMenu;

public class MainMenuBar
extends JMenuBar {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");

    public MainMenuBar(AbstractDiagramManager abstractDiagramManager, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ApplicationVersionManager versionManager, Component parentComponent, ProjectManager projectManager, ArbilLogConfigurer arbilLogConfigurer) {
        this.add(new FileMenu(abstractDiagramManager, sessionStorage, (MessageDialogHandler)dialogHandler, parentComponent, projectManager));
        this.add(new EditMenu(abstractDiagramManager, parentComponent));
        this.add(new DiagramOptionsMenu(abstractDiagramManager, parentComponent));
        this.add(new KinTermsMenu(abstractDiagramManager, parentComponent));
        this.add(new DiagramPanelsMenu(abstractDiagramManager, parentComponent));
        ArrayList<URL> pluginUlrs = new ArrayList<URL>();
        String errorMessages = "";
        try {
            String[] pluginStringArray = sessionStorage.loadStringArray("PluginList");
            if (pluginStringArray != null) {
                for (String pluginString : pluginStringArray) {
                    try {
                        pluginUlrs.add(new URL(pluginString));
                    }
                    catch (MalformedURLException exception) {
                        System.out.println(exception.getMessage());
                        errorMessages = errorMessages + MessageFormat.format(menus.getString("COULD NOT LOAD PLUGIN: {0}"), pluginString) + "\n";
                    }
                }
            }
            if (!"".equals(errorMessages)) {
                dialogHandler.addMessageDialogToQueue(errorMessages, menus.getString("PLUGIN ERROR"));
            }
        }
        catch (IOException ex) {
            System.out.println("PluginList not found");
        }
        this.add((JMenu)new PluginMenu(new PluginService(pluginUlrs.toArray(new URL[0])), (PluginManager)new KinOathPluginManager(abstractDiagramManager, dialogHandler, parentComponent), false));
        this.add(new WindowMenu(abstractDiagramManager, parentComponent));
        this.add(new HelpMenu(abstractDiagramManager, dialogHandler, sessionStorage, versionManager, parentComponent, arbilLogConfigurer));
    }
}

