/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.ui.window.SavePanelFrame;

public class WindowedDiagramManager
extends AbstractDiagramManager {
    private HashMap<JFrame, String> titleMap = new HashMap();
    private ArrayList<JFrame> diagramArray = new ArrayList();

    public WindowedDiagramManager(ApplicationVersionManager versionManager, ArbilWindowManager dialogHandler, SessionStorage sessionStorage, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, ProjectManager projectManager, ArbilLogConfigurer arbilLogConfigurer, ArbilTableController arbilTableController, ArbilWindowManager windowManager) {
        super(versionManager, dialogHandler, sessionStorage, dataNodeLoader, treeHelper, projectManager, arbilLogConfigurer, arbilTableController, windowManager);
    }

    @Override
    public void createApplicationWindow() {
    }

    @Override
    protected void closeWindowAction(JFrame windowFrame) {
        if (this.diagramArray.size() == 1) {
            super.closeWindowAction(windowFrame);
        } else {
            int selectedIndex = this.diagramArray.indexOf(windowFrame);
            if (windowFrame instanceof SavePanel) {
                SavePanel savePanel = (SavePanel)((Object)windowFrame);
                String diagramTitle = this.getSavePanelTitle(selectedIndex);
                boolean userCanceled = this.offerUserToSave(savePanel, diagramTitle);
                if (!userCanceled) {
                    this.closeSavePanel(selectedIndex);
                }
            } else {
                this.closeSavePanel(selectedIndex);
            }
        }
    }

    @Override
    public Component createDiagramContainer(Component diagramComponent, Rectangle preferredSizeLocation) {
        String diagramTitle = diagramComponent.getName();
        JFrame diagramWindow = super.createDiagramWindow(diagramTitle, diagramComponent, preferredSizeLocation);
        this.titleMap.put(diagramWindow, diagramTitle);
        this.diagramArray.add(diagramWindow);
        return diagramWindow;
    }

    @Override
    public void createDiagramSubPanel(String diagramTitle, Component diagramComponent, Component parentPanel) {
        JTabbedPane tabbedPane;
        JFrame diagramFame = (JFrame)parentPanel;
        Container currentComponent = diagramFame.getContentPane();
        if (!(currentComponent instanceof JTabbedPane)) {
            tabbedPane = new JTabbedPane();
            String savePanelTitle = currentComponent.getName();
            tabbedPane.addTab(savePanelTitle, currentComponent);
            diagramFame.setContentPane(tabbedPane);
        } else {
            tabbedPane = (JTabbedPane)currentComponent;
        }
        tabbedPane.addTab(diagramTitle, diagramComponent);
    }

    @Override
    Component getSelectedDiagram() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedDiagram(Component diagramComponent) {
        ((JFrame)diagramComponent).toFront();
    }

    @Override
    public void setSelectedDiagram(int diagramIndex) {
        if (this.diagramArray.size() > diagramIndex) {
            this.setSelectedDiagram(this.diagramArray.get(diagramIndex));
        } else {
            this.setSelectedDiagram(null);
        }
    }

    @Override
    public int getSavePanelIndex(Component parentComponent) {
        return this.diagramArray.indexOf(parentComponent);
    }

    @Override
    public SavePanel getCurrentSavePanel(Component parentComponent) {
        Container contentPane;
        if (parentComponent instanceof SavePanelFrame && (contentPane = ((SavePanelFrame)parentComponent).getContentPane()) instanceof SavePanel) {
            return (SavePanel)((Object)contentPane);
        }
        if (parentComponent instanceof SavePanel) {
            return (SavePanel)((Object)parentComponent);
        }
        return null;
    }

    @Override
    public String getSavePanelTitle(int selectedIndex) {
        return this.titleMap.get(this.diagramArray.get(selectedIndex));
    }

    @Override
    Component getDiagramAt(int diagramIndex) {
        return this.diagramArray.get(diagramIndex);
    }

    @Override
    public void closeSavePanel(int selectedIndex) {
        JFrame diagramFrame = this.diagramArray.get(selectedIndex);
        this.titleMap.remove(this.diagramArray.get(selectedIndex));
        this.diagramArray.remove(selectedIndex);
        diagramFrame.dispose();
        while (this.diagramArray.size() <= selectedIndex && selectedIndex > 0) {
            --selectedIndex;
        }
        this.setSelectedDiagram(selectedIndex);
    }

    @Override
    public void setDiagramTitle(int diagramIndex, String diagramTitle) {
        this.titleMap.put(this.diagramArray.get(diagramIndex), diagramTitle);
        this.setWindowTitle(this.diagramArray.get(diagramIndex), diagramTitle);
    }

    @Override
    public Component[] getAllDiagrams() {
        return this.diagramArray.toArray(new Component[0]);
    }
}

