/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.flap.module.AbstractBaseModule;
import nl.mpi.flap.plugin.KinOathPanelPlugin;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExport;
import nl.mpi.kinnate.plugins.export.ui.FileSelectPanel;
import org.basex.core.BaseXException;

public class CsvExport
extends AbstractBaseModule
implements KinOathPanelPlugin {
    private String exportProject;

    public CsvExport() throws PluginException {
        super("CSV file export", "Exports CSV files.", "nl.mpi.kinnate.plugins.export");
    }

    public JScrollPane getUiPanel(PluginDialogHandler dialogHandler, final PluginSessionStorage sessionStorage, PluginBugCatcher bugCatcher) throws PluginException {
        final CollectionExport entityCollection = new CollectionExport(bugCatcher, sessionStorage);
        final FileSelectPanel fileSelectPanel = new FileSelectPanel(dialogHandler, sessionStorage, "CsvExport");
        this.exportProject = sessionStorage.loadString("nl.mpi.kinnate.plugins.export.CsvExport.exportProject");
        JPanel pluginPanel = new JPanel(new BorderLayout());
        JTextArea textPane = new JTextArea("This plugin will export an entire project into a CSV file for processing in R.\nTo use, select the project then browse for the file into which you wish to export your data and click \"run\".");
        try {
            String[] databaseList = entityCollection.listDatabases();
            final JComboBox<String> projectSelectBox = new JComboBox<String>(databaseList);
            projectSelectBox.setSelectedItem(this.exportProject);
            projectSelectBox.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    CsvExport.this.exportProject = projectSelectBox.getSelectedItem().toString();
                    sessionStorage.saveString("nl.mpi.kinnate.plugins.export.CsvExport.exportProject", CsvExport.this.exportProject);
                }
            });
            pluginPanel.add(projectSelectBox, "Before");
        }
        catch (BaseXException baseXException) {
            textPane.setText(baseXException.getMessage());
        }
        pluginPanel.add((Component)textPane, "Center");
        final JLabel errorLabel = new JLabel();
        pluginPanel.add((Component)new JButton(new AbstractAction("run"){

            public void actionPerformed(ActionEvent e) {
                errorLabel.setText("running...");
                try {
                    System.out.println("fileSelectPanel:" + fileSelectPanel.getExportFile().toString());
                    String exportQueryResult = entityCollection.performExportQuery("db:list()");
                    System.out.println(exportQueryResult);
                    FileWriter fileWriter = new FileWriter(fileSelectPanel.getExportFile());
                    fileWriter.write(exportQueryResult);
                    fileWriter.close();
                    errorLabel.setText("Export file complete.\n");
                }
                catch (QueryException exception) {
                    errorLabel.setText(exception.getMessage());
                }
                catch (IOException exception) {
                    errorLabel.setText(exception.getMessage());
                }
            }
        }), "After");
        pluginPanel.add((Component)fileSelectPanel, "First");
        pluginPanel.add((Component)errorLabel, "Last");
        return new JScrollPane(pluginPanel);
    }
}

