/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExport;
import nl.mpi.kinnate.plugins.export.GedcomExport;
import nl.mpi.kinnate.plugins.export.ui.FieldsPanel;
import nl.mpi.kinnate.plugins.export.ui.ResultsPanel;

public class ExportPanel
extends JPanel
implements ActionListener {
    PluginDialogHandler arbilWindowManager;
    GedcomExport gedcomExport;
    FieldsPanel fieldsPanel;
    JTabbedPane outerTabbedPane;

    public ExportPanel(PluginDialogHandler arbilWindowManager, GedcomExport gedcomExport, JTabbedPane jTabbedPane) {
        this.arbilWindowManager = arbilWindowManager;
        this.gedcomExport = gedcomExport;
        this.outerTabbedPane = jTabbedPane;
        this.fieldsPanel = new FieldsPanel(gedcomExport);
        this.fieldsPanel.populateFields();
        this.setLayout(new BorderLayout());
        this.add((Component)this.fieldsPanel, "Center");
        JButton exportButton = new JButton("Export");
        exportButton.addActionListener(this);
        this.add((Component)exportButton, "Last");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.fieldsPanel.namesAreUnique()) {
                final String queryString = this.gedcomExport.generateExport(this.fieldsPanel.getSelectedFieldNames(), this.fieldsPanel.getSelectedFieldPaths());
                this.outerTabbedPane.add("Query Text", new JScrollPane(new JTextArea(queryString)));
                SwingUtilities.invokeLater(new Thread(){

                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            String resultsString = ExportPanel.this.gedcomExport.generateExport(queryString);
                            long queryMils = System.currentTimeMillis() - startTime;
                            String queryTimeString = "Query time: " + queryMils + "ms";
                            ResultsPanel resultsPanel = new ResultsPanel();
                            ExportPanel.this.outerTabbedPane.add("Results Text", new JScrollPane(new JTextArea(resultsString)));
                            ExportPanel.this.outerTabbedPane.add("Results Table", resultsPanel);
                            resultsPanel.updateTable(resultsString);
                            ExportPanel.this.revalidate();
                            ExportPanel.this.repaint();
                        }
                        catch (QueryException exception) {
                            ExportPanel.this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Generate Table");
                        }
                    }
                });
            } else {
                this.arbilWindowManager.addMessageDialogToQueue("The chosen field names are not unique", "Export Error");
            }
        }
        catch (QueryException exception) {
            this.arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Export Error");
        }
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame("Fields Panel Test");
        jFrame.setDefaultCloseOperation(3);
        CollectionExport entityCollection = new CollectionExport(new PluginBugCatcher(){

            public void logException(PluginException exception) {
                System.err.println(exception.getMessage());
            }
        }, new PluginSessionStorage(){

            public String loadString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void saveString(String string, String string1) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public File getApplicationSettingsDirectory() {
                return new File("/Users/petwit2/.arbil/");
            }

            public File getProjectDirectory() {
                return new File("/Users/petwit2/.arbil/");
            }

            public File getProjectWorkingDirectory() {
                return new File("/Users/petwit2/.arbil/ArbilWorkingFiles/");
            }
        });
        GedcomExport gedcomExport = new GedcomExport(entityCollection);
        JTabbedPane jTabbedPane = new JTabbedPane();
        ExportPanel exportPanel = new ExportPanel(new PluginDialogHandler(){

            public void addMessageDialogToQueue(String messageString, String messageTitle) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean showConfirmDialogBox(String messageString, String messageTitle) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int showDialogBox(String message, String title, int optionType, int messageType) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int showDialogBox(String message, String title, int optionType, int messageType, Object[] options, Object initialValue) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public File[] showFileSelectBox(String titleText, boolean directorySelectOnly, boolean multipleSelect, Map<String, FileFilter> fileFilterMap, PluginDialogHandler.DialogueType dialogueType, JComponent customAccessory) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }, gedcomExport, jTabbedPane);
        jTabbedPane.add("Import", exportPanel);
        jFrame.setContentPane(jTabbedPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

