/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.entityindexer.CollectionExport;
import nl.mpi.kinnate.plugins.export.GedcomExport;

public class FieldsPanel
extends JPanel {
    GedcomExport gedcomExport;
    final JLabel queryTimeLabel = new JLabel();
    private String[] selectedFieldNames;
    private String[] selectedFieldPaths;
    private JTextArea[] fieldTextAreas;
    private Color defaultTextBackground;

    public FieldsPanel(GedcomExport gedcomExport) {
        this.gedcomExport = gedcomExport;
        this.setLayout(new BorderLayout());
        this.add((Component)this.queryTimeLabel, "Last");
    }

    public String[] getSelectedFieldNames() {
        return this.selectedFieldNames;
    }

    public String[] getSelectedFieldPaths() {
        return this.selectedFieldPaths;
    }

    public void populateFields() {
        this.queryTimeLabel.setText("getting fields list...");
        String queryString = this.gedcomExport.getHeaderQuery();
        try {
            long startTime = System.currentTimeMillis();
            String queryResult = this.gedcomExport.generateExport(queryString);
            long queryMils = System.currentTimeMillis() - startTime;
            String queryTimeString = "Query time: " + queryMils + "ms";
            this.queryTimeLabel.setText(queryTimeString);
            String queryResultTidy = queryResult.replaceAll("\"[^\"]*\":", "*:");
            String[] splitResults = queryResultTidy.split(" ");
            JPanel fieldsPanel = new JPanel(new GridLayout(splitResults.length, 2, 2, 2));
            this.selectedFieldNames = new String[splitResults.length];
            this.selectedFieldPaths = new String[splitResults.length];
            this.fieldTextAreas = new JTextArea[splitResults.length];
            for (int currentIndex = 0; currentIndex < splitResults.length; ++currentIndex) {
                String currentField = splitResults[currentIndex];
                this.selectedFieldNames[currentIndex] = currentField.replaceAll("^.*:", "").replaceFirst("\\[\\d*\\]$", "");
                this.selectedFieldPaths[currentIndex] = currentField;
                fieldsPanel.add(new JLabel(this.selectedFieldPaths[currentIndex]));
                this.fieldTextAreas[currentIndex] = new JTextArea(this.selectedFieldNames[currentIndex]);
                this.fieldTextAreas[currentIndex].getDocument().addDocumentListener(new DocumentListener(){

                    public void changedUpdate(DocumentEvent e) {
                        FieldsPanel.this.namesAreUnique();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        FieldsPanel.this.namesAreUnique();
                    }

                    public void insertUpdate(DocumentEvent e) {
                        FieldsPanel.this.namesAreUnique();
                    }
                });
                fieldsPanel.add(this.fieldTextAreas[currentIndex]);
            }
            if (this.fieldTextAreas.length > 0) {
                this.defaultTextBackground = this.fieldTextAreas[0].getBackground();
            }
            this.add((Component)fieldsPanel, "Center");
        }
        catch (QueryException exception) {
            this.queryTimeLabel.setText("Error: " + exception.getMessage() + "\n");
        }
    }

    public boolean namesAreUnique() {
        boolean namesAreUnique = true;
        ArrayList<String> fieldNames = new ArrayList<String>();
        final boolean[] validFields = new boolean[this.fieldTextAreas.length];
        for (int fieldCounter = 0; fieldCounter < this.fieldTextAreas.length; ++fieldCounter) {
            String currentText;
            JTextArea currentTextArea = this.fieldTextAreas[fieldCounter];
            this.selectedFieldNames[fieldCounter] = currentText = currentTextArea.getText();
            if (fieldNames.contains(currentText)) {
                validFields[fieldCounter] = false;
                namesAreUnique = false;
            } else {
                validFields[fieldCounter] = true;
            }
            fieldNames.add(currentText);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int fieldCounter = 0; fieldCounter < FieldsPanel.this.fieldTextAreas.length; ++fieldCounter) {
                    if (validFields[fieldCounter]) {
                        FieldsPanel.this.fieldTextAreas[fieldCounter].setBackground(FieldsPanel.this.defaultTextBackground);
                        continue;
                    }
                    FieldsPanel.this.fieldTextAreas[fieldCounter].setBackground(Color.red);
                }
            }
        });
        return namesAreUnique;
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame("Fields Panel Test");
        jFrame.setDefaultCloseOperation(3);
        CollectionExport entityCollection = new CollectionExport(new PluginBugCatcher(){

            public void logException(PluginException exception) {
                System.err.println(exception.getMessage());
            }
        }, new PluginSessionStorage(){

            public String loadString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void saveString(String string, String string1) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public File getApplicationSettingsDirectory() {
                return new File("/Users/petwit2/.arbil/");
            }

            public File getProjectDirectory() {
                return new File("/Users/petwit2/.arbil/");
            }

            public File getProjectWorkingDirectory() {
                return new File("/Users/petwit2/.arbil/ArbilWorkingFiles/");
            }
        });
        GedcomExport gedcomExport = new GedcomExport(entityCollection);
        FieldsPanel fieldsPanel = new FieldsPanel(gedcomExport);
        fieldsPanel.populateFields();
        jFrame.setContentPane(fieldsPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

