/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.access.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.access.statistics.HitInfo;
import nl.mpi.access.statistics.SingleHit;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.DBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessStatsAPI {
    private static Logger logger = LoggerFactory.getLogger(AccessStatsAPI.class);
    private final String accessTable = "access_all";
    private final String accessIndexTable = "access_index";
    private final String archiveObjectsTable = "archiveobjects";
    private String serverName;
    private boolean writeable = false;
    private PreparedStatement testSTM = null;
    private PreparedStatement getNodeIdSTM = null;
    private PreparedStatement getObjectCountSTM = null;
    private PreparedStatement addIndexLineSTM = null;
    private PreparedStatement updateIndexCounterSTM = null;
    private PreparedStatement addHitSTM = null;
    private PreparedStatement getCountSTM = null;
    private PreparedStatement getStatsSTM = null;
    private PreparedStatement getUrlSTM = null;
    private DBConnection dbCon = null;
    private static final String dateFormatString = "dd/MMM/yyyy:hh:mm:ss Z";
    private static final Pattern nodeIdPattern = Pattern.compile("MPI(\\d+)#");
    private static final Pattern p = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)\\ -\\ (.*?)\\ \\[(.*?)\\]\\ \"GET (.+?)\\ .*?\"\\ (\\d+)\\ (\\d*)-?\\ \"(.*?)\"\\ \"(.*?)\"");

    private void CommonInit(String loggedServerName) {
        this.serverName = loggedServerName;
    }

    public AccessStatsAPI(String jdbcURL, String loggedServerName) {
        this.CommonInit(loggedServerName);
        logger.info("Creating read-only AccessStats object...");
        this.dbCon = new DBConnection(jdbcURL, "AccessStatsAPI/readonly");
        if (!this.prepareStatements(false)) {
            this.close();
        }
    }

    public AccessStatsAPI(String jdbcURL, String user, String pass, String loggedServerName) {
        this.CommonInit(loggedServerName);
        logger.info("Creating read-write AccessStats object...");
        this.dbCon = new DBConnection(jdbcURL, user, pass, "AccessStatsAPI/writeable");
        if (this.getStatus("open writeable connection")) {
            this.writeable = true;
        }
        this.initDB();
        if (!this.prepareStatements(true)) {
            this.close();
        }
        if (!this.getStatus("verify writeable connection")) {
            this.writeable = false;
        }
    }

    public boolean getStatus(String what) {
        if (this.dbCon != null && this.dbCon.getStatus()) {
            return true;
        }
        logger.error("AccessStats: DB connection problem in " + what);
        return false;
    }

    public void close() {
        if (this.dbCon != null) {
            this.dbCon.close();
        }
        this.dbCon = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initDB() {
        if (!this.getStatus("initDB")) {
            return false;
        }
        if (!this.writeable) {
            logger.error("initDB requires write-enabled connection");
            return false;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            boolean noTable = true;
            statement = this.dbCon.getConnection().createStatement();
            try {
                rs = statement.executeQuery("SELECT count (*)  FROM access_all");
                if (rs.next()) {
                    noTable = false;
                }
            }
            catch (SQLException sqle1) {
                noTable = true;
            }
            if (noTable) {
                logger.warn("initDB: access log table does not exist - creating it...");
                statement.execute("CREATE " + this.dbCon.tableType + " TABLE " + "access_all" + "( nodeid INTEGER REFERENCES corpusnodes ON DELETE CASCADE" + ", date TIMESTAMP " + ", useragent VARCHAR(255) " + ")");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            noTable = true;
            try {
                rs = statement.executeQuery("SELECT count (*)  FROM access_index");
                if (rs.next()) {
                    noTable = false;
                }
            }
            catch (SQLException sqle1) {
                noTable = true;
            }
            if (noTable) {
                logger.warn("initDB: access index table does not exist - creating it...");
                statement.execute("CREATE " + this.dbCon.tableType + " TABLE " + "access_index" + "( nodeid INTEGER REFERENCES corpusnodes ON DELETE CASCADE" + ", counter bigint " + ")");
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle2) {
            logger.error("initDB: SQL exception ", (Throwable)sqle2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("initDB: Failed to close resultset" + e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.warn("initDB: failed to close statement: " + e);
                }
            }
        }
    }

    private boolean prepareStatements(boolean write) {
        try {
            this.testSTM = this.dbCon.getConnection().prepareStatement("SELECT count(*) FROM corpusnodes");
            this.getNodeIdSTM = this.dbCon.getConnection().prepareStatement("SELECT nodeid FROM archiveobjects WHERE url = ?");
            this.getObjectCountSTM = this.dbCon.getConnection().prepareStatement("SELECT counter FROM access_index WHERE nodeid = ?");
            this.getCountSTM = this.dbCon.getConnection().prepareStatement("SELECT counter FROM access_index WHERE nodeid = ?");
            this.getStatsSTM = this.dbCon.getConnection().prepareStatement("SELECT date,useragent FROM access_all WHERE nodeid = ?");
            this.getUrlSTM = this.dbCon.getConnection().prepareStatement("SELECT url FROM archiveobjects WHERE nodeid = ?");
            if (!write) {
                return true;
            }
            this.addIndexLineSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO access_index (nodeid, counter) VALUES (?, ?)");
            this.updateIndexCounterSTM = this.dbCon.getConnection().prepareStatement("UPDATE access_index SET counter = ? WHERE nodeid = ?");
            this.addHitSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO access_all (nodeid, date, useragent) VALUES (?, ?, ?)");
            return true;
        }
        catch (SQLException sqle) {
            logger.error("createStatements: SQLException: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    private boolean unprepareStatements() {
        try {
            if (this.testSTM != null) {
                this.testSTM.close();
                this.testSTM = null;
            }
            if (this.getNodeIdSTM != null) {
                this.getNodeIdSTM.close();
                this.getNodeIdSTM = null;
            }
            if (this.getObjectCountSTM != null) {
                this.getObjectCountSTM.close();
                this.getObjectCountSTM = null;
            }
            if (this.getCountSTM != null) {
                this.getCountSTM.close();
                this.getCountSTM = null;
            }
            if (this.getStatsSTM != null) {
                this.getStatsSTM.close();
                this.getStatsSTM = null;
            }
            if (this.getUrlSTM != null) {
                this.getUrlSTM.close();
                this.getUrlSTM = null;
            }
            if (this.addIndexLineSTM != null) {
                this.addIndexLineSTM.close();
                this.addIndexLineSTM = null;
            }
            if (this.updateIndexCounterSTM != null) {
                this.updateIndexCounterSTM.close();
                this.updateIndexCounterSTM = null;
            }
            if (this.addHitSTM != null) {
                this.addHitSTM.close();
                this.addHitSTM = null;
            }
            return true;
        }
        catch (SQLException sqle) {
            logger.error("unprepareStatements: SQLException: " + sqle, (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countUp(Integer nodeId) {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getObjectCountSTM;
            synchronized (preparedStatement) {
                this.getObjectCountSTM.setInt(1, nodeId);
                rs = this.getObjectCountSTM.executeQuery();
                if (rs.next()) {
                    Integer count = rs.getInt(1);
                    logger.info("SHOULD NOW BE Increasing count for node " + nodeId + " to " + (count + 1) + "...");
                    try {
                        PreparedStatement preparedStatement2 = this.updateIndexCounterSTM;
                        synchronized (preparedStatement2) {
                            this.updateIndexCounterSTM.setLong(1, count + 1);
                            this.updateIndexCounterSTM.setInt(2, nodeId);
                            logger.info("Executing SQL command: " + this.updateIndexCounterSTM);
                            this.updateIndexCounterSTM.execute();
                        }
                    }
                    catch (SQLException sqlEx3) {
                        logger.error("Error writing to table access_index: " + sqlEx3);
                    }
                } else {
                    logger.info("Adding NEW line for node " + nodeId + " to table " + "access_index" + "...");
                    try {
                        PreparedStatement sqlEx3 = this.addIndexLineSTM;
                        synchronized (sqlEx3) {
                            this.addIndexLineSTM.setInt(1, nodeId);
                            this.addIndexLineSTM.setLong(2, 1L);
                            this.addIndexLineSTM.execute();
                        }
                    }
                    catch (SQLException sqlEx2) {
                        logger.error("Error writing to table access_index: " + sqlEx2);
                    }
                }
            }
        }
        catch (SQLException sqlEx) {
            logger.error("Error reading count for nodeid " + nodeId + " from table " + "access_index" + "!");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("countUp: Failed to close resultset: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHit(int nodeid, Date date, String useragent) {
        try {
            PreparedStatement preparedStatement = this.addHitSTM;
            synchronized (preparedStatement) {
                Timestamp sqlDate = new Timestamp(date.getTime());
                this.addHitSTM.setInt(1, nodeid);
                this.addHitSTM.setTimestamp(2, sqlDate);
                this.addHitSTM.setString(3, useragent);
                logger.info("Executing SQL command: " + this.addHitSTM);
                this.addHitSTM.execute();
            }
        }
        catch (SQLException sqlEx) {
            logger.error("Error adding data to table 'access_all': " + sqlEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer inArchiveObjectsTable(String s) {
        ResultSet rs = null;
        Integer nodeId = 0;
        s = this.serverName.concat(s);
        logger.info("Looking for '" + s + "' in " + "archiveobjects" + " table...");
        try {
            PreparedStatement preparedStatement = this.getNodeIdSTM;
            synchronized (preparedStatement) {
                this.getNodeIdSTM.setString(1, s);
                logger.info("Executing SQL command: " + this.getNodeIdSTM);
                rs = this.getNodeIdSTM.executeQuery();
                if (rs.next()) {
                    nodeId = rs.getInt(1);
                }
            }
        }
        catch (SQLException sqlEx) {
            logger.error("Error reading from DB:" + sqlEx);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("inArchiveObjectsTable: Failed to close resultset: " + e);
                }
            }
        }
        return nodeId;
    }

    public void readLog(String file) throws IOException {
        String s;
        logger.info("Trying to read log file '" + file + "'...");
        BufferedReader in = new BufferedReader(new FileReader(file));
        SimpleDateFormat df = new SimpleDateFormat(dateFormatString);
        Date date = null;
        Object ip = null;
        while ((s = in.readLine()) != null) {
            Matcher m = p.matcher(s);
            if (m.find()) {
                Integer status = Integer.parseInt(m.group(5));
                String url = m.group(4);
                if (url.length() < 12) {
                    logger.info("Path is too short for an archive object: " + url);
                    continue;
                }
                if (url.startsWith("/ds/")) {
                    logger.info("Internal system call only (starts with /ds/).");
                    continue;
                }
                if (status < 400 || status > 499) {
                    Integer nodeId = this.inArchiveObjectsTable(url);
                    if (nodeId > 0) {
                        logger.info("Adding hit for file " + url + " (NodeId " + nodeId + ")...");
                        this.countUp(nodeId);
                        try {
                            date = df.parse(m.group(3));
                        }
                        catch (ParseException pe) {
                            logger.error("Error parsing date '" + m.group(2) + "'.");
                        }
                        this.addHit(nodeId, date, m.group(8));
                        continue;
                    }
                    logger.info("Not in archiveobjects DB: " + url);
                    continue;
                }
                logger.info("Not an HTTP status to record as hit (" + m.group(5) + ") for file " + m.group(4));
                continue;
            }
            logger.warn("Not a valid line: " + s);
        }
        in.close();
    }

    private static String useragentType(String s) {
        String uType = s.startsWith("Java/") ? "Java" : (s.startsWith("Annex") ? "Annex" : (s.startsWith("Mozilla/") ? "Webbrowser" : "unknown"));
        return uType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nodeHitCount(int nId) {
        int fileCounter = 0;
        try {
            PreparedStatement preparedStatement = this.getCountSTM;
            synchronized (preparedStatement) {
                this.getCountSTM.setInt(1, nId);
                logger.info("Executing SQL command: " + this.getCountSTM);
                ResultSet rs = this.getCountSTM.executeQuery();
                if (rs.next()) {
                    fileCounter = rs.getInt(1);
                }
                rs.close();
            }
        }
        catch (SQLException sqlEx) {
            logger.error("Error getting stats for node #" + nId + " :", (Throwable)sqlEx);
        }
        return fileCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean isSession(int nId) {
        ResultSet rs = null;
        PreparedStatement preparedStatement = this.getUrlSTM;
        // MONITORENTER : preparedStatement
        this.getUrlSTM.setInt(1, nId);
        rs = this.getUrlSTM.executeQuery();
        if (rs.next()) {
            String nodeUrl = rs.getString(1);
            if (nodeUrl.endsWith(".imdi")) {
                boolean bl = true;
                // MONITOREXIT : preparedStatement
                return bl;
            }
            boolean bl = false;
            // MONITOREXIT : preparedStatement
            if (rs == null) return bl;
            try {
                rs.close();
                return bl;
            }
            catch (SQLException e) {
                logger.warn("isSession: Failed to close resultset: " + e);
            }
            return bl;
        }
        if (rs == null) return false;
        try {
            rs.close();
            return false;
        }
        catch (SQLException e) {
            logger.warn("isSession: Failed to close resultset: " + e);
            return false;
        }
        catch (SQLException sqlEx) {
            logger.error("Error checking whether node #" + nId + " is a session:", (Throwable)sqlEx);
            return false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("isSession: Failed to close resultset: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SingleHit> nodeHits(int nId) {
        LinkedList<SingleHit> hits = new LinkedList<SingleHit>();
        try {
            PreparedStatement preparedStatement = this.getStatsSTM;
            synchronized (preparedStatement) {
                this.getStatsSTM.setInt(1, nId);
                logger.info("Executing SQL command: " + this.getStatsSTM);
                ResultSet rs = this.getStatsSTM.executeQuery();
                while (rs.next()) {
                    hits.add(new SingleHit(rs.getDate(1), AccessStatsAPI.useragentType(rs.getString(2))));
                }
                rs.close();
            }
        }
        catch (SQLException sqlEx) {
            logger.error("Error getting hits for node #" + nId + " :", (Throwable)sqlEx);
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<HitInfo> sessionStats(int myNodeInt, CorpusStructureDBImpl csdb) throws UnknownNodeException {
        Statement st = null;
        ResultSet rs = null;
        String getStatsSQL = "SELECT nodeid,counter FROM access_index WHERE nodeid = " + myNodeInt;
        int countFiles = 0;
        logger.info("sessionStats launched!");
        LinkedList<HitInfo> accessInfo = new LinkedList<HitInfo>();
        String nodeid = AccessStatsAPI.nodeIdString(myNodeInt);
        String[] childNodes = csdb.getDescendants(nodeid, -1, "*");
        int children = childNodes.length;
        csdb.getNode(nodeid);
        int[] nIds = new int[children];
        StringBuilder orNodes = new StringBuilder(getStatsSQL);
        for (int i = 0; i < children; ++i) {
            nIds[i] = AccessStatsAPI.realNodeId(childNodes[i]);
            orNodes.append(" OR nodeid = ");
            orNodes.append(nIds[i]);
        }
        getStatsSQL = orNodes.toString();
        try {
            st = this.dbCon.getConnection().createStatement();
            logger.info("Executing SQL command: " + getStatsSQL);
            rs = st.executeQuery(getStatsSQL + ";");
            while (rs.next()) {
                int nId = rs.getInt(1);
                int hits = rs.getInt(2);
                ++countFiles;
                Node childNode = csdb.getNode(AccessStatsAPI.nodeIdString(nId));
                HitInfo t = new HitInfo(nId, hits, childNode.getName());
                accessInfo.add(t);
            }
            rs.close();
            st.close();
        }
        catch (SQLException sqle) {
            logger.error("getting sessionStats: SQL exception ", (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("sessionStats failed to close resultset: " + e);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    logger.warn("sessionStats failed to close statement: " + e);
                }
            }
        }
        return accessInfo;
    }

    public static String nodeIdString(int nId) {
        return "MPI" + nId + "#";
    }

    public static int realNodeId(String nodeid) {
        String thisNode = nodeid.trim();
        Matcher matcher = nodeIdPattern.matcher(thisNode);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }
}

