/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.handle.hdllib4.XdrEncodingException;

public class XdrDecoder {
    private DataInputStream in;

    public XdrDecoder(byte[] buf, int offset, int len) throws IOException {
        this.in = new DataInputStream(new ByteArrayInputStream(buf, offset, len));
    }

    public XdrDecoder(byte[] buf) throws IOException {
        this(buf, 0, buf.length);
    }

    public XdrDecoder(InputStream rawIS) throws IOException {
        this.in = new DataInputStream(rawIS);
    }

    public boolean moreData() throws IOException {
        return this.in.available() > 0;
    }

    public String readString() throws IOException, XdrEncodingException, UnsupportedEncodingException {
        byte[] buf = this.readByteArray();
        return new String(buf, 0, buf.length, "UTF8");
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public byte[] readBytes(int n) throws IOException, XdrEncodingException {
        int numRead;
        int r;
        byte[] buf = new byte[n];
        for (numRead = 0; numRead < n && (r = this.in.read(buf, numRead, n - numRead)) > 0; numRead += r) {
        }
        while (numRead % 4 != 0) {
            this.in.read();
            ++numRead;
        }
        if (numRead < n) {
            throw new XdrEncodingException("unexpected end of buffer");
        }
        return buf;
    }

    public int readShort() throws IOException {
        return this.in.readInt();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public byte[] readByteArray() throws IOException, XdrEncodingException {
        return this.readBytes((int)this.readUnsignedInt());
    }

    public long[] readUIntArray() throws IOException, XdrEncodingException {
        long[] result = new long[(int)this.readUnsignedInt()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readUnsignedInt();
        }
        return result;
    }

    public long readUnsignedInt() throws IOException {
        int b1 = this.in.readUnsignedByte();
        int b2 = this.in.readUnsignedByte();
        int b3 = this.in.readUnsignedByte();
        int b4 = this.in.readUnsignedByte();
        return (long)(b1 & 0xFF) << 24 | (long)(b2 << 16) | (long)(b3 << 8) | (long)b4;
    }

    public long readLong() throws IOException {
        int b1 = this.in.readUnsignedByte();
        int b2 = this.in.readUnsignedByte();
        int b3 = this.in.readUnsignedByte();
        int b4 = this.in.readUnsignedByte();
        int b5 = this.in.readUnsignedByte();
        int b6 = this.in.readUnsignedByte();
        int b7 = this.in.readUnsignedByte();
        int b8 = this.in.readUnsignedByte();
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    public int getRemainingByteCount() throws IOException {
        return this.in.available();
    }
}

