/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import nl.mpi.arbil.ArbilSwingInjector;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.arbil.util.ArbilMimeHashQueue;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.LoggingBugCatcher;

public class ArbilDesktopInjector
extends ArbilSwingInjector {
    private ArbilTreeHelper treeHelper;
    private ArbilMimeHashQueue mimeHashQueue;
    private ArbilWindowManager windowManager;
    private ArbilDataNodeLoader dataNodeLoader;
    private ImageBoxRenderer imageBoxRenderer;
    private ArbilSessionStorage sessionStorage;
    private ArbilTreeController treeController;
    private ArbilTableController tableController;

    public synchronized void injectDefaultHandlers() {
        ArbilVersion arbilVersion = new ArbilVersion();
        this.injectHandlers(new ArbilSessionStorage(), new ApplicationVersionManager(arbilVersion), new ArbilLogConfigurer(arbilVersion, "arbil-log"));
    }

    public synchronized void injectHandlers(ArbilSessionStorage sessionStorage, ApplicationVersionManager versionManager, ArbilLogConfigurer logManager) {
        this.injectVersionManager(versionManager);
        this.sessionStorage = sessionStorage;
        logManager.configureLoggingFromSessionStorage(sessionStorage);
        this.injectSessionStorage(sessionStorage);
        BugCatcherManager.setBugCatcher(new LoggingBugCatcher());
        this.windowManager = new ArbilWindowManager();
        this.windowManager.setSessionStorage(sessionStorage);
        this.windowManager.setVersionManager(versionManager);
        this.imageBoxRenderer = new ImageBoxRenderer();
        this.windowManager.setImageBoxRenderer(this.imageBoxRenderer);
        ArbilWindowManager messageDialogHandler = this.windowManager;
        sessionStorage.setMessageDialogHandler(messageDialogHandler);
        this.injectDialogHandler(messageDialogHandler);
        sessionStorage.setWindowManager(this.windowManager);
        this.injectWindowManager(this.windowManager);
        this.mimeHashQueue = new ArbilMimeHashQueue(this.windowManager, sessionStorage);
        this.mimeHashQueue.setMessageDialogHandler(messageDialogHandler);
        this.treeHelper = new ArbilTreeHelper(sessionStorage, messageDialogHandler);
        this.windowManager.setTreeHelper(this.treeHelper);
        sessionStorage.setTreeHelper(this.treeHelper);
        this.injectTreeHelper(this.treeHelper);
        this.dataNodeLoader = new ArbilDataNodeLoader(messageDialogHandler, sessionStorage, this.mimeHashQueue, this.treeHelper);
        this.treeHelper.setDataNodeLoader(this.dataNodeLoader);
        this.mimeHashQueue.setDataNodeLoader(this.dataNodeLoader);
        this.windowManager.setDataNodeLoader(this.dataNodeLoader);
        this.injectDataNodeLoader(this.dataNodeLoader);
        this.tableController = new ArbilTableController(this.treeHelper, messageDialogHandler, this.windowManager);
        this.windowManager.setTableController(this.tableController);
        this.treeController = new ArbilTreeController(sessionStorage, this.treeHelper, this.windowManager, messageDialogHandler, this.dataNodeLoader, this.mimeHashQueue, versionManager);
    }

    public ArbilTreeHelper getTreeHelper() {
        return this.treeHelper;
    }

    public ArbilTreeController getTreeController() {
        return this.treeController;
    }

    public ArbilMimeHashQueue getMimeHashQueue() {
        return this.mimeHashQueue;
    }

    public ArbilWindowManager getWindowManager() {
        return this.windowManager;
    }

    public ArbilDataNodeLoader getDataNodeLoader() {
        return this.dataNodeLoader;
    }

    public ImageBoxRenderer getImageBoxRenderer() {
        return this.imageBoxRenderer;
    }

    public ArbilTableController getTableController() {
        return this.tableController;
    }

    public ArbilSessionStorage getSessionStorage() {
        return this.sessionStorage;
    }
}

