/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.net.URI;
import java.util.Date;
import org.apache.xmlbeans.XmlDate;

public class CmdiHeaderInfo {
    protected static final String COMPONENT_REGISTRY_PATTERN = "^http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/(.*)/xsd$";
    protected String MdCreator;
    protected String MdCreationDate;
    protected String MdSelfLink;
    protected String MdProfile;
    protected String MdCollectionDisplayName;

    public static CmdiHeaderInfo createDefault(URI profileSchemaURI) {
        String uriString = profileSchemaURI.toString();
        if (uriString.matches(COMPONENT_REGISTRY_PATTERN)) {
            uriString = uriString.replaceAll(COMPONENT_REGISTRY_PATTERN, "$1");
        }
        return CmdiHeaderInfo.createDefault(uriString);
    }

    public static CmdiHeaderInfo createDefault(String profile) {
        String userName = System.getProperty("user.name");
        if (userName == null || "".equals(userName)) {
            userName = "Arbil";
        }
        XmlDate dateTime = XmlDate.Factory.newInstance();
        dateTime.setDateValue(new Date());
        CmdiHeaderInfo headerInfo = new CmdiHeaderInfo();
        headerInfo.setMdCreator(userName);
        headerInfo.setMdProfile(profile);
        headerInfo.setMdCreationDate(dateTime.getStringValue());
        return headerInfo;
    }

    public String getMdCreator() {
        return this.MdCreator;
    }

    public void setMdCreator(String MdCreator) {
        this.MdCreator = MdCreator;
    }

    public String getMdCreationDate() {
        return this.MdCreationDate;
    }

    public void setMdCreationDate(String MdCreationDate) {
        this.MdCreationDate = MdCreationDate;
    }

    public String getMdSelfLink() {
        return this.MdSelfLink;
    }

    public void setMdSelfLink(String MdSelfLink) {
        this.MdSelfLink = MdSelfLink;
    }

    public String getMdProfile() {
        return this.MdProfile;
    }

    public void setMdProfile(String MdProfile) {
        this.MdProfile = MdProfile;
    }

    public String getMdCollectionDisplayName() {
        return this.MdCollectionDisplayName;
    }

    public void setMdCollectionDisplayName(String MdCollectionDisplayName) {
        this.MdCollectionDisplayName = MdCollectionDisplayName;
    }
}

