/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.search.ArbilNodeSearchTerm;
import nl.mpi.arbil.search.ArbilSearch;
import nl.mpi.arbil.ui.ArbilNodeSearchColumnComboBox;
import nl.mpi.arbil.ui.ArbilNodeSearchTermPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.RemoteServerSearchTermPanel;
import nl.mpi.arbil.util.BugCatcherManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilNodeSearchPanel
extends JPanel
implements ArbilDataNodeContainer {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private static final Logger logger = LoggerFactory.getLogger(ArbilNodeSearchPanel.class);
    private ArbilNodeSearchPanel thisPanel = this;
    private final JInternalFrame parentFrame;
    private final ArbilTableModel resultsTableModel;
    private final ArbilTable table;
    private final ArbilNode[] selectedNodes;
    private JPanel searchTermsPanel;
    private JPanel inputNodePanel;
    private JProgressBar searchProgressBar;
    private JButton searchButton;
    private JButton stopButton;
    private RemoteServerSearchTermPanel remoteServerSearchTerm = null;
    private ArbilSearch searchService;
    private Thread searchThread = null;
    private final Object searchThreadLock = new Object();

    public ArbilNodeSearchPanel(JInternalFrame parentFrame, ArbilTable table, ArbilNode[] selectedNodes) {
        this.parentFrame = parentFrame;
        this.table = table;
        this.resultsTableModel = table.getArbilTableModel();
        this.selectedNodes = (ArbilNode[])selectedNodes.clone();
        this.setLayout(new BoxLayout(this, 3));
        this.initNodePanel();
        this.add(this.inputNodePanel);
        this.initSearchTermsPanel();
        this.add(this.searchTermsPanel);
        JPanel buttonsProgressPanel = this.createButtonsProgressPanel();
        this.add(buttonsProgressPanel);
        this.hideFirstBooleanOption();
        parentFrame.pack();
    }

    private JPanel createButtonsProgressPanel() {
        JPanel buttonsProgressPanel = new JPanel();
        buttonsProgressPanel.setLayout(new BoxLayout(buttonsProgressPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("+");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    logger.debug("adding new term");
                    ArbilNodeSearchPanel.this.stopSearch();
                    ArbilNodeSearchPanel.this.getSearchTermsPanel().add(new ArbilNodeSearchTermPanel(ArbilNodeSearchPanel.this.thisPanel));
                    ArbilNodeSearchPanel.this.hideFirstBooleanOption();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        buttonsProgressPanel.add(addButton);
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.setString("");
        this.searchProgressBar.setStringPainted(true);
        buttonsProgressPanel.add(this.searchProgressBar);
        this.stopButton = new JButton();
        this.stopButton.setText(widgets.getString("SEARCH_STOP"));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchPanel.this.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.stopButton.setEnabled(false);
        buttonsProgressPanel.add(this.stopButton);
        this.searchButton = new JButton();
        this.searchButton.setText(widgets.getString("SEARCH_SEARCH"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchPanel.this.startSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        buttonsProgressPanel.add(this.searchButton);
        return buttonsProgressPanel;
    }

    private void initSearchTermsPanel() {
        this.searchTermsPanel = new JPanel();
        this.searchTermsPanel.setLayout(new BoxLayout(this.searchTermsPanel, 3));
        boolean remoteSearch = false;
        for (ArbilNode arbilDataNode : this.selectedNodes) {
            if (arbilDataNode.isLocal()) continue;
            remoteSearch = true;
            break;
        }
        if (remoteSearch) {
            this.remoteServerSearchTerm = new RemoteServerSearchTermPanel(this);
            this.add(this.remoteServerSearchTerm);
        }
        this.searchTermsPanel.add(new ArbilNodeSearchTermPanel(this));
    }

    private void initNodePanel() {
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        for (ArbilNode currentNode : this.selectedNodes) {
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            this.inputNodePanel.add(currentLabel);
        }
    }

    private void hideFirstBooleanOption() {
        boolean firstTerm = true;
        for (Component currentTermComp : this.searchTermsPanel.getComponents()) {
            ((ArbilNodeSearchTermPanel)currentTermComp).setBooleanVisible(!firstTerm);
            firstTerm = false;
        }
        this.searchTermsPanel.revalidate();
    }

    public void stopSearch() {
        logger.debug("stop search");
        this.hideFirstBooleanOption();
        if (this.searchService != null) {
            this.searchService.stopSearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSearch() {
        Object object = this.searchThreadLock;
        synchronized (object) {
            while (this.searchThread != null && this.searchThread.isAlive()) {
                try {
                    this.searchThreadLock.wait(1000L);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    public synchronized void startSearch() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.stopSearch();
            this.waitForSearch();
        }
        logger.debug("start search");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilNodeSearchPanel.this.searchButton.setEnabled(false);
                ArbilNodeSearchPanel.this.stopButton.setEnabled(true);
                ArbilNodeSearchPanel.this.resultsTableModel.removeAllArbilDataNodeRows();
                ArbilNodeSearchPanel.this.searchThread = new Thread((Runnable)new SearchThread(), "performSearch");
                ArbilNodeSearchPanel.this.searchThread.setPriority(4);
                ArbilNodeSearchPanel.this.searchThread.start();
            }
        });
    }

    public JPanel getSearchTermsPanel() {
        return this.searchTermsPanel;
    }

    public boolean isFullyLoadedNodeRequired() {
        return true;
    }

    public void dataNodeRemoved(ArbilNode dataNode) {
    }

    public void dataNodeIconCleared(ArbilNode dataNode) {
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    private class SearchThread
    implements Runnable,
    ArbilSearch.ArbilSearchListener {
        private SearchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ArbilNodeSearchPanel.this.searchThreadLock;
            synchronized (object) {
                try {
                    this.initSearchService();
                    this.prepareUI();
                    this.populateSearchTerms();
                    this.saveColumnOptions();
                    this.executeSearch();
                    this.finishUI();
                }
                catch (InterruptedException exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                }
                catch (InvocationTargetException exception) {
                    BugCatcherManager.getBugCatcher().logError(exception);
                }
                ArbilNodeSearchPanel.this.resultsTableModel.addArbilDataNodes(Collections.enumeration(ArbilNodeSearchPanel.this.searchService.getFoundNodes()));
                for (ArbilNodeSearchTerm searchTerm : ArbilNodeSearchPanel.this.searchService.getNodeSearchTerms()) {
                    final String searchString = searchTerm.getSearchString();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ArbilNodeSearchPanel.this.resultsTableModel.highlightMatchingText(searchString);
                        }
                    });
                }
                ArbilNodeSearchPanel.this.searchService = null;
                ArbilNodeSearchPanel.this.searchThreadLock.notifyAll();
            }
        }

        private void initSearchService() {
            ArrayList<ArbilNodeSearchTerm> searchTerms = new ArrayList<ArbilNodeSearchTerm>(ArbilNodeSearchPanel.this.getComponentCount());
            for (Component component : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                if (!(component instanceof ArbilNodeSearchTermPanel)) continue;
                searchTerms.add((ArbilNodeSearchTermPanel)component);
            }
            ArbilNodeSearchPanel.this.searchService = new ArbilSearch(Arrays.asList(ArbilNodeSearchPanel.this.selectedNodes), searchTerms, ArbilNodeSearchPanel.this.remoteServerSearchTerm, ArbilNodeSearchPanel.this.resultsTableModel, ArbilNodeSearchPanel.this, this);
        }

        private void populateSearchTerms() throws InterruptedException, InvocationTargetException {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    for (Component currentTermComp : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                        ((ArbilNodeSearchTermPanel)currentTermComp).populateSearchTerm();
                    }
                }
            });
        }

        private void saveColumnOptions() throws InterruptedException, InvocationTargetException {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ArrayList<String> columns = new ArrayList<String>(ArbilNodeSearchPanel.this.searchTermsPanel.getComponentCount());
                    for (Component currentTermComp : ArbilNodeSearchPanel.this.searchTermsPanel.getComponents()) {
                        ((ArbilNodeSearchTermPanel)currentTermComp).addCurrentSearchColumnOption();
                        columns.add(((ArbilNodeSearchTermPanel)currentTermComp).searchFieldName);
                    }
                    ArbilNodeSearchColumnComboBox.addOptions(columns);
                }
            });
        }

        private void executeSearch() {
            ArbilNodeSearchPanel.this.searchService.splitLocalRemote();
            if (ArbilNodeSearchPanel.this.remoteServerSearchTerm != null) {
                this.prepareRemoteSearch();
            }
            ArbilNodeSearchPanel.this.searchService.searchLocalNodes();
            if (ArbilNodeSearchPanel.this.searchService.isSearchStopped()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ArbilNodeSearchPanel.this.searchProgressBar.setString(widgets.getString("SEARCH CANCELED"));
                    }
                });
            } else {
                ArbilNodeSearchPanel.this.searchService.setTotalNodesToSearch(ArbilNodeSearchPanel.this.searchService.getTotalSearched());
            }
        }

        private void prepareRemoteSearch() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(true);
                    ArbilNodeSearchPanel.this.searchProgressBar.setString(widgets.getString("SEARCH_CONNECTING TO SERVER"));
                }
            });
            ArbilNodeSearchPanel.this.searchService.fetchRemoteSearchResults();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArbilNodeSearchPanel.this.searchProgressBar.setString("");
                    ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
                }
            });
        }

        private void finishUI() throws InterruptedException, InvocationTargetException {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(false);
                    ArbilNodeSearchPanel.this.searchProgressBar.setValue(0);
                    ArbilNodeSearchPanel.this.searchProgressBar.setMaximum(1000);
                    ArbilNodeSearchPanel.this.searchButton.setEnabled(true);
                    ArbilNodeSearchPanel.this.stopButton.setEnabled(false);
                    ArbilNodeSearchPanel.this.table.setDeferColumnWidthUpdates(false);
                }
            });
        }

        private void prepareUI() throws InterruptedException, InvocationTargetException {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ArbilNodeSearchPanel.this.searchProgressBar.setIndeterminate(true);
                    ArbilNodeSearchPanel.this.searchProgressBar.setMinimum(0);
                    ArbilNodeSearchPanel.this.searchProgressBar.setMaximum(ArbilNodeSearchPanel.this.searchService.getTotalNodesToSearch());
                    ArbilNodeSearchPanel.this.table.setColumnWidths();
                    ArbilNodeSearchPanel.this.table.setDeferColumnWidthUpdates(true);
                }
            });
        }

        public void searchProgress(Object currentElement) {
            if (currentElement instanceof ArbilNode) {
                ArbilNodeSearchPanel.this.searchProgressBar.setString(MessageFormat.format(widgets.getString("SEARCHED: {0}/{1} FOUND: {2}"), ArbilNodeSearchPanel.this.searchService.getTotalSearched(), ArbilNodeSearchPanel.this.searchService.getTotalNodesToSearch(), ArbilNodeSearchPanel.this.searchService.getFoundNodes().size()));
            }
            if (!ArbilNodeSearchPanel.this.parentFrame.isVisible() && ArbilNodeSearchPanel.this.searchService != null) {
                ArbilNodeSearchPanel.this.searchService.stopSearch();
            }
        }
    }
}

