/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.HeadlessException;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.FavouriteSelectBox;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.TreeContextMenu;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.flap.plugin.PluginDialogHandler;

public class ArbilTreeController {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final SessionStorage sessionStorage;
    private final TreeHelper treeHelper;
    private final WindowManager windowManager;
    private final MessageDialogHandler dialogHandler;
    private final DataNodeLoader dataNodeLoader;
    private final ApplicationVersionManager versionManager;
    private final MimeHashQueue mimeHashQueue;

    public ArbilTreeController(SessionStorage sessionStorage, TreeHelper treeHelper, WindowManager windowManager, MessageDialogHandler dialogHandler, DataNodeLoader dataNodeLoader, MimeHashQueue mimeHashQueue, ApplicationVersionManager versionManager) {
        this.sessionStorage = sessionStorage;
        this.treeHelper = treeHelper;
        this.windowManager = windowManager;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.mimeHashQueue = mimeHashQueue;
        this.versionManager = versionManager;
    }

    public void reImportBranch(ArbilDataNode leadSelectedTreeNode, ArbilTreePanels treePanels) {
        try {
            URI remoteDataFile = this.sessionStorage.getOriginatingUri(leadSelectedTreeNode.getURI());
            if (remoteDataFile != null) {
                ArbilDataNode originatingNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(remoteDataFile);
                if (originatingNode.isLocal() && !originatingNode.getFile().exists()) {
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("THE ORIGIONAL FILE LOCATION CANNOT BE FOUND"), widgets.getString("RE IMPORT BRANCH"));
                } else if (originatingNode.isMetaDataNode()) {
                    ImportExportDialog importExportDialog = new ImportExportDialog(treePanels.localCorpusTree);
                    importExportDialog.setDestinationNode(leadSelectedTreeNode);
                    importExportDialog.copyToCache(new ArbilDataNode[]{originatingNode});
                } else {
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT DETERMINE THE ORIGIONAL NODE TYPE"), widgets.getString("RE IMPORT BRANCH"));
                }
            } else {
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT DETERMINE THE ORIGIONAL LOCATION"), widgets.getString("RE IMPORT BRANCH"));
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void setManualResourceLocation(ArbilDataNode leadSelectedTreeNode) throws HeadlessException {
        String initialValue = leadSelectedTreeNode.hasLocalResource() ? leadSelectedTreeNode.resourceUrlField.getFieldValue() : "";
        String manualLocation = (String)JOptionPane.showInputDialog(this.windowManager.getMainFrame(), widgets.getString("ENTER THE RESOURCE URI:"), widgets.getString("MANUAL RESOURCE LOCATION"), -1, null, null, initialValue);
        if (manualLocation != null) {
            try {
                URI locationURI = new URI(manualLocation);
                if (this.checkResourceLocation(locationURI)) {
                    leadSelectedTreeNode.insertResourceLocation(locationURI);
                }
            }
            catch (URISyntaxException ex) {
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("THE URI ENTERED AS A RESOURCE LOCATION IS INVALID. PLEASE CHECK THE LOCATION AND TRY AGAIN."), widgets.getString("INVALID URI"));
            }
            catch (ArbilMetadataException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT ADD RESOURCE TO THE METADATA. CHECK THE ERROR LOG FOR DETAILS."), widgets.getString("ERROR ADDING RESOURCE"));
            }
        }
    }

    private boolean checkResourceLocation(URI locationURI) {
        if (locationURI.isAbsolute()) {
            try {
                File file = MetadataFormat.getFile(locationURI);
                if (file != null && !file.exists()) {
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("WARNING: NO FILE EXISTS AT THE SPECIFIED LOCATION!"), widgets.getString("MANUAL RESOURCE LOCATION"));
                }
                return true;
            }
            catch (IllegalArgumentException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("ILLEGAL FILE NAME. CHECK THE ERROR LOG FOR DETAILS."), widgets.getString("ERROR ADDING RESOURCE"));
                return false;
            }
        }
        this.dialogHandler.addMessageDialogToQueue(widgets.getString("LOCATION SHOULD BE AN ABSOLUTE URI"), widgets.getString("ERROR ADDING RESOURCE"));
        return false;
    }

    public void addRemoteCorpus() {
        String addableLocation = JOptionPane.showInputDialog(this.windowManager.getMainFrame(), widgets.getString("ENTER THE URL"), widgets.getString("ADD LOCATION"), -1);
        this.addRemoteCorpus(addableLocation.trim());
    }

    public void addRemoteCorpus(String addableLocation) {
        if (addableLocation != null && addableLocation.length() > 0) {
            try {
                this.treeHelper.addLocationInteractive(ArbilDataNodeService.conformStringToUrl(addableLocation));
            }
            catch (URISyntaxException ex) {
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("FAILED TO ADD LOCATION TO REMOTE CORPUS. SEE ERROR LOG FOR DETAILS."), widgets.getString("ERROR"));
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    }

    public void searchSubnodes(ArbilTreePanels treePanels) {
        this.windowManager.openSearchTable(treePanels.localCorpusTree.getAllSelectedNodes(), widgets.getString("SEARCH"));
    }

    public void searchRemoteSubnodes(ArbilTreePanels treePanels) {
        this.windowManager.openSearchTable(treePanels.remoteCorpusTree.getSelectedNodes(), widgets.getString("SEARCH REMOTE CORPUS"));
    }

    public void validateNodes(ArbilDataNode[] selectedTreeNodes) {
        for (ArbilDataNode currentNode : selectedTreeNodes) {
            if (currentNode.getNeedsSaveToDisk(false) && 0 == this.dialogHandler.showDialogBox(widgets.getString("VALIDATION WILL BE AGAINST THE FILE ON DISK. SAVE CHANGES FIRST?"), widgets.getString("TREE_VALIDATION"), 0, 2)) {
                currentNode.saveChangesToCache(true);
                currentNode.reloadNode();
            }
            XsdChecker xsdChecker = new XsdChecker();
            ((ArbilWindowManager)this.windowManager).createWindow(widgets.getString("XSDCHECKER"), xsdChecker);
            xsdChecker.checkXML(currentNode);
            xsdChecker.setDividerLocation(0.5);
        }
    }

    public void addFromFavourite(ArbilDataNode leadSelectedTreeNode, String favouriteUrlString, String displayName) {
        try {
            String favouriteUrlStringDecoded = URLDecoder.decode(favouriteUrlString, "UTF-8");
            ArbilDataNode templateDataNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(favouriteUrlStringDecoded));
            if (leadSelectedTreeNode != null) {
                new MetadataBuilder().requestAddNode(leadSelectedTreeNode, displayName, templateDataNode);
            } else {
                new MetadataBuilder().requestAddRootNode(templateDataNode, displayName);
            }
        }
        catch (Exception ex) {
            this.dialogHandler.addMessageDialogToQueue(widgets.getString("FAILED TO ADD FROM FAVOURITES, SEE ERROR LOG FOR DETAILS."), widgets.getString("ERROR"));
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void viewSelectedNodes(ArbilTree tree) {
        try {
            ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>();
            for (ArbilDataNode currentItem : tree.getSelectedNodes()) {
                if (currentItem.isMetaDataNode() || currentItem.getFields().size() > 0) {
                    filteredNodes.add(currentItem);
                    continue;
                }
                try {
                    this.windowManager.openUrlWindowOnce(currentItem.toString(), currentItem.getURI().toURL());
                }
                catch (MalformedURLException murle) {
                    BugCatcherManager.getBugCatcher().logError(murle);
                }
            }
            if (filteredNodes.size() > 0) {
                this.windowManager.openFloatingTableOnce(filteredNodes.toArray(new ArbilDataNode[0]), null);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void viewSelectedSubnodes(ArbilTree tree) {
        ArbilDataNode[] selectedNodes = tree.getSelectedNodes();
        ArrayList<ArbilDataNode> filteredNodes = new ArrayList<ArbilDataNode>(selectedNodes.length);
        for (ArbilDataNode dataNode : selectedNodes) {
            if (!dataNode.isSession() && !dataNode.isMetaDataNode()) continue;
            filteredNodes.add(dataNode);
        }
        if (!filteredNodes.isEmpty()) {
            this.windowManager.openFloatingSubnodesWindows(filteredNodes.toArray(new ArbilDataNode[0]));
        }
    }

    public void openSelectedNodesInTable(ArbilTree tree) {
        this.windowManager.openFloatingTableOnce(tree.getSelectedNodes(), null);
    }

    public void startLongFieldEditor(ArbilTree tree) {
        ArbilDataNode[] selectedNodes;
        for (ArbilDataNode node : selectedNodes = tree.getSelectedNodes()) {
            if (node.getFields().size() <= 0) continue;
            List<ArbilField[]> fieldArrays = node.getFieldsSorted();
            new ArbilLongFieldEditor().showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
        }
    }

    public void copyBranch(ArbilTree tree) {
        try {
            ImportExportDialog importExportDialog = new ImportExportDialog(tree);
            importExportDialog.copyToCache(tree.getSelectedNodes());
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addLocalDirectory() {
        File[] selectedFiles = this.dialogHandler.showDirectorySelectBox(widgets.getString("ADD WORKING DIRECTORY"), true);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentDirectory : selectedFiles) {
                this.treeHelper.addLocationInteractive(currentDirectory.toURI());
            }
        }
    }

    public void addBulkResources(ArbilNode targetObject) {
        try {
            FavouriteSelectBox favouriteSelectBox = new FavouriteSelectBox(targetObject);
            File[] selectedFiles = this.dialogHandler.showFileSelectBox(widgets.getString("ADD BULK RESOURCES"), false, true, null, PluginDialogHandler.DialogueType.open, favouriteSelectBox);
            if (selectedFiles != null && selectedFiles.length > 0) {
                new MetadataBuilder().requestAddNodeAndResources(favouriteSelectBox.getTargetNode(), widgets.getString("ADD BULK RESOURCES"), favouriteSelectBox.getSelectedFavouriteNode(), selectedFiles, favouriteSelectBox.getCopyDirectoryStructure(), favouriteSelectBox.getMetadataFilePerResource());
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addNodeFromTemplate(ArbilDataNode leadSelectedTreeNode, String nodeType, String displayName) {
        try {
            if (leadSelectedTreeNode != null) {
                new MetadataBuilder().requestAddNode(leadSelectedTreeNode, nodeType, displayName);
            } else {
                new MetadataBuilder().requestRootAddNode(nodeType, displayName);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addSubnode(ArbilDataNode leadSelectedTreeNode, String nodeType, String nodeText) {
        try {
            if (leadSelectedTreeNode != null) {
                if (!leadSelectedTreeNode.getParentDomNode().getNeedsSaveToDisk(false) || this.dialogHandler.showConfirmDialogBox(MessageFormat.format(widgets.getString("ADDING A NODE WILL SAVE PENDING CHANGES"), leadSelectedTreeNode.getParentDomNode().toString()), widgets.getString("SAVE PENDING CHANGES?"))) {
                    new MetadataBuilder().requestAddNode(leadSelectedTreeNode, nodeType, nodeText);
                }
            } else {
                new MetadataBuilder().requestRootAddNode(nodeType, nodeText);
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void forceTypeCheck(ArbilDataNode dataNode) {
        this.mimeHashQueue.forceInQueue(dataNode);
    }

    public void showContextMenu(ArbilTree tree, Point location) {
        new TreeContextMenu(tree, this, this.treeHelper, this.dialogHandler, this.windowManager, this.sessionStorage, this.versionManager).show(location.x, location.y);
    }
}

