/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;

public class ArbilTreeRenderer
extends DefaultTreeCellRenderer {
    public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ArbilTreeRenderer returnComponent = this;
        returnComponent.setTextNonSelectionColor(tree.getForeground());
        returnComponent.setBackgroundNonSelectionColor(tree.getBackground());
        String valueString = "";
        Icon nodeIcon = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof ArbilNode) {
            ArbilNode arbilNode = (ArbilNode)node.getUserObject();
            valueString = arbilNode.toString();
            nodeIcon = arbilNode.getIcon();
            returnComponent.setHorizontalAlignment(2);
            if (arbilNode instanceof ArbilDataNode) {
                if (((ArbilDataNode)arbilNode).isContainerNode()) {
                    returnComponent.setTextNonSelectionColor(Color.DARK_GRAY);
                    valueString = "<u>" + arbilNode.toString() + "</u>";
                }
                if (((ArbilDataNode)arbilNode).getNeedsSaveToDisk(true)) {
                    returnComponent.setTextNonSelectionColor(Color.BLUE);
                }
                if (((ArbilDataNode)arbilNode).hasSchemaError) {
                    returnComponent.setTextNonSelectionColor(Color.RED);
                }
            }
        } else if (node.getUserObject() instanceof JLabel) {
            valueString = ((JLabel)node.getUserObject()).getText();
            nodeIcon = ((JLabel)node.getUserObject()).getIcon();
        }
        returnComponent.setClosedIcon(nodeIcon);
        returnComponent.setOpenIcon(nodeIcon);
        returnComponent.setLeafIcon(nodeIcon);
        return super.getTreeCellRendererComponent(tree, "<html>" + valueString + "</html>", selected, expanded, leaf, row, hasFocus);
    }
}

