/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;

public class HtmlViewPane
extends JTextPane {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");

    public HtmlViewPane() {
        this.setContentType("text/html;charset=UTF-8");
        this.setEditable(false);
    }

    public HtmlViewPane(URL url) throws IOException {
        this();
        this.setContents(url);
    }

    public JScrollPane createScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this);
        return scrollPane;
    }

    public void setDocumentBase(Class resourceRefClass, String location) {
        ((HTMLDocument)this.getDocument()).setBase(resourceRefClass.getResource(location));
    }

    public final void setContents(URL url) throws IOException {
        this.setContents(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setContents(InputStream itemStream) throws IOException {
        if (itemStream == null) {
            this.setText(widgets.getString("PAGE NOT FOUND"));
        } else {
            StringBuilder completeHelpText = new StringBuilder();
            BufferedReader bufferedHelpReader = new BufferedReader(new InputStreamReader(itemStream, "UTF-8"));
            try {
                String helpLine = bufferedHelpReader.readLine();
                while (helpLine != null) {
                    completeHelpText.append(helpLine);
                    helpLine = bufferedHelpReader.readLine();
                }
            }
            finally {
                bufferedHelpReader.close();
            }
            this.setText(completeHelpText.toString());
        }
        this.setCaretPosition(0);
    }
}

