/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

import com.ibm.media.codec.audio.BufferedEncoder;
import com.ibm.media.codec.audio.gsm.GsmEncoder;
import com.ibm.media.codec.audio.gsm.GsmVadEncoder;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends BufferedEncoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    protected GsmEncoder encoder;
    private int sample_count = 160;
    private long currentSeq = (long)((double)System.currentTimeMillis() * Math.random());
    private long timestamp = 0L;
    byte[] pendingBuffer = null;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("gsm")};
        this.PLUGIN_NAME = "GSM Encoder";
        this.historySize = 320;
        this.pendingFrames = 0;
        this.packetSize = 33;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("gsm", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), -1, -1, 264, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.encoder = new GsmVadEncoder();
        this.encoder.gsm_encoder_reset();
    }

    public void codecReset() {
        this.encoder.gsm_encoder_reset();
    }

    public void close() {
        this.encoder = null;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2 = super.process(buffer, buffer2);
        if (!this.outputFormat.getEncoding().equals("gsm/rtp")) {
            return n2;
        }
        if (this.outputFormat.getEncoding().equals("gsm/rtp")) {
            if (n2 == 1) {
                return n2;
            }
            if (this.isEOM(buffer)) {
                this.propagateEOM(buffer2);
                return 0;
            }
            if (this.pendingFrames == 0) {
                this.pendingBuffer = (byte[])buffer2.getData();
            }
            byte[] byArray = new byte[this.packetSize];
            buffer2.setData(byArray);
            this.updateOutput(buffer2, this.outputFormat, this.packetSize, 0);
            buffer2.setSequenceNumber(this.currentSeq++);
            buffer2.setTimeStamp(this.timestamp);
            this.timestamp += (long)this.sample_count;
            System.arraycopy(this.pendingBuffer, this.regions[this.pendingFrames], byArray, 0, this.packetSize);
            if (this.pendingFrames + 1 == this.frameNumber[0]) {
                this.pendingFrames = 0;
                this.pendingBuffer = null;
                return 0;
            }
            ++this.pendingFrames;
            return 2;
        }
        return n2;
    }

    protected int calculateOutputSize(int n2) {
        return this.calculateFramesNumber(n2) * 33;
    }

    protected int calculateFramesNumber(int n2) {
        return n2 / 320;
    }

    protected boolean codecProcess(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n5 = 0;
        int n6 = 0;
        int n7 = this.inputFormat.getChannels();
        boolean bl = n7 == 2;
        int n8 = n4 / 320;
        nArray4[0] = n3;
        int n9 = 0;
        while (n9 < n8) {
            this.encoder.gsm_encode_frame(byArray, n2, byArray2, n3);
            n2 += 320;
            n5 += 320;
            n6 += 33;
            nArray4[n9 + 1] = n3 += 33;
            nArray5[n9] = 0;
            ++n9;
        }
        nArray[0] = n5;
        nArray2[0] = n6;
        nArray3[0] = n8;
        return true;
    }
}

