/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.DefaultSecurity;
import com.sun.media.DisabledSecurity;
import com.sun.media.IESecurity;
import com.sun.media.JDK12Security;
import com.sun.media.JMFSecurity;
import com.sun.media.NetscapeSecurity;
import com.sun.media.util.Registry;

public class JMFSecurityManager {
    private static JMFSecurity security = null;
    private static JMFSecurity enabledSecurity = null;
    private static SecurityManager securityManager;
    private static int count;
    public static final boolean DEBUG = false;
    private static boolean jdk12;
    private static final String STR_NOPERMCAPTURE = "No permission to capture from applets";
    private static final String STR_NOPERMFILE = "No permission to write files from applets";

    public static JMFSecurity getJMFSecurity() throws SecurityException {
        return security;
    }

    public static boolean isLinkPermissionEnabled() {
        if (security == null) {
            return true;
        }
        return security.isLinkPermissionEnabled();
    }

    public static void loadLibrary(String string) throws UnsatisfiedLinkError {
        try {
            JMFSecurity jMFSecurity = JMFSecurityManager.getJMFSecurity();
            if (jMFSecurity != null) {
                jMFSecurity.loadLibrary(string);
            } else {
                System.loadLibrary(string);
            }
        }
        catch (Throwable throwable) {
            throw new UnsatisfiedLinkError("JMFSecurityManager: " + throwable);
        }
    }

    public static synchronized void disableSecurityFeatures() {
        security = DisabledSecurity.security;
        ++count;
    }

    public static synchronized void enableSecurityFeatures() {
        if (--count <= 0) {
            security = enabledSecurity;
        }
    }

    public static void checkCapture() {
        if (security == null) {
            return;
        }
        Object object = Registry.get("secure.allowCaptureFromApplets");
        if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
            throw new RuntimeException(STR_NOPERMCAPTURE);
        }
    }

    public static void checkFileSave() {
        if (security == null) {
            return;
        }
        Object object = Registry.get("secure.allowSaveFileFromApplets");
        if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
            throw new RuntimeException(STR_NOPERMFILE);
        }
    }

    public static boolean isJDK12() {
        return jdk12;
    }

    static {
        count = 0;
        jdk12 = false;
        securityManager = System.getSecurityManager();
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string;
            String string2 = System.getProperty("java.version");
            if (!string2.equals("")) {
                if (string2.startsWith("1.1")) {
                    bl = true;
                } else {
                    char c2 = string2.charAt(0);
                    if (c2 >= '0' && c2 <= '9' && string2.compareTo("1.2") >= 0) {
                        jdk12 = true;
                    }
                }
            }
            if ((string = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        if (securityManager != null) {
            if (securityManager.toString().indexOf("netscape") != -1) {
                security = NetscapeSecurity.security;
            } else if (securityManager.toString().indexOf("com.ms.security") != -1 || bl2) {
                security = IESecurity.security;
            } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1 || securityManager.toString().indexOf("sun.plugin.ActivatorSecurityManager") != -1) {
                if (bl) {
                    security = DefaultSecurity.security;
                }
                if (jdk12) {
                    security = JDK12Security.security;
                }
            } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1) {
                if (jdk12) {
                    security = JDK12Security.security;
                }
            } else {
                security = jdk12 ? JDK12Security.security : DefaultSecurity.security;
            }
        }
        enabledSecurity = security;
    }
}

