/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import java.awt.Component;
import javax.media.Format;
import javax.media.Player;
import javax.media.Time;
import javax.media.Track;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;

public class FramePositioningAdapter
implements FramePositioningControl,
Reparentable {
    Object owner;
    Player player;
    Track master = null;
    long frameStep = -1L;

    public static Track getMasterTrack(Track[] trackArray) {
        Track track = null;
        float f2 = -1.0f;
        int n2 = 0;
        while (n2 < trackArray.length) {
            Format format;
            if (trackArray[n2] != null && (format = trackArray[n2].getFormat()) != null && format instanceof VideoFormat) {
                track = trackArray[n2];
                f2 = ((VideoFormat)format).getFrameRate();
                if (f2 != -1.0f && f2 != 0.0f) {
                    return track;
                }
            }
            ++n2;
        }
        if (track != null && track.mapTimeToFrame(new Time(0L)) != Integer.MAX_VALUE) {
            return track;
        }
        return null;
    }

    public FramePositioningAdapter(Player player, Track track) {
        float f2;
        this.player = player;
        this.master = track;
        Format format = track.getFormat();
        if (format instanceof VideoFormat && (f2 = ((VideoFormat)format).getFrameRate()) != -1.0f && f2 != 0.0f) {
            this.frameStep = (long)(1.0E9f / f2);
        }
    }

    public int seek(int n2) {
        Time time = this.master.mapFrameToTime(n2);
        if (time != null && time != FramePositioningControl.TIME_UNKNOWN) {
            this.player.setMediaTime(time);
            return this.master.mapTimeToFrame(time);
        }
        return Integer.MAX_VALUE;
    }

    public int skip(int n2) {
        if (this.frameStep != -1L) {
            long l2 = this.player.getMediaNanoseconds() + (long)n2 * this.frameStep;
            this.player.setMediaTime(new Time(l2));
            return n2;
        }
        int n3 = this.master.mapTimeToFrame(this.player.getMediaTime());
        if (n3 != 0 && n3 != Integer.MAX_VALUE) {
            int n4 = this.seek(n3 + n2);
            return n4 - n3;
        }
        return Integer.MAX_VALUE;
    }

    public Time mapFrameToTime(int n2) {
        return this.master.mapFrameToTime(n2);
    }

    public int mapTimeToFrame(Time time) {
        return this.master.mapTimeToFrame(time);
    }

    public Component getControlComponent() {
        return null;
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }
}

