/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.sun.media.BasicClock;
import com.sun.media.multiplexer.RawBufferMux;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class RawSyncBufferMux
extends RawBufferMux {
    boolean mpegBFrame = false;
    boolean mpegPFrame = false;
    protected boolean monoIncrTime = false;
    private long monoStartTime = 0L;
    private long monoTime = 0L;
    private Object waitLock = new Object();
    private boolean resetted = false;
    private boolean masterTrackEnded = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static int THRESHOLD = 80;
    static int LEEWAY = 5;

    public RawSyncBufferMux() {
        this.timeBase = new RawBufferMux.RawMuxTimeBase();
        this.allowDrop = true;
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initializeTracks(Format[] formatArray) {
        if (!super.initializeTracks(formatArray)) {
            return false;
        }
        this.masterTrackID = 0;
        int n2 = 0;
        while (n2 < formatArray.length) {
            if (formatArray[n2] instanceof AudioFormat) {
                this.masterTrackID = n2;
            }
            ++n2;
        }
        return true;
    }

    public void reset() {
        super.reset();
        this.mpegBFrame = false;
        this.mpegPFrame = false;
        Object object = this.waitLock;
        synchronized (object) {
            this.resetted = true;
            this.waitLock.notify();
        }
    }

    public String getName() {
        return "Raw Sync Buffer Multiplexer";
    }

    public int process(Buffer buffer, int n2) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[n2] != null && this.mc[n2].isEnabled()) {
            this.mc[n2].process(buffer);
        }
        if (this.streams == null || buffer == null || n2 >= this.streams.length) {
            return 1;
        }
        if (buffer.isDiscard()) {
            return 0;
        }
        if ((buffer.getFlags() & 0x40) == 0) {
            if (buffer.getFormat() instanceof AudioFormat) {
                if (mpegAudio.matches(buffer.getFormat())) {
                    this.waitForPT(buffer.getTimeStamp(), n2);
                } else {
                    this.waitForPT(this.mediaTime[n2], n2);
                }
            } else if (buffer.getTimeStamp() >= 0L) {
                if (mpegVideo.matches(buffer.getFormat()) && (buffer.getFlags() & 0x800) != 0) {
                    int n3;
                    byte[] byArray = (byte[])buffer.getData();
                    int n4 = byArray[(n3 = buffer.getOffset()) + 2] & 7;
                    if (n4 > 2) {
                        this.mpegBFrame = true;
                    } else if (n4 == 2) {
                        this.mpegPFrame = true;
                    }
                    if (n4 > 2 || n4 == 2 && !this.mpegBFrame || n4 == 1 && !(this.mpegBFrame | this.mpegPFrame)) {
                        this.waitForPT(buffer.getTimeStamp(), n2);
                    }
                } else {
                    this.waitForPT(buffer.getTimeStamp(), n2);
                }
            }
        }
        this.updateTime(buffer, n2);
        buffer.setFlags(buffer.getFlags() | 0x60);
        if ((!(buffer.getFormat() instanceof AudioFormat) || mpegAudio.matches(buffer.getFormat())) && this.monoIncrTime) {
            this.monoTime = this.monoStartTime + buffer.getTimeStamp() - this.mediaStartTime * 1000000L;
            buffer.setTimeStamp(this.monoTime);
        }
        if (buffer.isEOM() && n2 == this.masterTrackID) {
            this.masterTrackEnded = true;
        }
        buffer.setHeader(new Long(System.currentTimeMillis()));
        return this.streams[n2].process(buffer);
    }

    public void syncStart(Time time) {
        this.masterTrackEnded = false;
        super.syncStart(time);
    }

    public void setMediaTime(Time time) {
        super.setMediaTime(time);
        this.monoStartTime = this.monoTime + 10L;
    }

    protected void updateTime(Buffer buffer, int n2) {
        if (buffer.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buffer.getFormat())) {
                if (buffer.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[n2] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[n2] = buffer.getTimeStamp();
                }
            } else {
                long l2 = ((AudioFormat)buffer.getFormat()).computeDuration(buffer.getLength());
                if (l2 >= 0L) {
                    int n3 = n2;
                    this.mediaTime[n3] = this.mediaTime[n3] + l2;
                } else {
                    this.mediaTime[n2] = buffer.getTimeStamp();
                }
            }
        } else {
            this.mediaTime[n2] = buffer.getTimeStamp() < 0L && this.systemStartTime >= 0L ? (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L : buffer.getTimeStamp();
        }
        this.timeBase.update();
    }

    /*
     * Unable to fully structure code
     */
    private void waitForPT(long var1_1, int var3_2) {
        var4_3 = this.masterTrackID == -1 || var3_2 == this.masterTrackID ? (this.systemStartTime < 0L ? 0L : var1_1 - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime)) : (var1_1 /= 1000000L) - this.mediaTime[this.masterTrackID] / 1000000L;
        if (var4_3 <= 2000L) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            if (var4_3 > (long)RawSyncBufferMux.THRESHOLD) {
                var4_3 = RawSyncBufferMux.THRESHOLD;
            }
            var6_4 = this.waitLock;
            synchronized (var6_4) {
                try {
                    this.waitLock.wait(var4_3);
                }
                catch (Exception var7_5) {
                    break;
                }
                if (this.resetted) {
                    this.resetted = false;
                    break;
                }
            }
            var4_3 = this.masterTrackID == -1 || var3_2 == this.masterTrackID ? var1_1 - this.mediaStartTime - (System.currentTimeMillis() - this.systemStartTime) : var1_1 - this.mediaTime[this.masterTrackID] / 1000000L;
lbl21:
            // 2 sources

            ** while (var4_3 > (long)RawSyncBufferMux.LEEWAY && !this.masterTrackEnded)
        }
lbl22:
        // 3 sources

    }
}

