/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.renderer.audio.BufSlot;
import com.sun.media.renderer.audio.DirectAudioRenderer;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

public class MixedDirectAudioRenderer
implements Renderer,
Runnable {
    protected static final int MIXLEN = 160;
    protected static final int MAXNUM = 16;
    protected static String NAME = "MixedDirectAudioRenderer";
    protected static String name = "com.sun.media.renderer.audio.DirectAudioRenderer";
    protected static BufSlot[] buffers = null;
    protected static int nextBufPtr = 0;
    protected static byte[] mixpcm;
    protected static DirectAudioRenderer renderer;
    protected static MediaThread mixThread;
    protected static Object locks;
    protected static boolean opened;
    protected static boolean started;
    protected static boolean isBigEndian;
    protected static boolean is16Bit;
    protected static boolean isSigned;
    protected static AudioFormat curFormat;
    protected static int numstreams;
    protected static int numSofar;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int curBuf = 0;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public static void closeRenderer() {
        Object object = locks;
        synchronized (object) {
            int n2 = 0;
            while (n2 < 16) {
                MixedDirectAudioRenderer.buffers[n2].allocated = false;
                MixedDirectAudioRenderer.buffers[n2].validLen = 0;
                MixedDirectAudioRenderer.buffers[n2].instop = true;
                MixedDirectAudioRenderer.buffers[n2].consumed = true;
                ++n2;
            }
            numstreams = 0;
            try {
                renderer.drain();
                renderer.stop();
                renderer.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            started = false;
            opened = false;
            mixThread.interrupt();
            locks.notifyAll();
        }
    }

    public String getName() {
        return NAME;
    }

    public void open() {
        Object object = locks;
        synchronized (object) {
            if (!opened) {
                opened = true;
                try {
                    renderer.open();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            boolean bl = false;
            int n2 = 0;
            while (n2 < 16) {
                if (nextBufPtr >= 16) {
                    nextBufPtr = 0;
                }
                if (!MixedDirectAudioRenderer.buffers[MixedDirectAudioRenderer.nextBufPtr].allocated) {
                    bl = true;
                    this.curBuf = nextBufPtr++;
                    break;
                }
                ++n2;
                ++nextBufPtr;
            }
            if (!bl) {
                System.out.println("not enough buffer available!");
                this.curBuf = -1;
            } else {
                MixedDirectAudioRenderer.buffers[this.curBuf].allocated = true;
                MixedDirectAudioRenderer.buffers[this.curBuf].validLen = 0;
                MixedDirectAudioRenderer.buffers[this.curBuf].instop = true;
                MixedDirectAudioRenderer.buffers[this.curBuf].consumed = true;
            }
            locks.notifyAll();
        }
    }

    public void close() {
        Object object = locks;
        synchronized (object) {
            MixedDirectAudioRenderer.buffers[this.curBuf].allocated = false;
            MixedDirectAudioRenderer.buffers[this.curBuf].validLen = 0;
            MixedDirectAudioRenderer.buffers[this.curBuf].instop = true;
            MixedDirectAudioRenderer.buffers[this.curBuf].consumed = true;
            locks.notifyAll();
        }
    }

    public void reset() {
        Object object = locks;
        synchronized (object) {
            renderer.reset();
            renderer.start();
        }
    }

    public Format[] getSupportedInputFormats() {
        return renderer.getSupportedInputFormats();
    }

    public void start() {
        Object object = locks;
        synchronized (object) {
            if (!started) {
                started = true;
                renderer.start();
            }
            if (mixThread == null) {
                Object object2;
                if (jmfSecurity != null) {
                    object2 = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            object2 = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object2 = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable throwable) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        object2 = jdk12CreateThreadRunnableAction.cons;
                        mixThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object2).newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = MixedDirectAudioRenderer.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                        object2 = jdk12PriorityAction.cons;
                        jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object2).newInstance(mixThread, new Integer(MediaThread.getAudioPriority())));
                    }
                    catch (Exception exception) {}
                } else {
                    mixThread = new MediaThread(this);
                    mixThread.useAudioPriority();
                }
                mixThread.setName("Mixing thread");
                mixThread.start();
            }
            if (MixedDirectAudioRenderer.buffers[this.curBuf].instop) {
                ++numstreams;
                MixedDirectAudioRenderer.buffers[this.curBuf].instop = false;
                locks.notifyAll();
            }
        }
    }

    public void stop() {
        Object object = locks;
        synchronized (object) {
            if (!MixedDirectAudioRenderer.buffers[this.curBuf].instop) {
                --numstreams;
                MixedDirectAudioRenderer.buffers[this.curBuf].instop = true;
                locks.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int process(Buffer buffer) {
        Object object = locks;
        synchronized (object) {
            while (!MixedDirectAudioRenderer.buffers[this.curBuf].consumed) {
                try {
                    locks.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n2 = buffer.getLength();
            System.arraycopy((byte[])buffer.getData(), 0, MixedDirectAudioRenderer.buffers[this.curBuf].data, 0, n2);
            MixedDirectAudioRenderer.buffers[this.curBuf].validLen = n2;
            MixedDirectAudioRenderer.buffers[this.curBuf].consumed = false;
            ++numSofar;
            locks.notifyAll();
            return 0;
        }
    }

    public Format setInputFormat(Format format) {
        curFormat = (AudioFormat)format;
        isBigEndian = curFormat.getEndian() == 1;
        is16Bit = curFormat.getSampleSizeInBits() == 16;
        isSigned = curFormat.getSigned() == 1;
        return renderer.setInputFormat(format);
    }

    public Object getControl(String string) {
        return renderer.getControl(string);
    }

    public Object[] getControls() {
        return renderer.getControls();
    }

    public void run() {
        short[] sArray = new short[80];
        int n2 = 0;
        int n3 = 0;
        Buffer buffer = new Buffer();
        buffer.setFormat(curFormat);
        int n4 = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Object object = locks;
                synchronized (object) {
                    while (numstreams == 0 || numSofar < numstreams) {
                        try {
                            locks.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            mixThread = null;
                            return;
                        }
                    }
                    n4 = 17;
                    boolean bl = true;
                    int n5 = 0;
                    while (n5 < 16) {
                        if (MixedDirectAudioRenderer.buffers[n5].allocated && !MixedDirectAudioRenderer.buffers[n5].instop) {
                            n4 = n5;
                            break;
                        }
                        ++n5;
                    }
                    int n6 = n4 + 1;
                    while (n6 < 16) {
                        if (MixedDirectAudioRenderer.buffers[n6].allocated && !MixedDirectAudioRenderer.buffers[n6].instop) {
                            bl = false;
                            break;
                        }
                        ++n6;
                    }
                    if (bl && n4 < 16) {
                        n2 = MixedDirectAudioRenderer.buffers[n4].validLen;
                        System.arraycopy(MixedDirectAudioRenderer.buffers[n4].data, 0, mixpcm, 0, n2);
                        buffer.setLength(n2);
                        buffer.setData(mixpcm);
                        buffer.setOffset(0);
                        MixedDirectAudioRenderer.buffers[n4].consumed = true;
                    } else if (n4 < 16) {
                        int n7;
                        n3 = 0;
                        if (is16Bit) {
                            n7 = 0;
                            while (n7 < sArray.length) {
                                sArray[n7] = 0;
                                ++n7;
                            }
                        } else {
                            n7 = 0;
                            while (n7 < mixpcm.length) {
                                MixedDirectAudioRenderer.mixpcm[n7] = 0;
                                ++n7;
                            }
                        }
                        n7 = n4;
                        while (n7 < 16) {
                            if (MixedDirectAudioRenderer.buffers[n7].allocated && !MixedDirectAudioRenderer.buffers[n7].instop) {
                                n2 = MixedDirectAudioRenderer.buffers[n7].validLen;
                                if (is16Bit) {
                                    this.add16PCMData(sArray, MixedDirectAudioRenderer.buffers[n7].data, n2);
                                } else {
                                    this.add8PCMData(mixpcm, MixedDirectAudioRenderer.buffers[n7].data, n2);
                                }
                                if (n2 > n3) {
                                    n3 = n2;
                                }
                                MixedDirectAudioRenderer.buffers[n7].consumed = true;
                            }
                            ++n7;
                        }
                        if (is16Bit) {
                            this.convertShort2Byte(sArray, mixpcm, n3);
                        }
                        buffer.setData(mixpcm);
                        buffer.setLength(n3);
                        buffer.setOffset(0);
                        buffer.setFormat(curFormat);
                    }
                    if (n4 < 16) {
                        renderer.process(buffer);
                    }
                    numSofar = 0;
                    locks.notifyAll();
                }
                Thread.currentThread();
                Thread.yield();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        mixThread = null;
    }

    void add16PCMData(short[] sArray, byte[] byArray, int n2) {
        block9: {
            int n3;
            block8: {
                n3 = 0;
                if (!isBigEndian || !isSigned) break block8;
                int n4 = 0;
                while (n4 < n2 / 2) {
                    n3 = n4 << 1;
                    short s = sArray[n4];
                    short s2 = (short)(byArray[n3 + 1] & 0xFF | byArray[n3] << 8 & 0xFF00);
                    int n5 = s + s2;
                    if (s > 0 && s2 > 0 && n5 < 0) {
                        n5 = Short.MAX_VALUE;
                    } else if (s < 0 && s2 < 0 && n5 > 0) {
                        n5 = Short.MIN_VALUE;
                    }
                    sArray[n4] = n5;
                    ++n4;
                }
                break block9;
            }
            if (isBigEndian || !isSigned) break block9;
            int n6 = 0;
            while (n6 < n2 / 2) {
                n3 = n6 << 1;
                short s = sArray[n6];
                short s3 = (short)(byArray[n3] & 0xFF | byArray[n3 + 1] << 8 & 0xFF00);
                int n7 = s + s3;
                if (s > 0 && s3 > 0 && n7 < 0) {
                    n7 = Short.MAX_VALUE;
                } else if (s < 0 && s3 < 0 && n7 > 0) {
                    n7 = Short.MIN_VALUE;
                }
                sArray[n6] = n7;
                ++n6;
            }
        }
    }

    void convertShort2Byte(short[] sArray, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = n2 / 2;
        if (isBigEndian) {
            int n5 = 0;
            while (n5 < n4) {
                n3 = n5 << 1;
                byArray[n3] = (byte)(sArray[n5] >> 8 & 0xFF);
                byArray[n3 + 1] = (byte)(sArray[n5] & 0xFF);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                n3 = n6 << 1;
                byArray[n3] = (byte)(sArray[n6] & 0xFF);
                byArray[n3 + 1] = (byte)(sArray[n6] >> 8 & 0xFF);
                ++n6;
            }
        }
    }

    void add8PCMData(byte[] byArray, byte[] byArray2, int n2) {
        if (isSigned) {
            int n3 = 0;
            while (n3 < n2) {
                byte by = byArray[n3];
                byte by2 = byArray2[n3];
                int n4 = by + by2;
                if (by > 0 && by2 > 0 && n4 < 0) {
                    n4 = 127;
                } else if (by < 0 && by2 < 0 && n4 > 0) {
                    n4 = -128;
                }
                byArray[n3] = n4;
                ++n3;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        renderer = null;
        mixThread = null;
        opened = false;
        started = false;
        curFormat = null;
        numstreams = 0;
        numSofar = 0;
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            renderer = (DirectAudioRenderer)SimpleGraphBuilder.createPlugIn(name, 4);
            GainControl gainControl = (GainControl)renderer.getControl("javax.media.GainControl");
            gainControl.setDB(3.72f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        buffers = new BufSlot[16];
        int n2 = 0;
        while (n2 < 16) {
            MixedDirectAudioRenderer.buffers[n2] = new BufSlot();
            ++n2;
        }
        mixpcm = new byte[160];
        locks = new Object();
        nextBufPtr = 0;
        opened = false;
        started = false;
        numstreams = 0;
        numSofar = 0;
        curFormat = null;
        isBigEndian = true;
        is16Bit = true;
        isSigned = true;
    }
}

