/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.sun.media.renderer.audio.device.SunAudioOutput;
import com.sun.media.util.LoopThread;

class SunAudioPlayThread
extends LoopThread {
    long initialTime;
    long currentTime;
    int samplesUpdated;
    int sunAudioInternalDelay = -1;
    SunAudioOutput sunAudioOutput;

    SunAudioPlayThread() {
        this.setName(this.getName() + ": " + this);
    }

    void setStream(SunAudioOutput sunAudioOutput) {
        this.sunAudioOutput = sunAudioOutput;
    }

    public void resetSampleCountTime() {
        this.initialTime = System.currentTimeMillis();
    }

    public synchronized void start() {
        this.currentTime = System.currentTimeMillis();
        super.start();
    }

    public void setInternalDelay(int n2) {
        if (n2 >= 0) {
            this.sunAudioInternalDelay = n2;
        }
        this.sunAudioOutput.setPaddingLength(this.sunAudioInternalDelay * 2);
    }

    protected boolean process() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.sunAudioInternalDelay >= 0) {
            int n2;
            this.currentTime = System.currentTimeMillis();
            this.samplesUpdated = (int)((this.currentTime - this.initialTime) * 8L);
            if (this.samplesUpdated >= 0 && !this.sunAudioOutput.paused && (n2 = this.sunAudioOutput.sunAudioInitialCount + this.samplesUpdated) > this.sunAudioOutput.samplesPlayed && n2 <= this.sunAudioOutput.sunAudioFinalCount && n2 - this.sunAudioInternalDelay > this.sunAudioOutput.samplesPlayed) {
                this.sunAudioOutput.samplesPlayed = n2 - this.sunAudioInternalDelay;
            }
        }
        return true;
    }
}

