/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.ExtBuffer;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.WindowUtil;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.io.Serializable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class XILRenderer
extends BasicVideoRenderer
implements DynamicPlugIn {
    private static boolean available = true;
    public static Integer XILLock = new Integer(1);
    private int nativeData = 0;
    protected Object data = null;
    private int defBitsPerPixel = 32;
    private int defRedMask = 255;
    private int defGreenMask = 65280;
    private int defBlueMask = 0xFF0000;
    private int offsetX = 0;
    private int offsetY = 0;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private int oldWidth = -1;
    private int oldHeight = -1;
    protected VideoFormat defaultFormat;
    boolean componentChanged = false;

    private synchronized native boolean xilInitialize();

    private synchronized native boolean xilSetComponent(int var1, int var2);

    private synchronized native boolean xilSetInputFormat(int var1, int var2, int var3);

    private synchronized native boolean xilSetOutputSize(int var1, int var2);

    private synchronized native boolean xilDraw(int var1, int var2, int var3, int var4, Object var5, long var6);

    private synchronized native boolean xilFree();

    public XILRenderer() {
        super("XIL Renderer");
        Object object;
        boolean bl = false;
        try {
            object = JMFSecurityManager.getJMFSecurity();
            if (object.getClass().getName().equals("com.sun.media.NetscapeSecurity")) {
                bl = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!available || !WindowUtil.canUseXIL(bl)) {
            available = false;
            throw new RuntimeException("No XIL on Solaris 2.6 w/Green Threads");
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmxil");
        }
        catch (Exception exception) {
            available = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            available = false;
        }
        if (!available) {
            throw new RuntimeException("Could not load libjmxil library");
        }
        object = XILLock;
        synchronized (object) {
            if (available) {
                if (this.xilInitialize()) {
                    this.defaultFormat = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, this.defRedMask, this.defGreenMask, this.defBlueMask, 1, -1, 0, -1);
                    this.supportedFormats = new VideoFormat[1];
                    this.supportedFormats[0] = this.defaultFormat;
                } else {
                    System.err.println("XILRenderer.xilInitialize() failed");
                    available = false;
                }
            }
        }
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("XIL not available");
        }
    }

    public void reset() {
    }

    public synchronized void close() {
        Integer n2 = XILLock;
        synchronized (n2) {
            if (available && this.nativeData != 0) {
                this.xilFree();
            }
        }
    }

    public Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (!(format instanceof RGBFormat)) {
            return null;
        }
        if (!(Toolkit.getDefaultToolkit().getColorModel() instanceof DirectColorModel)) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            Class clazz;
            Serializable serializable;
            if (this.inputFormat instanceof RGBFormat) {
                serializable = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = ((RGBFormat)serializable).getBitsPerPixel();
                this.rMask = ((RGBFormat)serializable).getRedMask();
                this.gMask = ((RGBFormat)serializable).getGreenMask();
                this.bMask = ((RGBFormat)serializable).getBlueMask();
                this.lineStride = ((RGBFormat)serializable).getLineStride();
                this.pixelStride = ((RGBFormat)serializable).getPixelStride();
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else {
                return null;
            }
            serializable = XILLock;
            synchronized (serializable) {
                this.xilSetInputFormat(this.inWidth, this.inHeight, this.lineStride);
                this.componentChanged = false;
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if ((clazz = this.inputFormat.getDataType()) == Format.intArray) {
                this.bytesPerPixel = 4;
            } else if (clazz == Format.shortArray) {
                this.bytesPerPixel = 2;
            } else if (clazz == Format.byteArray) {
                this.bytesPerPixel = 1;
            }
            return format;
        }
        return null;
    }

    protected synchronized void removingComponent() {
        this.close();
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    protected int doProcess(Buffer buffer, boolean bl) {
        if (!available || this.component == null) {
            return 0;
        }
        XILRenderer xILRenderer = this;
        synchronized (xILRenderer) {
            Integer n2;
            int n3;
            if (!this.componentAvailable || !this.component.isShowing()) {
                int n4 = 0;
                return n4;
            }
            if (this.nativeData == 0) {
                Toolkit.getDefaultToolkit().sync();
                n3 = WindowUtil.getWindowHandle(this.component);
                if (n3 != 0) {
                    n2 = XILLock;
                    synchronized (n2) {
                        this.xilSetComponent(n3, this.defBitsPerPixel);
                    }
                    this.inputFormat = new VideoFormat(null);
                    this.componentChanged = true;
                    if (this.nativeData == 0) {
                        int n5 = 1;
                        return n5;
                    }
                } else {
                    int n6 = 0;
                    return n6;
                }
            }
            if (!bl) {
                this.data = null;
                if (!buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
                    n3 = 1;
                    return n3;
                }
                if (buffer instanceof ExtBuffer) {
                    ((ExtBuffer)buffer).setNativePreferred(true);
                    this.data = ((ExtBuffer)buffer).getNativeData();
                }
                if (this.data == null) {
                    this.data = buffer.getData();
                }
            } else if (this.data == null || this.componentChanged) {
                n3 = 1;
                return n3;
            }
            n2 = XILLock;
            synchronized (n2) {
                if (this.outWidth > 0 && this.outHeight > 0) {
                    long l2 = 0L;
                    if (this.data instanceof NBA) {
                        l2 = ((NBA)this.data).data;
                    }
                    if (this.data == null) {
                        int n7 = 0;
                        return n7;
                    }
                    int n8 = this.xilDraw(this.offsetX, this.offsetY, this.outWidth, this.outHeight, this.data, l2) ? 0 : 1;
                    return n8;
                }
                int n9 = 1;
                return n9;
            }
        }
    }

    public Format[] getBaseInputFormats() {
        Format[] formatArray = new Format[]{new RGBFormat()};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formatArray = new Format[]{};
        return formatArray;
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }
}

