/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.rtsp.TimerListener;
import java.util.Vector;

public class Timer
extends Thread
implements Runnable {
    private Vector listeners = new Vector();
    private long duration;
    private boolean stopped;

    public Timer(TimerListener timerListener, long l2) {
        this.duration = l2 / 1000000L;
        this.addListener(timerListener);
        this.stopped = false;
    }

    public void reset() {
    }

    public void stopTimer() {
        this.stopped = true;
        Timer timer = this;
        synchronized (timer) {
            this.notify();
        }
    }

    public void run() {
        Timer timer = this;
        synchronized (timer) {
            try {
                this.wait(this.duration);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!this.stopped) {
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                TimerListener timerListener = (TimerListener)this.listeners.elementAt(n2);
                timerListener.timerExpired();
                ++n2;
            }
        }
    }

    public void addListener(TimerListener timerListener) {
        this.listeners.addElement(timerListener);
    }

    public void removeListener(TimerListener timerListener) {
        this.listeners.removeElement(timerListener);
    }
}

