/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.ui.TabControl;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import jmapps.export.PanelMediaTargetType;
import jmapps.ui.ImageArea;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class PanelMediaTargetFormat
extends JMPanel
implements ActionListener,
ItemListener {
    private Processor processor = null;
    private String strTargetType = PanelMediaTargetType.TYPE_OTHER;
    private ContentDescriptor[] arrContentDescriptors = null;
    private Hashtable hashtableContentDescriptors = null;
    private TrackControl[] arrTrackControls = null;
    private String[] arrAllowContentType = null;
    private JMPanel panelContent;
    private Choice comboContentType;
    private TabControl tabControl;
    private Vector vectorPanelsAudio;
    private Vector vectorPanelsVideo;
    private Vector vectorTracksAudio;
    private Vector vectorTracksVideo;
    private Image imageAudioEn = null;
    private Image imageAudioDis = null;
    private Image imageVideoEn = null;
    private Image imageVideoDis = null;

    public PanelMediaTargetFormat() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAllowContentType(String[] stringArray) {
        this.arrAllowContentType = stringArray;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new GridLayout(0, 1));
        this.add((Component)panel, "North");
        panel.add(new Label(JMFI18N.getResource("jmstudio.export.format.label1")));
        panel.add(new Label(JMFI18N.getResource("jmstudio.export.format.label2")));
        this.panelContent = new JMPanel(new BorderLayout(6, 6));
        this.panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)this.panelContent, "Center");
        this.imageAudioEn = ImageArea.loadImage("audio.gif", this, true);
        this.imageAudioDis = ImageArea.loadImage("audio-disabled.gif", this, true);
        this.imageVideoEn = ImageArea.loadImage("video.gif", this, true);
        this.imageVideoDis = ImageArea.loadImage("video-disabled.gif", this, true);
    }

    public void setProcessor(Processor processor, String string, String string2) {
        this.processor = processor;
        this.strTargetType = string2;
        this.arrContentDescriptors = processor.getSupportedContentDescriptors();
        this.arrTrackControls = processor.getTrackControls();
        this.panelContent.removeAll();
        this.buildPage();
        if (string2.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            string = new ContentDescriptor("raw.rtp").toString();
        }
        if (string2.equals(PanelMediaTargetType.TYPE_SCREEN)) {
            string = new ContentDescriptor("raw").toString();
        }
        if (string != null) {
            this.comboContentType.select(string);
        }
        this.changeContentType();
    }

    public void updateProcessorFormat() {
        Format format;
        TrackControl trackControl;
        int n2 = this.vectorPanelsVideo.size();
        int n3 = 0;
        while (n3 < n2) {
            VideoFormatChooser videoFormatChooser = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(n3);
            trackControl = (TrackControl)this.vectorTracksVideo.elementAt(n3);
            if (!videoFormatChooser.isTrackEnabled()) {
                trackControl.setEnabled(false);
            } else {
                format = videoFormatChooser.getFormat();
                if (format == null) {
                    MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen video format. Track will be disabled.");
                    trackControl.setEnabled(false);
                } else {
                    trackControl.setEnabled(true);
                    trackControl.setFormat(format);
                }
            }
            ++n3;
        }
        n2 = this.vectorPanelsAudio.size();
        n3 = 0;
        while (n3 < n2) {
            AudioFormatChooser audioFormatChooser = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(n3);
            trackControl = (TrackControl)this.vectorTracksAudio.elementAt(n3);
            if (!audioFormatChooser.isTrackEnabled()) {
                trackControl.setEnabled(false);
            } else {
                format = audioFormatChooser.getFormat();
                if (format == null) {
                    MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen audio format. Track will be disabled.");
                    trackControl.setEnabled(false);
                } else {
                    trackControl.setEnabled(true);
                    trackControl.setFormat(format);
                }
            }
            ++n3;
        }
    }

    public boolean[] getEnabledVideoTracks() {
        int n2 = this.vectorPanelsVideo.size();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            VideoFormatChooser videoFormatChooser = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(n3);
            blArray[n3] = videoFormatChooser.isTrackEnabled();
            ++n3;
        }
        return blArray;
    }

    public boolean[] getEnabledAudioTracks() {
        int n2 = this.vectorPanelsAudio.size();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            AudioFormatChooser audioFormatChooser = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(n3);
            blArray[n3] = audioFormatChooser.isTrackEnabled();
            ++n3;
        }
        return blArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            if (object instanceof AudioFormatChooser) {
                this.tabControl.setPageImage((Panel)object, this.imageAudioEn);
            }
        } else if (string.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            if (object instanceof AudioFormatChooser) {
                this.tabControl.setPageImage((Panel)object, this.imageAudioDis);
            }
        } else if (string.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            if (object instanceof VideoFormatChooser) {
                this.tabControl.setPageImage((Panel)object, this.imageVideoEn);
            }
        } else if (string.equals("ACTION_VIDEO_TRACK_DISABLED") && object instanceof VideoFormatChooser) {
            this.tabControl.setPageImage((Panel)object, this.imageVideoDis);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.comboContentType) {
            this.changeContentType();
        }
    }

    private void buildPage() {
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.panelContent.add((Component)panel, "North");
        Label label = new Label(JMFI18N.getResource("jmstudio.export.format.format"));
        panel.add((Component)label, "West");
        this.comboContentType = new Choice();
        this.comboContentType.addItemListener(this);
        int n2 = this.arrContentDescriptors.length;
        this.hashtableContentDescriptors = new Hashtable();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.arrContentDescriptors[n3].getContentType();
            if (this.isContentTypeAllowed(string)) {
                string = this.arrContentDescriptors[n3].toString();
                this.comboContentType.addItem(string);
                this.hashtableContentDescriptors.put(string, this.arrContentDescriptors[n3]);
            }
            ++n3;
        }
        panel.add((Component)this.comboContentType, "Center");
        Panel panel2 = this.buildTrackFormatPanel();
        this.panelContent.add((Component)panel2, "Center");
    }

    private Panel buildTrackFormatPanel() {
        Format format;
        int n2 = 0;
        int n3 = 0;
        String string = JMFI18N.getResource("jmstudio.export.format.audio");
        String string2 = JMFI18N.getResource("jmstudio.export.format.video");
        String string3 = JMFI18N.getResource("jmstudio.export.format.hinted");
        this.tabControl = new TabControl(0);
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        n3 = 0;
        this.vectorPanelsAudio = new Vector();
        this.vectorPanelsVideo = new Vector();
        this.vectorTracksAudio = new Vector();
        this.vectorTracksVideo = new Vector();
        int n6 = this.arrTrackControls.length;
        int n7 = 0;
        while (n7 < n6) {
            format = this.arrTrackControls[n7].getFormat();
            if (format instanceof VideoFormat) {
                ++n3;
            }
            if (format instanceof AudioFormat) {
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            String string4;
            String string5;
            format = this.arrTrackControls[n7].getFormat();
            if (format instanceof AudioFormat) {
                string5 = n2 < 2 ? new String(string) : new String(string + " " + ++n4);
                string4 = format.getEncoding();
                if (string4.endsWith("/rtp")) {
                    string5 = string5 + " " + string3;
                }
                AudioFormatChooser audioFormatChooser = new AudioFormatChooser(this.arrTrackControls[n7].getSupportedFormats(), (AudioFormat)format, true, this);
                audioFormatChooser.setTrackEnabled(this.arrTrackControls[n7].isEnabled());
                this.tabControl.addPage(audioFormatChooser, string5, this.imageAudioEn);
                this.vectorPanelsAudio.addElement(audioFormatChooser);
                this.vectorTracksAudio.addElement(this.arrTrackControls[n7]);
            } else if (format instanceof VideoFormat) {
                string5 = n3 < 2 ? new String(string2) : new String(string2 + " " + ++n5);
                string4 = format.getEncoding();
                if (string4.endsWith("/rtp")) {
                    string5 = string5 + " " + string3;
                }
                VideoFormatChooser videoFormatChooser = new VideoFormatChooser(this.arrTrackControls[n7].getSupportedFormats(), (VideoFormat)format, true, this);
                videoFormatChooser.setTrackEnabled(this.arrTrackControls[n7].isEnabled());
                this.tabControl.addPage(videoFormatChooser, string5, this.imageVideoEn);
                this.vectorPanelsVideo.addElement(videoFormatChooser);
                this.vectorTracksVideo.addElement(this.arrTrackControls[n7]);
            }
            ++n7;
        }
        return this.tabControl;
    }

    private void changeContentType() {
        TrackControl trackControl;
        String string = this.comboContentType.getSelectedItem();
        ContentDescriptor contentDescriptor = (ContentDescriptor)this.hashtableContentDescriptors.get(string);
        if (this.processor.setContentDescriptor(contentDescriptor) == null) {
            System.err.println("Error setting content descriptor on processor");
        }
        int n2 = this.vectorPanelsVideo.size();
        int n3 = 0;
        while (n3 < n2) {
            VideoFormatChooser videoFormatChooser = (VideoFormatChooser)this.vectorPanelsVideo.elementAt(n3);
            trackControl = (TrackControl)this.vectorTracksVideo.elementAt(n3);
            videoFormatChooser.setSupportedFormats(trackControl.getSupportedFormats(), (VideoFormat)trackControl.getFormat());
            ++n3;
        }
        n2 = this.vectorPanelsAudio.size();
        n3 = 0;
        while (n3 < n2) {
            AudioFormatChooser audioFormatChooser = (AudioFormatChooser)this.vectorPanelsAudio.elementAt(n3);
            trackControl = (TrackControl)this.vectorTracksAudio.elementAt(n3);
            audioFormatChooser.setSupportedFormats(trackControl.getSupportedFormats(), (AudioFormat)trackControl.getFormat());
            ++n3;
        }
    }

    private boolean isContentTypeAllowed(String string) {
        boolean bl = false;
        if (this.arrAllowContentType != null) {
            int n2 = 0;
            while (n2 < this.arrAllowContentType.length && !bl) {
                if (this.arrAllowContentType[n2].equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n2;
            }
        } else if (this.strTargetType.equals(PanelMediaTargetType.TYPE_NETWORK)) {
            String string2 = ContentDescriptor.mimeTypeToPackageName("raw");
            String string3 = ContentDescriptor.mimeTypeToPackageName("raw.rtp");
            if (string.equals(string2) || string.equals(string3)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }
}

