/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class OpenRtpDialog
extends JMDialog
implements TextListener,
FocusListener {
    private TextField fieldAddress0;
    private TextField fieldAddress1;
    private TextField fieldAddress2;
    private TextField fieldAddress3;
    private TextField fieldPort;
    private Choice choiceTtl;
    private JMAppsCfg cfgJMApps = null;
    private String strAddress = null;
    private String strPort = null;
    private String strTtl = null;

    public OpenRtpDialog(Frame frame, JMAppsCfg jMAppsCfg) {
        super(frame, JMFI18N.getResource("jmstudio.openrtp.title"), true);
        this.cfgJMApps = jMAppsCfg;
        this.init();
    }

    public String getAddress() {
        return this.strAddress;
    }

    public String getPort() {
        return this.strPort;
    }

    public String getTtl() {
        return this.strTtl;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        jMPanel.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)jMPanel, "Center");
        jMPanel.setBackground(Color.lightGray);
        JMPanel jMPanel2 = this.createPanelSource();
        jMPanel.add((Component)jMPanel2, "Center");
        jMPanel2 = new JMPanel(new FlowLayout(1));
        this.add((Component)jMPanel2, "South");
        JMPanel jMPanel3 = this.createButtonPanel(new String[]{JMDialog.ACTION_OPEN, JMDialog.ACTION_CANCEL});
        jMPanel2.add(jMPanel3);
        this.pack();
        this.setResizable(false);
    }

    private JMPanel createPanelSource() {
        JMAppsCfg.RtpData rtpData = this.cfgJMApps.getLastOpenRtpData();
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        JMPanel jMPanel2 = new JMPanel(new GridLayout(0, 1, 6, 6));
        jMPanel.add((Component)jMPanel2, "West");
        JMPanel jMPanel3 = new JMPanel(new GridLayout(0, 1, 6, 6));
        jMPanel.add((Component)jMPanel3, "Center");
        Label label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.address"));
        jMPanel2.add(label);
        JMPanel jMPanel4 = new JMPanel(new GridLayout(1, 0, 2, 2));
        jMPanel3.add(jMPanel4);
        this.fieldAddress0 = new TextField(3);
        if (rtpData != null) {
            this.fieldAddress0.setText(rtpData.strAddress0);
        }
        this.fieldAddress0.addTextListener(this);
        this.fieldAddress0.addFocusListener(this);
        jMPanel4.add(this.fieldAddress0);
        this.fieldAddress1 = new TextField(3);
        if (rtpData != null) {
            this.fieldAddress1.setText(rtpData.strAddress1);
        }
        this.fieldAddress1.addTextListener(this);
        this.fieldAddress1.addFocusListener(this);
        jMPanel4.add(this.fieldAddress1);
        this.fieldAddress2 = new TextField(3);
        if (rtpData != null) {
            this.fieldAddress2.setText(rtpData.strAddress2);
        }
        this.fieldAddress2.addTextListener(this);
        this.fieldAddress2.addFocusListener(this);
        jMPanel4.add(this.fieldAddress2);
        this.fieldAddress3 = new TextField(3);
        if (rtpData != null) {
            this.fieldAddress3.setText(rtpData.strAddress3);
        }
        this.fieldAddress3.addTextListener(this);
        this.fieldAddress3.addFocusListener(this);
        jMPanel4.add(this.fieldAddress3);
        label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.port"));
        jMPanel2.add(label);
        this.fieldPort = new TextField(5);
        if (rtpData != null) {
            this.fieldPort.setText(rtpData.strPort);
        }
        this.fieldPort.addFocusListener(this);
        jMPanel3.add(this.fieldPort);
        label = new Label(JMFI18N.getResource("jmstudio.openrtp.label.ttl"));
        jMPanel2.add(label);
        this.choiceTtl = new Choice();
        jMPanel3.add(this.choiceTtl);
        this.choiceTtl.addItem("1");
        this.choiceTtl.addItem("2");
        this.choiceTtl.addItem("3");
        this.choiceTtl.addItem("4");
        this.choiceTtl.addItem("8");
        this.choiceTtl.addItem("16");
        this.choiceTtl.addItem("32");
        this.choiceTtl.addItem("64");
        this.choiceTtl.addItem("128");
        this.choiceTtl.addItem("255");
        if (rtpData != null) {
            this.choiceTtl.select(rtpData.strTtl);
        }
        return jMPanel;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fieldAddress0.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(JMDialog.ACTION_OPEN)) {
            if (this.validateData()) {
                this.setAction(string);
                this.dispose();
            }
        } else if (string.equals(JMDialog.ACTION_CANCEL)) {
            this.setAction(string);
            this.dispose();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        TextField textField;
        String string;
        Object object = textEvent.getSource();
        if (object instanceof TextField && (string = (textField = (TextField)object).getText()).length() > 2) {
            textField.transferFocus();
        }
    }

    public boolean validateData() {
        int n2;
        String string;
        JMAppsCfg.RtpData rtpData = this.cfgJMApps.createRtpDataObject();
        rtpData.strAddress0 = string = this.fieldAddress0.getText();
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 < 0 || n2 > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = new String(string);
        rtpData.strAddress1 = string = this.fieldAddress1.getText();
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 < 0 || n2 > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + string;
        rtpData.strAddress2 = string = this.fieldAddress2.getText();
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 < 0 || n2 > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + string;
        rtpData.strAddress3 = string = this.fieldAddress3.getText();
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 < 0 || n2 > 255) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.sessionaddr"));
            return false;
        }
        this.strAddress = this.strAddress + "." + string;
        rtpData.strPort = this.strPort = this.fieldPort.getText();
        try {
            n2 = Integer.valueOf(this.strPort);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 < 0 || (n2 & 1) == 1) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.port"));
            return false;
        }
        rtpData.strTtl = this.strTtl = this.choiceTtl.getSelectedItem();
        if (this.cfgJMApps != null) {
            this.cfgJMApps.setLastOpenRtpData(rtpData);
        }
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof TextField) {
            ((TextField)object).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof TextField) {
            ((TextField)object).select(1, 0);
        }
    }
}

