/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.g723;

import com.ibm.media.codec.audio.g723.DecoderData;
import com.ibm.media.codec.audio.g723.G723Tables;
import com.ibm.media.codec.audio.g723.LINEDEF;
import com.ibm.media.codec.audio.g723.PFDEF;
import com.ibm.media.codec.audio.g723.SFSDEF;

public final class G723Dec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1998.";
    private DecoderData decoderData;
    private final float[] decode_OutputBuffer = new float[240];
    private final float[] decode_QntLpc = new float[40];
    private final float[] decode_AcbkCont = new float[60];
    private final float[] decode_LspVect = new float[10];
    private final LINEDEF decode_Line = new LINEDEF();
    private final PFDEF[] decode_Pf = new PFDEF[]{new PFDEF(), new PFDEF(), new PFDEF(), new PFDEF()};
    private final int[] decode_flag = new int[1];
    private final int[] decode_Ftyp = new int[1];
    private final float[] decode_SyntIir = new float[250];
    private final float[] decode_PostFir = new float[250];
    private final float[] decode_PostIir = new float[250];
    private final int[] Line_Unpk_index = new int[1];
    private final int[] Line_Unpk_BitStream = new int[192];
    private final float[] Gen_Trn_TmpBuf = new float[60];
    float[] Decod_Acbk_RezBuf = new float[67];
    private final float[] lspArrayP = new float[6];
    private final float[] lspArrayQ = new float[6];
    private final float[] lspParamLsp = new float[10];
    private static final float[] fLspDcTable = G723Tables.fLspDcTable;
    private static final float[] fBand0Tb8 = G723Tables.fBand0Tb8;
    private static final float[] fBand1Tb8 = G723Tables.fBand1Tb8;
    private static final float[] fBand2Tb8 = G723Tables.fBand2Tb8;
    private static final float[][] fBandQntTable = new float[][]{fBand0Tb8, fBand1Tb8, fBand2Tb8};
    private static final float[] fAcbkGainTable085 = G723Tables.fAcbkGainTable085;
    private static final float[] fAcbkGainTable170 = G723Tables.fAcbkGainTable170;
    private static final float[][] AcbkGainTablePtr = new float[][]{fAcbkGainTable085, fAcbkGainTable170};
    private static final float[] FcbkGainTable = G723Tables.FcbkGainTable;
    private static final float[] CosFunction = G723Tables.CosFunction;
    private static final int[][] CombinatorialTable = G723Tables.CombinatorialTable;
    private static final int[][] fBandInfoTable;
    private static final int[] MaxPosTable;
    private static final boolean INCLUDE_POST_FILTER = true;
    private static final int Rate63 = 0;
    private static final short CRC = 0;
    private static final int LpcOrder = 10;
    private static final int SubFrames = 4;
    private static final int Frame = 240;
    private static final int LpcFrame = 180;
    private static final int SubFrLen = 60;
    private static final int LspQntBands = 3;
    private static final int LspCbSize = 256;
    private static final int LspCbBits = 8;
    private static final float BandExpFactor = 0.994f;
    private static final float LspPredictor = 0.375f;
    private static final float LspPredictor2 = 0.71875f;
    private static final int ClPitchOrd = 5;
    private static final int PITCH_INDEX = 2;
    private static final int Pstep = 1;
    private static final int PitchMin = 18;
    private static final int PitchMax = 145;
    private static final int HIGH_RATE_BITSTREAM = 0;
    private static final int LOW_RATE_BITSTREAM = 1;
    private static final int SID_BITSTREAM = 2;
    private static final int UNTRANSMITTED_BITSTREAM = 3;
    private static final int G723_OK = 0;
    private static final int G723_ERR = 1;
    private static final int G723_RATE_MISMATCH = 2;
    private static final int G723_ILLEGAL_BITSTREAM = 3;
    private static final int G723_ILLEGAL_PARAMETER = 4;
    private static final int G723_VAD_BITSTREAM = 5;
    private static final int SILENCE_FRAME = 0;
    private static final int VOICE_FRAME = 1;
    private static final int SID_FRAME = 2;
    private static final int NumOfGainLev = 24;
    private static final int MaxPulseNum = 6;
    private static final int Sgrid = 2;
    private static final int DECODER_OUTPUT_SIZE = 240;
    private static final int NUM_OF_BLOCKS = 4;
    private static final int ErrMaxNum = 3;
    private static final float ALPHA = 0.0625f;
    private static final float FLT_MIN = Float.MIN_NORMAL;
    private static final float SHRT_MIN = -32767.0f;
    private static final float SHRT_MAX = 32767.0f;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[2];
        nArray[1] = 3;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{3, 3};
        nArrayArray[2] = new int[]{6, 4};
        fBandInfoTable = nArrayArray;
        MaxPosTable = new int[]{593775, 142506, 593775, 142506};
    }

    private final void Comp_Lpf(float[] fArray, int n2, int n3, int n4, PFDEF pFDEF) {
        float f2;
        float f3;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        pFDEF.Indx = 0;
        pFDEF.Gain = 0.0f;
        pFDEF.ScGn = 1.0f;
        int n5 = this.Find_B(fArray, n2, n3, n4);
        int n6 = this.Find_F(fArray, n2, n3, n4);
        if (n5 == 0 && n6 == 0) {
            return;
        }
        int n7 = n2 + 145 + n4 * 60;
        int n8 = 0;
        while (n8 < 60) {
            float f9 = fArray[n7 + n8];
            f3 = fArray[n7 + n8 + 1];
            f4 += f9 * f9 + f3 * f3;
            n8 += 2;
        }
        int n9 = n2 + 145 + n4 * 60;
        if (n5 != 0) {
            n8 = 0;
            while (n8 < 60) {
                f3 = fArray[n9 + n5 + n8];
                f2 = fArray[n9 + n5 + n8 + 1];
                f5 += fArray[n9 + n8] * f3 + fArray[n9 + n8 + 1] * f2;
                f6 += f3 * f3 + f2 * f2;
                n8 += 2;
            }
        }
        int n10 = n2 + 145 + n4 * 60;
        if (n6 != 0) {
            n8 = 0;
            while (n8 < 60) {
                f2 = fArray[n10 + n6 + n8];
                float f10 = fArray[n10 + n6 + n8 + 1];
                f7 += fArray[n10 + n8] * f2 + fArray[n10 + n8 + 1] * f10;
                f8 += f2 * f2 + f10 * f10;
                n8 += 2;
            }
        }
        if ((float)n5 != 0.0f && (float)n6 == 0.0f) {
            this.Get_Ind(n5, f4, f5, f6, pFDEF);
        }
        if ((float)n5 == 0.0f && (float)n6 != 0.0f) {
            this.Get_Ind(n6, f4, f7, f8, pFDEF);
        }
        if (n5 != 0 && n6 != 0) {
            if (f5 * f5 * f8 > f7 * f7 * f6) {
                this.Get_Ind(n5, f4, f5, f6, pFDEF);
            } else {
                this.Get_Ind(n6, f4, f7, f8, pFDEF);
            }
        }
    }

    private final void Decod_Acbk(float[] fArray, float[] fArray2, int n2, int n3, int n4, int n5, int n6) {
        float[] fArray3 = this.Decod_Acbk_RezBuf;
        int n7 = 0;
        int n8 = 3;
        this.Get_Rez(fArray3, fArray2, n2, n3 - 1 + n4);
        float[] fArray4 = fArray3;
        int n9 = 0;
        if (this.decoderData.WrkRate == 0) {
            if (n3 >= 58) {
                n9 = 1;
            }
        } else {
            n9 = 1;
        }
        float[] fArray5 = AcbkGainTablePtr[n9];
        float f2 = fArray5[n7 += n5 * 20];
        float f3 = fArray5[n7 + 1];
        float f4 = fArray5[n7 + 2];
        float f5 = fArray5[n7 + 3];
        float f6 = fArray5[n7 + 4];
        n9 = 0;
        while (n9 < 60) {
            fArray[n9] = fArray4[n9 + 3] * f2 + fArray4[n9 + 3 + 1] * f3 + fArray4[n9 + 3 + 2] * f4 + fArray4[n9 + 3 + 3] * f5 + fArray4[n9 + 3 + 4] * f6;
            ++n9;
        }
    }

    private final void Fcbk_Unpk(float[] fArray, int n2, SFSDEF sFSDEF, int n3, int n4) {
        switch (this.decoderData.WrkRate) {
            case 0: {
                int n5 = n4 == 0 || n4 == 2 ? 6 : 5;
                int n6 = n2;
                while (n6 < n2 + 60) {
                    fArray[n6] = 0.0f;
                    ++n6;
                }
                if (sFSDEF.Ppos >= MaxPosTable[n4]) {
                    return;
                }
                int n7 = 6 - n5;
                long l2 = sFSDEF.Ppos;
                n6 = 0;
                while (n6 < 30) {
                    if (l2 < (long)CombinatorialTable[n7][n6]) {
                        fArray[sFSDEF.Grid + 2 * n6 + n2] = (sFSDEF.Pamp & 1 << 6 - ++n7) != 0 ? -FcbkGainTable[sFSDEF.Mamp] : FcbkGainTable[sFSDEF.Mamp];
                        if (n7 == 6) {
                            break;
                        }
                    } else {
                        l2 -= (long)CombinatorialTable[n7][n6];
                    }
                    ++n6;
                }
                if (sFSDEF.Tran != 1) break;
                this.Gen_Trn(fArray, fArray, n2, n3);
                break;
            }
        }
    }

    private final void Filt_Lpf(float[] fArray, float[] fArray2, int n2, PFDEF pFDEF, int n3) {
        float f2 = pFDEF.ScGn;
        float f3 = pFDEF.Gain;
        int n4 = pFDEF.Indx;
        int n5 = n3 * 60;
        int n6 = n2 + 145 + n3 * 60;
        int n7 = n2 + 145 + n3 * 60 + n4;
        int n8 = 0;
        while (n8 < 60) {
            fArray[n5 + n8] = fArray2[n6 + n8] * f2 + fArray2[n7 + n8] * f3;
            ++n8;
        }
    }

    private final int Find_B(float[] fArray, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2 + 145 + n4 * 60;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (n3 > 142) {
            n3 = 142;
        }
        int n7 = n6 - (n3 - 3);
        int n8 = 0;
        while (n8 < 60) {
            float f10 = fArray[n6 + n8];
            f9 += f10 * fArray[n7 + n8];
            f8 += f10 * fArray[n7 + n8 - 1];
            f7 += f10 * fArray[n7 + n8 - 2];
            f6 += f10 * fArray[n7 + n8 - 3];
            f5 += f10 * fArray[n7 + n8 - 4];
            f4 += f10 * fArray[n7 + n8 - 5];
            f3 += f10 * fArray[n7 + n8 - 6];
            ++n8;
        }
        if (f9 > f2) {
            f2 = f9;
            n5 = -(n3 - 3);
        }
        if (f8 > f2) {
            f2 = f8;
            n5 = -(n3 - 2);
        }
        if (f7 > f2) {
            f2 = f7;
            n5 = -(n3 - 1);
        }
        if (f6 > f2) {
            f2 = f6;
            n5 = -n3;
        }
        if (f5 > f2) {
            f2 = f5;
            n5 = -(n3 + 1);
        }
        if (f4 > f2) {
            f2 = f4;
            n5 = -(n3 + 2);
        }
        if (f3 > f2) {
            f2 = f3;
            n5 = -(n3 + 3);
        }
        return n5;
    }

    private final int Find_F(float[] fArray, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 240 - n4 * 60 - 60;
        int n7 = n2 + 145 + n4 * 60;
        if (n3 > 142) {
            n3 = 142;
        }
        float f2 = 0.0f;
        if (n6 > n3 + 3) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            int n8 = n7 + (n3 - 3);
            int n9 = 0;
            while (n9 < 60) {
                float f10 = fArray[n7 + n9];
                f3 += f10 * fArray[n8 + n9];
                f4 += f10 * fArray[n8 + n9 + 1];
                f5 += f10 * fArray[n8 + n9 + 2];
                f6 += f10 * fArray[n8 + n9 + 3];
                f7 += f10 * fArray[n8 + n9 + 4];
                f8 += f10 * fArray[n8 + n9 + 5];
                f9 += f10 * fArray[n8 + n9 + 6];
                ++n9;
            }
            if (f3 > f2) {
                f2 = f3;
                n5 = n3 - 3;
            }
            if (f4 > f2) {
                f2 = f4;
                n5 = n3 - 2;
            }
            if (f5 > f2) {
                f2 = f5;
                n5 = n3 - 1;
            }
            if (f6 > f2) {
                f2 = f6;
                n5 = n3;
            }
            if (f7 > f2) {
                f2 = f7;
                n5 = n3 + 1;
            }
            if (f8 > f2) {
                f2 = f8;
                n5 = n3 + 2;
            }
            if (f9 > f2) {
                f2 = f9;
                n5 = n3 + 3;
            }
        } else {
            int n10 = n3 - 3;
            while (n10 <= n6) {
                int n11 = n7 + n10;
                float f11 = 0.0f;
                int n12 = 0;
                while (n12 < 60) {
                    f11 += fArray[n7 + n12] * fArray[n11 + n12];
                    ++n12;
                }
                if (f11 > f2) {
                    f2 = f11;
                    n5 = n10;
                }
                ++n10;
            }
        }
        return n5;
    }

    private final void Fl2Sh(float[] fArray, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            float f2 = fArray[n5];
            if (f2 < -32767.0f) {
                f2 = -32767.0f;
            } else if (f2 > 32767.0f) {
                f2 = 32767.0f;
            }
            int n6 = (int)f2;
            byArray[n3 + n4] = (byte)(n6 & 0xFF);
            byArray[n3 + n4 + 1] = (byte)(n6 >> 8);
            n4 += 2;
            ++n5;
        }
    }

    private final void Gen_Trn(float[] fArray, float[] fArray2, int n2, int n3) {
        float[] fArray3 = this.Gen_Trn_TmpBuf;
        int n4 = n3;
        System.arraycopy(fArray2, n2, fArray3, 0, 60);
        System.arraycopy(fArray2, n2, fArray, n2, 60);
        n4 = n3;
        while (n4 < 60) {
            int n5 = n4;
            while (n5 < 60) {
                int n6 = n5 + n2;
                fArray[n6] = fArray[n6] + fArray3[n5 - n4];
                ++n5;
            }
            n4 += n3;
        }
    }

    private final void Get_Ind(int n2, float f2, float f3, float f4, PFDEF pFDEF) {
        float f5;
        pFDEF.Indx = n2;
        float f6 = f5 = this.decoderData.WrkRate == 0 ? 0.1875f : 0.25f;
        if (f3 * f3 > 0.25f * f2 * f4) {
            pFDEF.Gain = f3 >= f4 ? f5 : f5 * f3 / f4;
            float f7 = f2 + 2.0f * pFDEF.Gain * f3 + pFDEF.Gain * pFDEF.Gain * f4;
            pFDEF.ScGn = f7 < Float.MIN_NORMAL ? 0.0f : (float)Math.sqrt(f2 / f7);
        } else {
            pFDEF.Gain = 0.0f;
            pFDEF.ScGn = 1.0f;
        }
        pFDEF.Gain *= pFDEF.ScGn;
    }

    private final void Get_Rez(float[] fArray, float[] fArray2, int n2, int n3) {
        int n4;
        int n5 = n2 + 145 - n3 - 2 - 3;
        if (n5 >= 0) {
            fArray[0] = fArray2[n5];
            fArray[1] = fArray2[n5 + 1];
            fArray[2] = fArray2[n5 + 2];
        }
        fArray[3] = fArray2[n5 + 3];
        fArray[4] = fArray2[n5 + 4];
        int n6 = 61 / n3;
        int n7 = 5;
        n5 = n2 + 145 - n3;
        int n8 = n5 + n3;
        int n9 = 0;
        while (n9 < n6) {
            n4 = n5;
            while (n4 < n8) {
                fArray[n7] = fArray2[n4];
                ++n4;
                ++n7;
            }
            ++n9;
        }
        int n10 = 62 - n7 + 2 + 3;
        n5 = n2 + 145 - n3;
        n8 = n5 + n10;
        n4 = n5;
        while (n4 < n8) {
            fArray[n7] = fArray2[n4];
            ++n4;
            ++n7;
        }
    }

    private final void Line_Unpk(byte[] byArray, int n2, int[] nArray, short s, int[] nArray2, LINEDEF lINEDEF) {
        int[] nArray3 = this.Line_Unpk_BitStream;
        int n3 = 0;
        int[] nArray4 = this.Line_Unpk_index;
        nArray4[0] = 0;
        lINEDEF.Crc = s;
        nArray2[0] = 0;
        if (s != 0) {
            return;
        }
        int n4 = 0;
        while (n4 < 192) {
            nArray3[n4] = byArray[n2 + (n4 >> 3)] >> (n4 & 7) & 1;
            ++n4;
        }
        short s2 = (short)this.Ser2Par(nArray3, nArray4, 2);
        if (s2 == 3 || s2 == 2) {
            lINEDEF.Crc = 1;
            nArray2[0] = 5;
            return;
        }
        if (s2 == 3) {
            nArray[0] = 0;
            lINEDEF.LspId = 0;
            return;
        }
        lINEDEF.LspId = this.Ser2Par(nArray3, nArray4, 24);
        if (s2 == 2) {
            lINEDEF.Sfs[0].Mamp = (short)this.Ser2Par(nArray3, nArray4, 6);
            nArray[0] = 2;
            return;
        }
        nArray[0] = 1;
        int n5 = this.Ser2Par(nArray3, nArray4, 7);
        if (n5 > 123) {
            nArray2[0] = 3;
            lINEDEF.Crc = 1;
            return;
        }
        lINEDEF.Olp[0] = (short)n5 + 18;
        lINEDEF.Sfs[1].AcLg = (short)this.Ser2Par(nArray3, nArray4, 2);
        n5 = this.Ser2Par(nArray3, nArray4, 7);
        if (n5 > 123) {
            nArray2[0] = 3;
            lINEDEF.Crc = 1;
            return;
        }
        lINEDEF.Olp[1] = (short)n5 + 18;
        lINEDEF.Sfs[3].AcLg = (short)this.Ser2Par(nArray3, nArray4, 2);
        lINEDEF.Sfs[0].AcLg = 1;
        lINEDEF.Sfs[2].AcLg = 1;
        n4 = 0;
        while (n4 < 4) {
            n5 = this.Ser2Par(nArray3, nArray4, 12);
            lINEDEF.Sfs[n4].Tran = 0;
            n3 = 170;
            if (this.decoderData.WrkRate == 0 && lINEDEF.Olp[n4 >> 1] < 58) {
                lINEDEF.Sfs[n4].Tran = (short)(n5 >> 11);
                n5 = (int)((long)n5 & 0x7FFL);
                n3 = 85;
            }
            lINEDEF.Sfs[n4].AcGn = (short)(n5 / 24);
            if (lINEDEF.Sfs[n4].AcGn >= n3) {
                nArray2[0] = 3;
                lINEDEF.Crc = 1;
                return;
            }
            lINEDEF.Sfs[n4].Mamp = (short)(n5 % 24);
            ++n4;
        }
        n4 = 0;
        while (n4 < 4) {
            int n6 = nArray4[0];
            nArray4[0] = n6 + 1;
            lINEDEF.Sfs[n4].Grid = nArray3[n6];
            ++n4;
        }
        if (this.decoderData.WrkRate == 0) {
            if (s2 != 0) {
                nArray2[0] = 2;
                lINEDEF.Crc = 1;
                return;
            }
        } else {
            nArray2[0] = 2;
            lINEDEF.Crc = 1;
            return;
        }
        nArray4[0] = nArray4[0] + 1;
        n5 = this.Ser2Par(nArray3, nArray4, 13);
        lINEDEF.Sfs[0].Ppos = n5 / 90 / 9;
        lINEDEF.Sfs[1].Ppos = n5 / 90 % 9;
        lINEDEF.Sfs[2].Ppos = n5 % 90 / 9;
        lINEDEF.Sfs[3].Ppos = n5 % 90 % 9;
        lINEDEF.Sfs[0].Ppos = (lINEDEF.Sfs[0].Ppos << 16) + this.Ser2Par(nArray3, nArray4, 16);
        lINEDEF.Sfs[1].Ppos = (lINEDEF.Sfs[1].Ppos << 14) + this.Ser2Par(nArray3, nArray4, 14);
        lINEDEF.Sfs[2].Ppos = (lINEDEF.Sfs[2].Ppos << 16) + this.Ser2Par(nArray3, nArray4, 16);
        lINEDEF.Sfs[3].Ppos = (lINEDEF.Sfs[3].Ppos << 14) + this.Ser2Par(nArray3, nArray4, 14);
        lINEDEF.Sfs[0].Pamp = (short)this.Ser2Par(nArray3, nArray4, 6);
        lINEDEF.Sfs[1].Pamp = (short)this.Ser2Par(nArray3, nArray4, 5);
        lINEDEF.Sfs[2].Pamp = (short)this.Ser2Par(nArray3, nArray4, 6);
        lINEDEF.Sfs[3].Pamp = (short)this.Ser2Par(nArray3, nArray4, 5);
    }

    private final void Lsp_Inq(float[] fArray, float[] fArray2, int n2, int n3) {
        int n4;
        float f2;
        float f3;
        if (n3 == 0) {
            f3 = 2.0f;
            f2 = 0.375f;
        } else {
            n2 = 0;
            f3 = 4.0f;
            f2 = 0.71875f;
        }
        int n5 = 2;
        while (n5 >= 0) {
            int n6 = n2 & 0xFF;
            n2 >>= 8;
            float[] fArray3 = fBandQntTable[n5];
            n4 = 0;
            while (n4 < fBandInfoTable[n5][1]) {
                fArray[G723Dec.fBandInfoTable[n5][0] + n4] = fArray3[n6 * fBandInfoTable[n5][1] + n4];
                ++n4;
            }
            --n5;
        }
        n4 = 0;
        while (n4 < 10) {
            int n7 = n4;
            fArray[n7] = fArray[n7] + (fArray2[n4] - fLspDcTable[n4]) * f2;
            int n8 = n4;
            fArray[n8] = fArray[n8] + fLspDcTable[n4];
            ++n4;
        }
        n5 = 0;
        while (n5 < 10) {
            if (fArray[0] < 3.0f) {
                fArray[0] = 3.0f;
            }
            if (fArray[9] > 252.0f) {
                fArray[9] = 252.0f;
            }
            n4 = 1;
            while (n4 < 10) {
                float f4 = f3 + fArray[n4 - 1] - fArray[n4];
                if (f4 > 0.0f) {
                    int n9 = n4 - 1;
                    fArray[n9] = fArray[n9] - (f4 *= 0.5f);
                    int n10 = n4;
                    fArray[n10] = fArray[n10] + f4;
                }
                ++n4;
            }
            boolean bl = false;
            n4 = 1;
            while (n4 < 10) {
                if ((double)(fArray[n4] - fArray[n4 - 1]) < (double)f3 - 0.03125) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) break;
            ++n5;
        }
    }

    private final void Lsp_Int(float[] fArray, float[] fArray2, float[] fArray3) {
        int n2 = 0;
        while (n2 < 4) {
            float f2 = (float)(3 - n2) * 0.25f;
            float f3 = 1.0f - f2;
            int n3 = 0;
            while (n3 < 10) {
                this.lspParamLsp[n3] = f2 * fArray3[n3] + f3 * fArray2[n3];
                ++n3;
            }
            this.LsptoA();
            System.arraycopy(this.lspParamLsp, 0, fArray, 10 * n2, 10);
            ++n2;
        }
        System.arraycopy(fArray2, 0, fArray3, 0, 10);
    }

    private final void LsptoA() {
        int n2;
        float[] fArray = this.lspArrayP;
        float[] fArray2 = this.lspArrayQ;
        float[] fArray3 = this.lspParamLsp;
        int n3 = 0;
        while (n3 < 10) {
            n2 = (int)fArray3[n3];
            float f2 = CosFunction[n2];
            float f3 = CosFunction[n2 + 1];
            fArray3[n3] = ((fArray3[n3] - (float)n2) * f3 + ((float)(n2 + 1) - fArray3[n3]) * f2) * -2.0f;
            ++n3;
        }
        fArray[0] = 1.0f;
        fArray[1] = fArray3[0] + fArray3[2];
        fArray[2] = 2.0f + fArray3[0] * fArray3[2];
        fArray2[0] = 1.0f;
        fArray2[1] = fArray3[1] + fArray3[3];
        fArray2[2] = 2.0f + fArray3[1] * fArray3[3];
        n3 = 2;
        while (n3 < 5) {
            fArray[n3 + 1] = fArray3[2 * n3] * fArray[n3] + 2.0f * fArray[n3 - 1];
            fArray2[n3 + 1] = fArray3[2 * n3 + 1] * fArray2[n3] + 2.0f * fArray2[n3 - 1];
            n2 = n3;
            while (n2 >= 2) {
                int n4 = n2;
                fArray[n4] = fArray[n4] + (fArray3[2 * n3] * fArray[n2 - 1] + fArray[n2 - 2]);
                int n5 = n2;
                fArray2[n5] = fArray2[n5] + (fArray3[2 * n3 + 1] * fArray2[n2 - 1] + fArray2[n2 - 2]);
                --n2;
            }
            fArray[1] = fArray[1] + fArray3[2 * n3];
            fArray2[1] = fArray2[1] + fArray3[2 * n3 + 1];
            ++n3;
        }
        n3 = 0;
        while (n3 < 5) {
            fArray3[n3] = -(fArray[n3] + fArray[n3 + 1] - fArray2[n3] + fArray2[n3 + 1]) * 0.5f;
            fArray3[9 - n3] = -(fArray[n3] + fArray[n3 + 1] + fArray2[n3] - fArray2[n3 + 1]) * 0.5f;
            ++n3;
        }
    }

    private final float Rand(int[] nArray) {
        int n2 = nArray[0];
        n2 &= 0xFFFF;
        n2 = n2 * 521 + 259;
        nArray[0] = (short)n2;
        return (float)((short)n2) * 3.0517578E-5f;
    }

    private final void Scale(float[] fArray, int n2, float f2) {
        float f3 = 0.0625f * f2;
        float f4 = this.decoderData.Gain;
        int n3 = 60 + n2;
        int n4 = n2;
        while (n4 < n3) {
            f4 = 0.9375f * f4 + f3;
            int n5 = n4++;
            fArray[n5] = fArray[n5] * (f4 * 1.0625f);
        }
        this.decoderData.Gain = f4;
    }

    private final int Ser2Par(int[] nArray, int[] nArray2, int n2) {
        int n3 = 0;
        int n4 = nArray2[0];
        int n5 = 0;
        while (n5 < n2) {
            n3 += nArray[n4++] << n5;
            ++n5;
        }
        nArray2[0] = n4;
        return n3;
    }

    private final float Spf(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, float[] fArray4, int n5) {
        float f2;
        float[] fArray5 = new float[10];
        float[] fArray6 = new float[10];
        float f3 = 1.0f;
        float f4 = 1.0f;
        int n6 = 0;
        while (n6 < 10) {
            fArray6[n6] = (f3 *= 0.75f) * fArray2[n6 + n3];
            fArray5[n6] = (f4 *= 0.65f) * fArray2[n6 + n3];
            ++n6;
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        f6 = fArray[n2] * fArray[n2];
        int n7 = n2;
        int n8 = n7 + 60;
        n6 = n7 + 1;
        while (n6 < n8) {
            f2 = fArray[n6];
            f5 += f2 * fArray[n6 - 1];
            f6 += f2 * f2;
            ++n6;
        }
        float f7 = (double)f6 != 0.0 ? f5 / f6 : 0.0f;
        float f8 = f6;
        this.decoderData.Park = 0.75f * this.decoderData.Park + 0.25f * f7;
        f2 = fArray6[0];
        float f9 = fArray6[1];
        float f10 = fArray6[2];
        float f11 = fArray6[3];
        float f12 = fArray6[4];
        float f13 = fArray6[5];
        float f14 = fArray6[6];
        float f15 = fArray6[7];
        float f16 = fArray6[8];
        float f17 = fArray6[9];
        float f18 = fArray5[0];
        float f19 = fArray5[1];
        float f20 = fArray5[2];
        float f21 = fArray5[3];
        float f22 = fArray5[4];
        float f23 = fArray5[5];
        float f24 = fArray5[6];
        float f25 = fArray5[7];
        float f26 = fArray5[8];
        float f27 = fArray5[9];
        float f28 = 0.0f;
        int n9 = n2 + 60;
        float f29 = this.decoderData.Park;
        n6 = n2;
        while (n6 < n9) {
            float f30;
            float f31 = fArray[n6] + f2 * fArray4[n5] - f18 * fArray3[n4] + f9 * fArray4[n5 - 1] - f19 * fArray3[n4 - 1] + f10 * fArray4[n5 - 2] - f20 * fArray3[n4 - 2] + f11 * fArray4[n5 - 3] - f21 * fArray3[n4 - 3] + f12 * fArray4[n5 - 4] - f22 * fArray3[n4 - 4] + f13 * fArray4[n5 - 5] - f23 * fArray3[n4 - 5] + f14 * fArray4[n5 - 6] - f24 * fArray3[n4 - 6] + f15 * fArray4[n5 - 7] - f25 * fArray3[n4 - 7] + f16 * fArray4[n5 - 8] - f26 * fArray3[n4 - 8] + f17 * fArray4[n5 - 9] - f27 * fArray3[n4 - 9];
            fArray3[++n4] = fArray[n6];
            fArray4[++n5] = f31;
            fArray[n6] = f30 = f31 - 0.25f * fArray4[n5 - 1] * f29;
            f28 += f30 * f30;
            ++n6;
        }
        if ((double)f28 != 0.0) {
            return (float)Math.sqrt(f8 / f28);
        }
        return 1.0f;
    }

    private final void Synt(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray2[n3];
        float f3 = fArray2[n3 + 1];
        float f4 = fArray2[n3 + 2];
        float f5 = fArray2[n3 + 3];
        float f6 = fArray2[n3 + 4];
        float f7 = fArray2[n3 + 5];
        float f8 = fArray2[n3 + 6];
        float f9 = fArray2[n3 + 7];
        float f10 = fArray2[n3 + 8];
        float f11 = fArray2[n3 + 9];
        int n5 = 60 + n2;
        int n6 = n2;
        while (n6 < n5) {
            float f12;
            fArray[n6] = f12 = fArray[n6] + f2 * fArray3[n4] + f3 * fArray3[n4 - 1] + f4 * fArray3[n4 - 2] + f5 * fArray3[n4 - 3] + f6 * fArray3[n4 - 4] + f7 * fArray3[n4 - 5] + f8 * fArray3[n4 - 6] + f9 * fArray3[n4 - 7] + f10 * fArray3[n4 - 8] + f11 * fArray3[n4 - 9];
            fArray3[++n4] = f12;
            ++n6;
        }
    }

    protected final void decodeFrame(byte[] byArray, int n2, byte[] byArray2, int n3) {
        float[] fArray;
        float[] fArray2 = fArray = this.decode_OutputBuffer;
        float f2 = 0.0f;
        float[] fArray3 = this.decode_QntLpc;
        float[] fArray4 = this.decode_AcbkCont;
        float[] fArray5 = this.decode_LspVect;
        LINEDEF lINEDEF = this.decode_Line;
        PFDEF[] pFDEFArray = this.decode_Pf;
        int[] nArray = this.decode_flag;
        int[] nArray2 = this.decode_Ftyp;
        float[] fArray6 = this.decode_SyntIir;
        float[] fArray7 = this.decode_PostFir;
        float[] fArray8 = this.decode_PostIir;
        if (this.decoderData.BlockIndex == 0) {
            this.decoderData.BlockCount = 0;
            System.arraycopy(this.decoderData.PrevExc, 960, this.decoderData.PrevExc, 0, 145);
        }
        int n4 = this.decoderData.BlockIndex * 240 + 145;
        float[] fArray9 = this.decoderData.PrevExc;
        ++this.decoderData.BlockCount;
        this.decoderData.BlockIndex = this.decoderData.BlockCount % 4;
        int n5 = 0;
        while (n5 < 10) {
            fArray6[10 - n5 - 1] = this.decoderData.SyntIirDl[n5];
            fArray7[10 - n5 - 1] = this.decoderData.PostFirDl[n5];
            fArray8[10 - n5 - 1] = this.decoderData.PostIirDl[n5];
            ++n5;
        }
        this.Line_Unpk(byArray, n2, nArray2, (short)0, nArray, lINEDEF);
        this.decoderData.Ecount = lINEDEF.Crc != 0 ? ++this.decoderData.Ecount : 0;
        if (this.decoderData.Ecount > 3) {
            this.decoderData.Ecount = 3;
        }
        this.Lsp_Inq(fArray5, this.decoderData.PrevLsp, lINEDEF.LspId, lINEDEF.Crc);
        this.Lsp_Int(fArray3, fArray5, this.decoderData.PrevLsp);
        if (this.decoderData.Ecount == 0) {
            n5 = lINEDEF.Sfs[2].Mamp + lINEDEF.Sfs[3].Mamp >> 1;
            this.decoderData.InterGain = FcbkGainTable[n5];
        } else {
            this.decoderData.InterGain *= 0.75f;
        }
        if (this.decoderData.Ecount == 0) {
            n5 = 0;
            while (n5 < 4) {
                this.Fcbk_Unpk(fArray9, n4 + 60 * n5, lINEDEF.Sfs[n5], lINEDEF.Olp[n5 >> 1], n5);
                this.Decod_Acbk(fArray4, fArray9, n4 + 60 * n5 - 145, lINEDEF.Olp[n5 >> 1], lINEDEF.Sfs[n5].AcLg, lINEDEF.Sfs[n5].AcGn, this.decoderData.WrkRate);
                int n6 = 0;
                while (n6 < 60) {
                    int n7 = n4 + n5 * 60 + n6;
                    fArray9[n7] = fArray9[n7] + fArray4[n6];
                    ++n6;
                }
                ++n5;
            }
            System.arraycopy(fArray9, n4, fArray2, 0, 240);
            if (this.decoderData.UsePf) {
                n5 = 0;
                while (n5 < 4) {
                    this.Comp_Lpf(fArray9, n4 - 145, lINEDEF.Olp[n5 >> 1], n5, pFDEFArray[n5]);
                    ++n5;
                }
            }
            if (this.decoderData.UsePf) {
                n5 = 0;
                while (n5 < 4) {
                    this.Filt_Lpf(fArray2, fArray9, n4 - 145, pFDEFArray[n5], n5);
                    ++n5;
                }
            }
        }
        float[] fArray10 = fArray2;
        int n8 = 0;
        n5 = 0;
        while (n5 < 4) {
            this.Synt(fArray10, n8, fArray3, n5 * 10, fArray6, 10 + n5 * 60 - 1);
            if (this.decoderData.UsePf) {
                f2 = this.Spf(fArray10, n8, fArray3, n5 * 10, fArray7, 10 + n5 * 60 - 1, fArray8, 10 + n5 * 60 - 1);
                this.Scale(fArray10, n8, f2);
            }
            n8 += 60;
            ++n5;
        }
        n5 = 0;
        while (n5 < 10) {
            this.decoderData.SyntIirDl[n5] = fArray6[250 - n5 - 1];
            this.decoderData.PostFirDl[n5] = fArray7[250 - n5 - 1];
            this.decoderData.PostIirDl[n5] = fArray8[250 - n5 - 1];
            ++n5;
        }
        this.Fl2Sh(fArray2, 240, byArray2, n3);
    }

    protected final void decoderOpen() {
        this.decoderData = new DecoderData();
        this.decoderReset();
    }

    protected final void decoderReset() {
        int n2 = 0;
        while (n2 < 10) {
            this.decoderData.PrevLsp[n2] = fLspDcTable[n2];
            this.decoderData.PostIirDl[n2] = 0.0f;
            this.decoderData.PostFirDl[n2] = 0.0f;
            this.decoderData.SyntIirDl[n2] = 0.0f;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.decoderData.PrevExc.length) {
            this.decoderData.PrevExc[n2] = 0.0f;
            ++n2;
        }
        this.decoderData.Ecount = 0;
        this.decoderData.InterGain = 0.0f;
        this.decoderData.InterIndx = 0;
        this.decoderData.Park = 0.0f;
        this.decoderData.Rseed = 0;
        this.decoderData.Gain = 1.0f;
        this.decoderData.BlockIndex = 0;
        this.decoderData.BlockCount = 0;
        this.decoderData.WrkRate = 0;
        this.decoderData.UsePf = true;
        n2 = 0;
        while (n2 < 10) {
            this.decoderData.PrevLsp[n2] = fLspDcTable[n2];
            ++n2;
        }
    }
}

