/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.amovie;

import com.sun.media.amovie.AMController;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class ActiveMovie
implements Runnable {
    private int pGraph = 0;
    private int aStream = 0;
    private int filterPin = 0;
    private byte[] jbuffer;
    private boolean paused = false;
    private boolean donePaused = true;
    private Thread spinner = null;
    private Integer semaphore = new Integer(0);
    private boolean realized = false;
    private int streamType = 3;
    private AMController controller;
    private PullSourceStream stream = null;
    private boolean seekable;
    private boolean randomAccess;
    private long readLocation = 0L;
    private long streamLocation = 0L;
    private boolean controllerRealized = false;
    private int cacheBuffer = 0;
    private int cacheTotalSize = 0;
    private int cacheAllocated = 0;
    private boolean deallocated = false;
    public static final int MIN_VOLUME = -10000;
    public static final int MAX_VOLUME = 0;

    ActiveMovie(AMController aMController, String string) {
        this.controller = aMController;
        this.realized = this.openFile(string);
    }

    ActiveMovie(AMController aMController, PullSourceStream pullSourceStream, boolean bl, long l2) {
        this.controller = aMController;
        this.stream = pullSourceStream;
        this.seekable = pullSourceStream instanceof Seekable;
        this.randomAccess = bl;
        this.jbuffer = new byte[65536];
        this.initiateSpin();
        if (this.seekable) {
            this.seek(0L);
        }
        aMController.canRead(65536);
        int n2 = aMController.read(this.jbuffer, 0, 65536);
        if (!bl && n2 > 0) {
            this.addToCache(this.jbuffer, 0, n2);
        }
        if (n2 > 0) {
            if (!bl && l2 > 0L) {
                l2 += 614400L;
            }
            this.streamType = this.getStreamType(this.jbuffer, n2);
            this.streamLocation += (long)n2;
            this.seek(0L);
            this.realized = this.openStream(this.seekable, bl, this.streamType, l2);
        } else {
            this.realized = false;
        }
    }

    private void addToCache(byte[] byArray, int n2, int n3) {
        if (this.cacheBuffer == 0) {
            this.cacheBuffer = this.nCreateCache(393216);
            this.cacheAllocated = 393216;
        }
        if (this.cacheTotalSize + n3 > this.cacheAllocated) {
            return;
        }
        this.nAddToCache(this.cacheBuffer, this.cacheTotalSize, byArray, n2, n3);
        this.cacheTotalSize += n3;
    }

    native void amPause();

    native void amRun();

    native void amStop();

    native void amStopWhenReady();

    public int canRead(int n2) {
        return this.controller.canRead(n2);
    }

    public long canSeek(long l2) {
        return this.controller.canSeek(l2);
    }

    void dispose() {
        if (this.spinner != null) {
            this.spinner.stop();
            this.spinner = null;
        }
        this.dispose0();
        if (this.cacheBuffer != 0) {
            this.nFreeCache(this.cacheBuffer);
            this.cacheBuffer = 0;
        }
    }

    native void dispose0();

    native void doNRequest(byte[] var1);

    void doneRealize() {
        this.controllerRealized = true;
    }

    protected void finalize() {
        this.dispose();
    }

    static native int findWindow(String var0);

    native int getBitRate();

    native double getCurrentPosition();

    native double getDuration();

    native double getFrameRate();

    private void getFromCache(int n2, byte[] byArray, int n3, int n4) {
        this.nGetFromCache(this.cacheBuffer, n2, byArray, n3, n4);
    }

    native double getRate();

    native int getStreamType(byte[] var1, int var2);

    native long getTime();

    native int getVideoHeight();

    native int getVideoWidth();

    native int getVolume();

    boolean hasAudio() {
        return (this.streamType & 1) == 1;
    }

    boolean hasVideo() {
        return (this.streamType & 2) == 2;
    }

    private void initiateSpin() {
        this.spinner = new Thread(this);
        this.spinner.start();
    }

    boolean isRealized() {
        return this.realized;
    }

    public void kill() {
        this.deallocated = true;
        this.unPause();
        this.stopDataFlow(true);
        this.amStop();
    }

    private native void nAddToCache(int var1, int var2, byte[] var3, int var4, int var5);

    private native int nCreateCache(int var1);

    private native void nFreeCache(int var1);

    private native void nGetFromCache(int var1, int var2, byte[] var3, int var4, int var5);

    native boolean openFile(String var1);

    native boolean openStream(boolean var1, boolean var2, int var3, long var4);

    public synchronized void pause() {
        block3: {
            if (this.paused) {
                return;
            }
            this.donePaused = false;
            this.paused = true;
            if (this.donePaused) break block3;
            try {
                this.wait(250L);
                this.donePaused = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        if (this.deallocated) {
            return -1;
        }
        if (this.cacheTotalSize > 0 && !this.randomAccess && this.readLocation < (long)this.cacheTotalSize && this.streamLocation == (long)this.cacheTotalSize) {
            n4 = (int)((long)this.cacheTotalSize - this.readLocation);
            if (n4 > n3) {
                n4 = n3;
            }
            this.getFromCache((int)this.readLocation, byArray, n2, n4);
            this.readLocation += (long)n4;
            if (n4 == n3) {
                return n4;
            }
            n3 -= n4;
            n2 += n4;
        }
        int n5 = 0;
        int n6 = n3;
        while (n4 < n3) {
            n5 = this.canRead(n6) > 0 ? this.controller.read(byArray, n2, n6) : -1;
            if (n5 == -1) {
                if (n4 > 0) {
                    return n4;
                }
                return -1;
            }
            if (n5 == -2) {
                return -2;
            }
            if (n5 <= 0) continue;
            n6 -= n5;
            n4 += n5;
            if (!this.controllerRealized && !this.randomAccess && this.streamLocation == (long)this.cacheTotalSize) {
                this.addToCache(byArray, n2, n5);
            }
            n2 += n5;
            this.streamLocation += (long)n5;
            this.readLocation = this.streamLocation;
            if (this.streamLocation <= (long)this.cacheTotalSize || !this.controllerRealized) continue;
            this.cacheTotalSize = 0;
        }
        if (n5 > 0) {
            return n4;
        }
        return n5;
    }

    public void restart() {
        this.deallocated = false;
        this.stopDataFlow(false);
        this.unPause();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            ActiveMovie activeMovie = this;
            synchronized (activeMovie) {
                while (this.paused) {
                    if (!this.donePaused) {
                        this.donePaused = true;
                        this.notifyAll();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.doNRequest(this.jbuffer);
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Exception in run()" + exception);
                continue;
            }
            break;
        }
    }

    public long seek(long l2) {
        if (this.deallocated) {
            return 0L;
        }
        if (l2 < (long)this.cacheTotalSize && !this.randomAccess) {
            this.readLocation = l2;
            return l2;
        }
        if (this.seekable && (this.randomAccess || l2 == 0L)) {
            long l3 = this.controller.seek(l2);
            this.streamLocation = l2;
            return l3;
        }
        return -1L;
    }

    native void setCurrentPosition(double var1);

    native void setNSeekable(boolean var1);

    native void setOwner(int var1);

    native void setRate(double var1);

    public void setSeekable(boolean bl) {
        if (bl) {
            this.randomAccess = bl;
            this.seekable = bl;
        }
        this.setNSeekable(bl);
    }

    native void setStopTime(double var1);

    native void setVisible(int var1);

    native void setVolume(int var1);

    native void setWindowPosition(int var1, int var2, int var3, int var4);

    native void stopDataFlow(int var1, boolean var2);

    void stopDataFlow(boolean bl) {
        if (this.filterPin != 0) {
            this.stopDataFlow(this.filterPin, bl);
        }
    }

    private void unPause() {
        if (!this.paused) {
            return;
        }
        ActiveMovie activeMovie = this;
        synchronized (activeMovie) {
            this.donePaused = true;
            this.paused = false;
            this.notifyAll();
        }
    }

    native boolean waitForCompletion();
}

