/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.CircularBuffer;
import com.sun.media.protocol.dsound.DirectSoundStream;
import com.sun.media.util.LoopThread;
import javax.media.Buffer;
import javax.media.SystemTimeBase;
import javax.media.protocol.BufferTransferHandler;

class PushThread
extends LoopThread {
    private DirectSoundStream sourceStream;
    private SystemTimeBase systemTimeBase = new SystemTimeBase();
    private long seqNo = 0L;

    public PushThread() {
        this.setName("DirectSound PushThread");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process() {
        Buffer buffer;
        CircularBuffer circularBuffer = this.sourceStream.cb;
        BufferTransferHandler bufferTransferHandler = this.sourceStream.transferHandler;
        CircularBuffer circularBuffer2 = circularBuffer;
        synchronized (circularBuffer2) {
            while (true) {
                if (circularBuffer.canWrite()) {
                    buffer = circularBuffer.getEmptyBuffer();
                    break;
                }
                try {
                    circularBuffer.wait();
                }
                catch (Exception exception) {}
            }
        }
        byte[] byArray = buffer.getData() instanceof byte[] ? (byte[])buffer.getData() : null;
        if (byArray == null || byArray.length < this.sourceStream.bufSize) {
            byArray = new byte[this.sourceStream.bufSize];
            buffer.setData(byArray);
        }
        int n2 = this.sourceStream.dSound.read(byArray, 0, this.sourceStream.bufSize);
        buffer.setOffset(0);
        buffer.setLength(n2);
        buffer.setFormat(this.sourceStream.format);
        buffer.setFlags(32896);
        buffer.setSequenceNumber(this.seqNo++);
        if (n2 < 1) {
            buffer.setFlags(2);
        }
        buffer.setTimeStamp(this.systemTimeBase.getNanoseconds());
        circularBuffer2 = circularBuffer;
        synchronized (circularBuffer2) {
            circularBuffer.writeReport();
            circularBuffer.notify();
            if (bufferTransferHandler == null) return true;
            if (n2 <= 0) return true;
            bufferTransferHandler.transferData(this.sourceStream);
            return true;
        }
    }

    void setSourceStream(DirectSoundStream directSoundStream) {
        this.sourceStream = directSoundStream;
    }
}

