/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.WindowUtil;
import java.awt.Color;
import java.io.Serializable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class DDRenderer
extends BasicVideoRenderer
implements DynamicPlugIn {
    private static boolean available = false;
    private static Integer processLock = new Integer(1);
    private int blitter = 0;
    private static boolean yuyvInUse;
    private boolean yuyvInUseByMe = false;
    protected Object data = null;
    private int defbitsPerPixel;
    private int defrMask;
    private int defgMask;
    private int defbMask;
    private int offX = 0;
    private int offY = 0;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private boolean upsideDown;
    private int offsetY;
    private int offsetU;
    private int offsetV;
    protected VideoFormat defaultFormat;
    private int fccSupported = 0;
    private final int YUYV = 32;
    private final int P420 = 2;
    private final int P422 = 4;

    static {
        try {
            JMFSecurityManager.loadLibrary("jmddraw");
            available = true;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        yuyvInUse = true;
    }

    public DDRenderer() {
        super("DirectDraw Renderer");
        if (available) {
            if (this.dxInitialize()) {
                int n2 = 1;
                Class clazz = this.defbitsPerPixel <= 8 ? Format.byteArray : (this.defbitsPerPixel <= 16 ? Format.shortArray : (this.defbitsPerPixel <= 24 ? Format.byteArray : Format.intArray));
                if (this.defbitsPerPixel == 24) {
                    this.defrMask = 3;
                    this.defgMask = 2;
                    this.defbMask = 1;
                }
                if (yuyvInUse) {
                    this.fccSupported = 0;
                }
                if ((this.fccSupported & 0x20) != 0) {
                    n2 += 2;
                }
                this.defaultFormat = new RGBFormat(null, -1, clazz, -1.0f, this.defbitsPerPixel, this.defrMask, this.defgMask, this.defbMask, this.defbitsPerPixel == 24 ? 3 : 1, -1, -1, -1);
                this.supportedFormats = new VideoFormat[n2];
                this.supportedFormats[0] = this.defaultFormat;
                if ((this.fccSupported & 0x20) != 0) {
                    this.supportedFormats[1] = new YUVFormat(4);
                    this.supportedFormats[2] = new YUVFormat(2);
                }
            } else {
                available = false;
            }
        }
    }

    public synchronized void close() {
        if (available) {
            this.dxFree();
            if (this.yuyvInUseByMe) {
                this.yuyvInUseByMe = false;
                yuyvInUse = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized int doProcess(Buffer buffer) {
        if (!available) return 0;
        if (this.component == null) {
            return 0;
        }
        DDRenderer dDRenderer = this;
        synchronized (dDRenderer) {
            if (!this.componentAvailable) {
                return 0;
            }
            if (this.blitter == 0) {
                int n2 = WindowUtil.getWindowHandle(this.component);
                if (n2 != 0) {
                    this.dxSetComponent(n2);
                    this.inputFormat = new VideoFormat(null);
                }
                if (this.blitter == 0) {
                    System.err.println("Could not create blitter");
                    return 1;
                }
            }
            if (!buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
                return 1;
            }
            Integer n3 = processLock;
            synchronized (n3) {
                long l2 = 0L;
                this.data = this.getInputData(buffer);
                if (this.data instanceof NBA) {
                    l2 = ((NBA)this.data).data;
                }
                if (this.data == null) {
                    return 0;
                }
                if (this.outWidth <= 0) return 1;
                if (this.outHeight <= 0) return 1;
                if (!this.dxDraw(this.data, l2, this.outWidth, this.outHeight)) return 1;
                return 0;
            }
        }
    }

    private synchronized native boolean dxDraw(Object var1, long var2, int var4, int var5);

    private synchronized native boolean dxFree();

    private synchronized native boolean dxInitialize();

    private synchronized native boolean dxSetComponent(int var1);

    private synchronized native boolean dxSetFourCCInputFormat(int var1, int var2, int var3);

    private synchronized native boolean dxSetInputFormat(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    private synchronized native boolean dxSetOutputSize(int var1, int var2);

    public Format[] getBaseInputFormats() {
        Format[] formatArray = new Format[]{new RGBFormat(), new YUVFormat()};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formatArray = new Format[]{};
        return formatArray;
    }

    protected Color getPreferredBackground() {
        return new Color(255, 0, 255);
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("DirectDraw not available");
        }
        if (this.inputFormat instanceof YUVFormat) {
            yuyvInUse = true;
            this.yuyvInUseByMe = true;
        }
    }

    protected synchronized void removingComponent() {
        if (this.blitter != 0) {
            this.dxFree();
        }
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null && this.blitter != 0 && this.outWidth > 0 && this.outHeight > 0) {
            long l2 = 0L;
            if (this.data instanceof NBA) {
                l2 = ((NBA)this.data).data;
            }
            this.dxDraw(this.data, l2, this.outWidth, this.outHeight);
        }
    }

    public void reset() {
    }

    public synchronized Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            Serializable serializable;
            if (this.inputFormat instanceof RGBFormat) {
                serializable = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = ((RGBFormat)serializable).getBitsPerPixel();
                this.rMask = ((RGBFormat)serializable).getRedMask();
                this.gMask = ((RGBFormat)serializable).getGreenMask();
                this.bMask = ((RGBFormat)serializable).getBlueMask();
                this.lineStride = ((RGBFormat)serializable).getLineStride();
                if (this.bitsPerPixel == 24) {
                    this.lineStride /= 3;
                }
                this.pixelStride = ((RGBFormat)serializable).getPixelStride();
                this.upsideDown = ((RGBFormat)serializable).getFlipped() == 1;
                if (!this.dxSetInputFormat(this.inWidth, this.inHeight, this.lineStride, this.bitsPerPixel, this.rMask, this.gMask, this.bMask, this.upsideDown)) {
                    return null;
                }
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else if (this.inputFormat instanceof YUVFormat) {
                if ((this.fccSupported & 0x20) == 0) {
                    return null;
                }
                serializable = (YUVFormat)this.inputFormat;
                int n2 = ((YUVFormat)serializable).getYuvType();
                if (n2 != 2 && n2 != 4) {
                    return null;
                }
                this.lineStride = ((YUVFormat)serializable).getStrideY();
                this.pixelStride = 1;
                this.offsetY = ((YUVFormat)serializable).getOffsetY();
                this.offsetU = ((YUVFormat)serializable).getOffsetU();
                this.offsetV = ((YUVFormat)serializable).getOffsetV();
                if (!this.dxSetFourCCInputFormat(this.inWidth, this.inHeight, n2)) {
                    return null;
                }
            } else {
                return null;
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if ((serializable = this.inputFormat.getDataType()) == Format.intArray) {
                this.bytesPerPixel = 4;
            } else if (serializable == Format.shortArray) {
                this.bytesPerPixel = 2;
            } else if (serializable == Format.byteArray) {
                this.bytesPerPixel = 1;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            return format;
        }
        return null;
    }
}

