/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicController;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.JMD;
import com.sun.media.Module;
import com.sun.media.ModuleListener;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.StateTransistor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;

public abstract class BasicModule
implements Module,
StateTransistor {
    protected Registry inputConnectors = new Registry();
    protected Registry outputConnectors = new Registry();
    protected InputConnector[] inputConnectorsArray;
    protected OutputConnector[] outputConnectorsArray;
    protected int protocol = 0;
    protected String name = null;
    protected ModuleListener moduleListener;
    protected BasicController controller;
    protected boolean resetted = false;
    protected boolean prefetchFailed = false;
    protected JMD jmd = null;

    public boolean doRealize() {
        return true;
    }

    public void doFailedRealize() {
    }

    public void abortRealize() {
    }

    public void connectorPushed(InputConnector inputConnector) {
        this.process();
    }

    public boolean doPrefetch() {
        this.resetted = false;
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
    }

    public void doStart() {
        this.resetted = false;
    }

    public void doStop() {
    }

    public void doDealloc() {
    }

    public void doClose() {
    }

    public void doSetMediaTime(Time time) {
    }

    public float doSetRate(float f2) {
        return f2;
    }

    public Object[] getControls() {
        return null;
    }

    public Object getControl(String string) {
        return null;
    }

    public void setModuleListener(ModuleListener moduleListener) {
        this.moduleListener = moduleListener;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public String[] getInputConnectorNames() {
        return this.inputConnectors.getNames();
    }

    public String[] getOutputConnectorNames() {
        return this.outputConnectors.getNames();
    }

    public InputConnector getInputConnector(String string) {
        return (InputConnector)this.inputConnectors.get(string);
    }

    public OutputConnector getOutputConnector(String string) {
        return (OutputConnector)this.outputConnectors.get(string);
    }

    public void registerInputConnector(String string, InputConnector inputConnector) {
        this.inputConnectors.put(string, inputConnector);
        inputConnector.setModule(this);
    }

    public void registerOutputConnector(String string, OutputConnector outputConnector) {
        this.outputConnectors.put(string, outputConnector);
        outputConnector.setModule(this);
    }

    public void reset() {
        this.resetted = true;
    }

    protected boolean verifyBuffer(Buffer buffer) {
        if (buffer.isDiscard()) {
            return true;
        }
        Object object = buffer.getData();
        if (buffer.getLength() < 0) {
            System.err.println("warning: data length shouldn't be negative: " + buffer.getLength());
        }
        if (object == null) {
            System.err.println("warning: data buffer is null");
            if (buffer.getLength() != 0) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but data buffer is null!");
                return false;
            }
        } else if (object instanceof byte[]) {
            if (buffer.getLength() > ((byte[])object).length) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((byte[])object).length);
                return false;
            }
        } else if (object instanceof int[] && buffer.getLength() > ((int[])object).length) {
            System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((int[])object).length);
            return false;
        }
        return true;
    }

    public final boolean isInterrupted() {
        return this.controller == null ? false : this.controller.isInterrupted();
    }

    public boolean isThreaded() {
        return true;
    }

    public boolean canRun() {
        int n2 = 0;
        while (n2 < this.inputConnectorsArray.length) {
            if (!this.inputConnectorsArray[n2].isValidBufferAvailable()) {
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.outputConnectorsArray.length) {
            if (!this.outputConnectorsArray[n3].isEmptyBufferAvailable()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected abstract void process();

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " error");
    }

    public final BasicController getController() {
        return this.controller;
    }

    public final void setController(BasicController basicController) {
        this.controller = basicController;
    }

    public final int getState() {
        return this.controller.getState();
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setJMD(JMD jMD) {
        this.jmd = jMD;
    }

    public Time getMediaTime() {
        return this.controller.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.controller.getMediaNanoseconds();
    }

    public long getLatency() {
        return ((PlaybackEngine)this.controller).getLatency();
    }

    public void setProtocol(int n2) {
        this.protocol = n2;
        Connector[] connectorArray = this.inputConnectors.getConnectors();
        int n3 = 0;
        while (n3 < connectorArray.length) {
            connectorArray[n3].setProtocol(n2);
            ++n3;
        }
        connectorArray = this.outputConnectors.getConnectors();
        int n4 = 0;
        while (n4 < connectorArray.length) {
            connectorArray[n4].setProtocol(n2);
            ++n4;
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public boolean prefetchFailed() {
        return this.prefetchFailed;
    }

    class Registry
    extends Hashtable {
        Connector def = null;

        Registry() {
        }

        String[] getNames() {
            Enumeration enumeration = this.keys();
            String[] stringArray = new String[this.size()];
            int n2 = 0;
            while (n2 < this.size()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
            return stringArray;
        }

        void put(String string, Connector connector) {
            if (this.containsKey(string)) {
                throw new RuntimeException("Connector '" + string + "' already exists in Module '" + BasicModule.this.getClass().getName() + "::" + string + "'");
            }
            if (this.def == null) {
                this.def = connector;
            }
            super.put(string, connector);
        }

        Object get(String string) {
            if (string == null) {
                return this.def;
            }
            return super.get(string);
        }

        Connector[] getConnectors() {
            Enumeration enumeration = this.elements();
            Connector[] connectorArray = new Connector[this.size()];
            int n2 = 0;
            while (n2 < this.size()) {
                connectorArray[n2] = (Connector)enumeration.nextElement();
                ++n2;
            }
            return connectorArray;
        }
    }
}

