/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicPlayer;
import com.sun.media.PlaybackEngine;
import com.sun.media.controls.ProgressControl;
import java.awt.Component;
import java.io.IOException;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.NotRealizedError;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;

public class MediaPlayer
extends BasicPlayer {
    protected PlaybackEngine engine = new PlaybackEngine(this);

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        this.engine.setSource(dataSource);
        this.manageController(this.engine);
        super.setSource(dataSource);
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.engine.getVisualComponent();
    }

    public GainControl getGainControl() {
        int n2 = this.getState();
        if (n2 < 300) {
            this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        }
        return this.engine.getGainControl();
    }

    public Time getMediaTime() {
        if (this.controllerList.size() > 1) {
            return super.getMediaTime();
        }
        return this.engine.getMediaTime();
    }

    public long getMediaNanoseconds() {
        if (this.controllerList.size() > 1) {
            return super.getMediaNanoseconds();
        }
        return this.engine.getMediaNanoseconds();
    }

    protected TimeBase getMasterTimeBase() {
        return this.engine.getTimeBase();
    }

    protected boolean audioEnabled() {
        return this.engine.audioEnabled();
    }

    protected boolean videoEnabled() {
        return this.engine.videoEnabled();
    }

    public void updateStats() {
        this.engine.updateRates();
    }

    public void setProgressControl(ProgressControl progressControl) {
        this.engine.setProgressControl(progressControl);
    }
}

