/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.sun.media.BasicClock;
import com.sun.media.BasicPlugIn;
import com.sun.media.MediaTimeBase;
import com.sun.media.Syncable;
import com.sun.media.controls.MonitorAdapter;
import com.sun.media.datasink.RandomAccess;
import java.awt.Component;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.Owned;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.StreamWriterControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceTransferHandler;

public abstract class BasicMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected Format[] supportedInputs;
    protected ContentDescriptor[] supportedOutputs;
    protected int numTracks = 0;
    protected Format[] inputs;
    protected BasicMuxDataSource source;
    protected BasicMuxPushStream stream;
    protected ContentDescriptor outputCD;
    protected boolean flushing = false;
    protected Integer sourceLock = new Integer(0);
    protected boolean eos = false;
    protected boolean firstBuffer = true;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected long fileSizeLimit = -1L;
    protected boolean streamSizeLimitSupported = true;
    protected boolean fileSizeLimitReached = false;
    protected SourceTransferHandler sth = null;
    protected boolean isLiveData = false;
    protected StreamWriterControl swc = null;
    protected MonitorAdapter[] mc = null;
    protected BasicMuxTimeBase timeBase = null;
    Object startup = new Integer(0);
    boolean readyToStart = false;
    long[] mediaTime;
    boolean[] ready;
    protected BasicClock clock = null;
    int master = 0;
    boolean mClosed = false;
    boolean dataReady = false;
    boolean startCompensated = false;
    Object dataLock = new Object();
    Buffer[] firstBuffers;
    boolean[] firstBuffersDone;
    int[] nonKeyCount;
    long masterTime = -1L;
    VideoFormat jpegFmt = new VideoFormat("jpeg");
    VideoFormat mjpgFmt = new VideoFormat("mjpg");
    VideoFormat rgbFmt = new VideoFormat("rgb");
    VideoFormat yuvFmt = new VideoFormat("yuv");
    protected int maxBufSize = 32768;
    protected byte[] buf = new byte[this.maxBufSize];
    protected int bufOffset;
    protected int bufLength;
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = System.currentTimeMillis() * 1000000L;

    public BasicMux() {
        this.timeBase = new BasicMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.swc = new SWC(this);
        this.controls = new Control[]{this.swc};
    }

    public void open() {
        this.firstBuffer = true;
        this.firstBuffers = new Buffer[this.inputs.length];
        this.firstBuffersDone = new boolean[this.inputs.length];
        this.nonKeyCount = new int[this.inputs.length];
        this.mediaTime = new long[this.inputs.length];
        int n2 = 0;
        while (n2 < this.inputs.length) {
            this.firstBuffers[n2] = null;
            this.firstBuffersDone[n2] = false;
            this.nonKeyCount[n2] = 0;
            this.mediaTime[n2] = 0L;
            ++n2;
        }
        this.ready = new boolean[this.inputs.length];
        this.resetReady();
        int n3 = 0;
        this.mc = new MonitorAdapter[this.inputs.length];
        n2 = 0;
        while (n2 < this.inputs.length) {
            if (this.inputs[n2] instanceof VideoFormat || this.inputs[n2] instanceof AudioFormat) {
                this.mc[n2] = new MonitorAdapter(this.inputs[n2], this);
                if (this.mc[n2] != null) {
                    ++n3;
                }
            }
            ++n2;
        }
        int n4 = 0;
        this.controls = new Control[n3 + 1];
        n2 = 0;
        while (n2 < this.mc.length) {
            if (this.mc[n2] != null) {
                this.controls[n4++] = this.mc[n2];
            }
            ++n2;
        }
        this.controls[n4] = this.swc;
    }

    public void close() {
        if (this.sth != null) {
            this.writeFooter();
            this.write(null, 0, -1);
        }
        int n2 = 0;
        while (n2 < this.mc.length) {
            if (this.mc[n2] != null) {
                this.mc[n2].close();
            }
            ++n2;
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.mClosed = true;
            this.dataLock.notifyAll();
        }
    }

    public void reset() {
        int n2 = 0;
        while (n2 < this.mediaTime.length) {
            this.mediaTime[n2] = 0L;
            if (this.mc[n2] != null) {
                this.mc[n2].reset();
            }
            ++n2;
        }
        this.timeBase.update();
        this.resetReady();
        Integer n3 = this.sourceLock;
        synchronized (n3) {
            this.flushing = true;
            this.sourceLock.notifyAll();
        }
    }

    private void resetReady() {
        int n2 = 0;
        while (n2 < this.ready.length) {
            this.ready[n2] = false;
            ++n2;
        }
        this.readyToStart = false;
        Object object = this.startup;
        synchronized (object) {
            this.startup.notifyAll();
        }
    }

    private boolean checkReady() {
        if (this.readyToStart) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.ready.length) {
            if (!this.ready[n2]) {
                return false;
            }
            ++n2;
        }
        this.readyToStart = true;
        return true;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputs;
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return this.supportedOutputs;
    }

    public int setNumTracks(int n2) {
        this.numTracks = n2;
        if (this.inputs == null) {
            this.inputs = new Format[n2];
        } else {
            Format[] formatArray = new Format[n2];
            int n3 = 0;
            while (n3 < this.inputs.length) {
                formatArray[n3] = this.inputs[n3];
                ++n3;
            }
            this.inputs = formatArray;
        }
        return n2;
    }

    public Format setInputFormat(Format format, int n2) {
        this.inputs[n2] = format;
        return format;
    }

    public int process(Buffer buffer, int n2) {
        Object object;
        if (buffer.isDiscard()) {
            return 0;
        }
        if (!this.isLiveData && (buffer.getFlags() & 0x8000) > 0) {
            this.isLiveData = true;
        }
        while (this.source == null || !this.source.isConnected() || !this.source.isStarted()) {
            object = this.sourceLock;
            synchronized (object) {
                try {
                    this.sourceLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.flushing) {
                    this.flushing = false;
                    buffer.setLength(0);
                    int n3 = 0;
                    return n3;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.firstBuffer) {
                this.writeHeader();
                this.firstBuffer = false;
            }
        }
        if (this.numTracks > 1) {
            if ((buffer.getFlags() & 0x1000) != 0 && buffer.getTimeStamp() <= 0L) {
                return 0;
            }
            if (!this.startCompensated && !this.compensateStart(buffer, n2)) {
                return 0;
            }
        }
        this.updateClock(buffer, n2);
        if (this.mc[n2] != null && this.mc[n2].isEnabled()) {
            this.mc[n2].process(buffer);
        }
        int n4 = this.doProcess(buffer, n2);
        if (this.fileSizeLimitReached) {
            n4 |= 8;
        }
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compensateStart(Buffer buffer, int n2) {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.dataReady) {
                if (this.firstBuffersDone[n2]) return true;
                if (buffer.getTimeStamp() < this.masterTime) {
                    return false;
                }
                if (buffer.getFormat() instanceof VideoFormat) {
                    boolean bl;
                    Format format = buffer.getFormat();
                    boolean bl2 = bl = this.jpegFmt.matches(format) || this.mjpgFmt.matches(format) || this.rgbFmt.matches(format) || this.yuvFmt.matches(format);
                    if (!bl && (buffer.getFlags() & 0x10) == 0) {
                        int n3 = n2;
                        int n4 = this.nonKeyCount[n3];
                        this.nonKeyCount[n3] = n4 + 1;
                        if (n4 <= 30) return false;
                    }
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n2] = true;
                } else {
                    buffer.setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n2] = true;
                }
                int n5 = 0;
                while (n5 < this.firstBuffersDone.length) {
                    if (!this.firstBuffersDone[n5]) {
                        return true;
                    }
                    ++n5;
                }
                this.startCompensated = true;
                return true;
            }
            if (buffer.getTimeStamp() < 0L) {
                this.startCompensated = true;
                this.dataReady = true;
                this.dataLock.notifyAll();
                return true;
            }
            this.firstBuffers[n2] = buffer;
            boolean bl = true;
            int n6 = 0;
            while (n6 < this.firstBuffers.length) {
                if (this.firstBuffers[n6] == null) {
                    bl = false;
                }
                ++n6;
            }
            if (!bl) {
                while (!this.dataReady && !this.mClosed) {
                    try {
                        this.dataLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.mClosed) return false;
                if (this.firstBuffers[n2] != null) return true;
                return false;
            }
            this.masterTime = this.firstBuffers[0].getTimeStamp();
            int n7 = 0;
            while (n7 < this.firstBuffers.length) {
                if (this.firstBuffers[n7].getFormat() instanceof AudioFormat) {
                    this.masterTime = this.firstBuffers[n7].getTimeStamp();
                    break;
                }
                if (this.firstBuffers[n7].getTimeStamp() < this.masterTime) {
                    this.masterTime = this.firstBuffers[n7].getTimeStamp();
                }
                ++n7;
            }
            this.startCompensated = true;
            int n8 = 0;
            while (n8 < this.firstBuffers.length) {
                if (this.firstBuffers[n8].getTimeStamp() >= this.masterTime) {
                    this.firstBuffers[n8].setTimeStamp(this.masterTime);
                    this.firstBuffersDone[n8] = true;
                } else {
                    this.firstBuffers[n8] = null;
                    this.startCompensated = false;
                }
                ++n8;
            }
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.dataReady = true;
                this.dataLock.notifyAll();
            }
            if (this.firstBuffers[n2] == null) return false;
            return true;
        }
    }

    private void updateClock(Buffer buffer, int n2) {
        long l2;
        if (!this.readyToStart && this.numTracks > 1) {
            Object object = this.startup;
            synchronized (object) {
                this.ready[n2] = true;
                if (this.checkReady()) {
                    this.startup.notifyAll();
                } else {
                    try {
                        while (!this.readyToStart) {
                            this.startup.wait(1000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if ((l2 = buffer.getTimeStamp()) <= 0L && buffer.getFormat() instanceof AudioFormat) {
            l2 = this.mediaTime[n2];
            int n3 = n2;
            this.mediaTime[n3] = this.mediaTime[n3] + this.getDuration(buffer);
        } else {
            this.mediaTime[n2] = l2 <= 0L ? System.currentTimeMillis() * 1000000L - this.systemStartTime : l2;
        }
        this.timeBase.update();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) {
        if (BasicPlugIn.matches(contentDescriptor, this.supportedOutputs) == null) {
            return null;
        }
        this.outputCD = contentDescriptor;
        return contentDescriptor;
    }

    public DataSource getDataOutput() {
        if (this.source == null) {
            this.source = new BasicMuxDataSource(this, this.outputCD);
            Integer n2 = this.sourceLock;
            synchronized (n2) {
                this.sourceLock.notifyAll();
            }
        }
        return this.source;
    }

    protected int doProcess(Buffer buffer, int n2) {
        byte[] byArray = (byte[])buffer.getData();
        int n3 = buffer.getLength();
        if (!buffer.isEOM()) {
            this.write(byArray, buffer.getOffset(), n3);
        }
        return 0;
    }

    protected int write(byte[] byArray, int n2, int n3) {
        if (this.source == null || !this.source.isConnected()) {
            return n3;
        }
        if (n3 > 0) {
            this.filePointer += n3;
            if (this.filePointer > this.fileSize) {
                this.fileSize = this.filePointer;
            }
            if (this.fileSizeLimit > 0L && (long)this.fileSize >= this.fileSizeLimit) {
                this.fileSizeLimitReached = true;
            }
        }
        return this.stream.write(byArray, n2, n3);
    }

    void setStream(BasicMuxPushStream basicMuxPushStream) {
        this.stream = basicMuxPushStream;
    }

    long getStreamSize() {
        return this.fileSize;
    }

    boolean needsSeekable() {
        return false;
    }

    protected int seek(int n2) {
        if (this.source == null || !this.source.isConnected()) {
            return n2;
        }
        this.filePointer = this.stream.seek(n2);
        return this.filePointer;
    }

    boolean isEOS() {
        return this.eos;
    }

    protected void writeHeader() {
    }

    protected void writeFooter() {
    }

    protected void bufClear() {
        this.bufOffset = 0;
        this.bufLength = 0;
    }

    protected void bufSkip(int n2) {
        this.bufOffset += n2;
        this.bufLength += n2;
        this.filePointer += n2;
    }

    protected void bufWriteBytes(String string) {
        byte[] byArray = string.getBytes();
        this.bufWriteBytes(byArray);
    }

    protected void bufWriteBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this.buf, this.bufOffset, byArray.length);
        this.bufOffset += byArray.length;
        this.bufLength += byArray.length;
        this.filePointer += byArray.length;
    }

    protected void bufWriteInt(int n2) {
        this.buf[this.bufOffset + 0] = (byte)(n2 >> 24 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(n2 >> 16 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(n2 >> 8 & 0xFF);
        this.buf[this.bufOffset + 3] = (byte)(n2 >> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteIntLittleEndian(int n2) {
        this.buf[this.bufOffset + 3] = (byte)(n2 >>> 24 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(n2 >>> 16 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(n2 >>> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(n2 >>> 0 & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteShort(short s) {
        this.buf[this.bufOffset + 0] = (byte)(s >> 8 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(s >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteShortLittleEndian(short s) {
        this.buf[this.bufOffset + 1] = (byte)(s >> 8 & 0xFF);
        this.buf[this.bufOffset + 0] = (byte)(s >> 0 & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteByte(byte by) {
        this.buf[this.bufOffset] = by;
        ++this.bufOffset;
        ++this.bufLength;
        ++this.filePointer;
    }

    protected void bufFlush() {
        this.filePointer -= this.bufLength;
        this.write(this.buf, 0, this.bufLength);
    }

    private long getDuration(Buffer buffer) {
        AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
        long l2 = audioFormat.computeDuration(buffer.getLength());
        if (l2 < 0L) {
            return 0L;
        }
        return l2;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (timeBase != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    public void syncStart(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(time);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis() * 1000000L;
        }
    }

    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    public void setStopTime(Time time) {
        this.clock.setStopTime(time);
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(time);
            int n2 = 0;
            while (n2 < this.mediaTime.length) {
                this.mediaTime[n2] = time.getNanoseconds();
                ++n2;
            }
            this.timeBase.update();
        }
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public float setRate(float f2) {
        if (f2 == this.clock.getRate()) {
            return f2;
        }
        return this.clock.setRate(1.0f);
    }

    public boolean requireTwoPass() {
        return false;
    }

    class BasicMuxPushStream
    implements PushSourceStream {
        private ContentDescriptor cd;
        private byte[] data;
        private int dataLen;
        private int dataOff;
        private Integer writeLock = new Integer(0);

        public BasicMuxPushStream(ContentDescriptor contentDescriptor) {
            this.cd = contentDescriptor;
        }

        public ContentDescriptor getContentDescriptor() {
            return this.cd;
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean endOfStream() {
            return BasicMux.this.isEOS();
        }

        synchronized int write(byte[] byArray, int n2, int n3) {
            if (BasicMux.this.sth == null) {
                return 0;
            }
            if (BasicMux.this.isLiveData && BasicMux.this.sth instanceof Syncable) {
                ((Syncable)((Object)BasicMux.this.sth)).setSyncEnabled();
            }
            Integer n4 = this.writeLock;
            synchronized (n4) {
                this.data = byArray;
                this.dataOff = n2;
                this.dataLen = n3;
                BasicMux.this.sth.transferData(this);
                while (this.dataLen > 0) {
                    if (this.dataLen == n3) {
                        try {
                            this.writeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (BasicMux.this.sth == null) break;
                    if (this.dataLen <= 0 || this.dataLen == n3) continue;
                    n3 = this.dataLen;
                    BasicMux.this.sth.transferData(this);
                }
            }
            return n3;
        }

        synchronized int seek(int n2) {
            if (BasicMux.this.sth != null) {
                ((Seekable)((Object)BasicMux.this.sth)).seek(n2);
                int n3 = (int)((Seekable)((Object)BasicMux.this.sth)).tell();
                return n3;
            }
            return -1;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = 0;
            Integer n5 = this.writeLock;
            synchronized (n5) {
                if (this.dataLen == -1) {
                    n4 = -1;
                } else {
                    n4 = n3 >= this.dataLen ? this.dataLen : n3;
                    System.arraycopy(this.data, this.dataOff, byArray, n2, n4);
                    this.dataLen -= n4;
                    this.dataOff += n4;
                }
                this.writeLock.notifyAll();
                int n6 = n4;
                return n6;
            }
        }

        public int getMinimumTransferSize() {
            return this.dataLen;
        }

        public void setTransferHandler(SourceTransferHandler sourceTransferHandler) {
            Integer n2 = this.writeLock;
            synchronized (n2) {
                BasicMux.this.sth = sourceTransferHandler;
                if (sourceTransferHandler != null && BasicMux.this.needsSeekable() && !(sourceTransferHandler instanceof Seekable)) {
                    throw new Error("SourceTransferHandler needs to be seekable");
                }
                boolean bl = BasicMux.this.requireTwoPass();
                if (bl && sourceTransferHandler != null && sourceTransferHandler instanceof RandomAccess) {
                    RandomAccess randomAccess = (RandomAccess)((Object)sourceTransferHandler);
                    randomAccess.setEnabled(true);
                }
                this.writeLock.notifyAll();
            }
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }

    class BasicMuxDataSource
    extends PushDataSource {
        private BasicMux mux;
        private ContentDescriptor cd;
        private BasicMuxPushStream[] streams;
        private BasicMuxPushStream stream;
        private boolean connected = false;
        private boolean started = false;

        public BasicMuxDataSource(BasicMux basicMux2, ContentDescriptor contentDescriptor) {
            this.cd = contentDescriptor;
            this.mux = basicMux2;
        }

        public PushSourceStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new BasicMuxPushStream[1];
                this.streams[0] = this.stream = new BasicMuxPushStream(this.cd);
                BasicMux.this.setStream(this.stream);
            }
            return this.streams;
        }

        public String getContentType() {
            return this.cd.getContentType();
        }

        public void connect() throws IOException {
            if (this.streams == null) {
                this.getStreams();
            }
            this.connected = true;
            Integer n2 = BasicMux.this.sourceLock;
            synchronized (n2) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        boolean isConnected() {
            return this.connected;
        }

        boolean isStarted() {
            return this.started;
        }

        public void disconnect() {
            this.connected = false;
        }

        public void start() throws IOException {
            if (this.streams == null || !this.connected) {
                throw new IOException("Source not connected yet!");
            }
            this.started = true;
            Integer n2 = BasicMux.this.sourceLock;
            synchronized (n2) {
                BasicMux.this.sourceLock.notifyAll();
            }
        }

        public void stop() {
            this.started = false;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Object getControl(String string) {
            return null;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    class BasicMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        BasicMuxTimeBase() {
        }

        public long getMediaTime() {
            if (!this.updated) {
                return this.ticks;
            }
            if (BasicMux.this.mediaTime.length == 1) {
                this.ticks = BasicMux.this.mediaTime[0];
            } else {
                this.ticks = BasicMux.this.mediaTime[0];
                int n2 = 1;
                while (n2 < BasicMux.this.mediaTime.length) {
                    if (BasicMux.this.mediaTime[n2] < this.ticks) {
                        this.ticks = BasicMux.this.mediaTime[n2];
                    }
                    ++n2;
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }

    class SWC
    implements StreamWriterControl,
    Owned {
        private BasicMux bmx;

        public SWC(BasicMux basicMux2) {
            this.bmx = basicMux2;
        }

        public boolean setStreamSizeLimit(long l2) {
            this.bmx.fileSizeLimit = l2;
            return BasicMux.this.streamSizeLimitSupported;
        }

        public long getStreamSize() {
            return this.bmx.getStreamSize();
        }

        public Object getOwner() {
            return this.bmx;
        }

        public Component getControlComponent() {
            return null;
        }
    }
}

