/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.v4l.VCapability;
import com.sun.media.protocol.v4l.VChannel;
import com.sun.media.protocol.v4l.VPicture;
import com.sun.media.protocol.v4l.VTuner;
import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class V4LCapture {
    protected int nativePeer = 0;
    protected boolean supportsMMap = false;
    protected boolean supportsRead = false;
    protected int cardNo = 0;

    public V4LCapture(int n2) {
        this.nativePeer = this.nOpen(n2);
        if (this.nativePeer == 0) {
            throw new Error("Can't open video card " + n2);
        }
        this.cardNo = n2;
    }

    public void close() {
        V4LCapture v4LCapture = this;
        synchronized (v4LCapture) {
            this.nClose();
            this.nativePeer = 0;
        }
    }

    public native int nOpen(int var1);

    public native int nClose();

    public native int getCapability(VCapability var1);

    public native int getChannel(VChannel var1);

    public native int setChannel(VChannel var1);

    public native int getPicture(VPicture var1);

    public native int setPicture(VPicture var1);

    public native int getTuner(VTuner var1);

    public native int setTuner(VTuner var1);

    public native int getFrequency();

    public native int setFrequency(int var1);

    public native int setFormat(int var1, int var2, int var3, int var4, float var5);

    public native int start();

    public native int stop();

    public native int readNextFrame(byte[] var1, int var2, int var3);

    public int formatToPalette(Format format) {
        if (format == null) {
            return 0;
        }
        if (format instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)format;
            int n2 = rGBFormat.getBitsPerPixel();
            switch (n2) {
                case 24: {
                    return 4;
                }
                case 16: {
                    if (rGBFormat.getGreenMask() == 2016) {
                        return 3;
                    }
                    return 6;
                }
                case 32: {
                    return 5;
                }
            }
            return 0;
        }
        if (format instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)format;
            switch (yUVFormat.getYuvType()) {
                case 32: {
                    if (yUVFormat.getOffsetY() == 0) {
                        return 7;
                    }
                    return 9;
                }
                case 2: {
                    return 15;
                }
            }
        }
        return 0;
    }

    public VideoFormat paletteToFormat(int n2, Dimension dimension) {
        VideoFormat videoFormat;
        int n3 = dimension.width * dimension.height;
        switch (n2) {
            case 3: {
                videoFormat = new RGBFormat(dimension, n3 * 2, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, dimension.width * 2, 0, 1);
                break;
            }
            case 4: {
                videoFormat = new RGBFormat(dimension, n3 * 3, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, dimension.width * 3, 0, -1);
                break;
            }
            case 5: {
                videoFormat = new RGBFormat(dimension, n3 * 4, Format.byteArray, -1.0f, 32, 1, 2, 3, 4, dimension.width * 4, 0, -1);
                break;
            }
            case 6: {
                videoFormat = new RGBFormat(dimension, n3 * 2, Format.byteArray, -1.0f, 16, 31744, 992, 31, 2, dimension.width * 2, 0, 1);
                break;
            }
            case 7: 
            case 8: {
                videoFormat = new YUVFormat(dimension, n3 * 2, Format.byteArray, -1.0f, 32, dimension.width * 2, dimension.width * 2, 0, 1, 3);
                break;
            }
            case 9: {
                videoFormat = new YUVFormat(dimension, n3 * 2, Format.byteArray, -1.0f, 32, dimension.width * 2, dimension.width * 2, 1, 0, 2);
                break;
            }
            case 15: {
                videoFormat = new YUVFormat(dimension, n3 + n3 / 2, Format.byteArray, -1.0f, 2, dimension.width, dimension.width / 2, 0, n3, n3 + n3 / 4);
                break;
            }
            default: {
                videoFormat = null;
            }
        }
        return videoFormat;
    }

    public int paletteToDepth(int n2) {
        int[] nArray = new int[]{0, 8, 8, 16, 24, 32, 16, 16, 16, 16, 12, 12, 12, 16, 12, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return nArray[n2];
    }

    public static void main(String[] stringArray) {
        V4LCapture v4LCapture = new V4LCapture(0);
        VCapability vCapability = new VCapability();
        v4LCapture.getCapability(vCapability);
        v4LCapture.close();
        System.err.println("Card = " + vCapability.name);
        System.err.println("Channels = " + vCapability.channels);
    }

    static {
        JMFSecurityManager.loadLibrary("jmv4l");
    }
}

