/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.JavaSoundOutput;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaSoundRenderer
extends AudioRenderer
implements ExclusiveUse {
    static String NAME = "JavaSound Renderer";
    Codec ulawDecoder;
    Format ulawOutputFormat;
    Format ulawFormat;
    Format linearFormat;
    static int METERHEIGHT = 4;
    static boolean available = false;
    Buffer decodeBuffer = null;

    public JavaSoundRenderer() {
        if (!available) {
            throw new UnsatisfiedLinkError("No JavaSound library");
        }
        this.ulawFormat = new AudioFormat("ULAW");
        this.linearFormat = new AudioFormat("LINEAR");
        this.supportedFormats = new Format[2];
        this.supportedFormats[0] = this.linearFormat;
        this.supportedFormats[1] = this.ulawFormat;
        this.gainControl = new GCA(this);
        this.peakVolumeMeter = new PeakVolumeMeter(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null) {
            if (!this.initDevice(this.inputFormat)) {
                throw new ResourceUnavailableException("Cannot intialize audio device for playback");
            }
            this.device.pause();
        }
    }

    public boolean isExclusive() {
        return false;
    }

    protected boolean initDevice(AudioFormat audioFormat) {
        Format format = audioFormat;
        if (this.ulawDecoder != null) {
            this.ulawDecoder.close();
            this.ulawDecoder = null;
        }
        Format[] formatArray = new Format[1];
        if (this.ulawFormat.matches(audioFormat)) {
            this.ulawDecoder = SimpleGraphBuilder.findCodec(audioFormat, this.linearFormat, null, formatArray);
            if (this.ulawDecoder != null) {
                format = formatArray[0];
                this.ulawOutputFormat = format;
            } else {
                return false;
            }
        }
        this.devFormat = audioFormat;
        return super.initDevice((AudioFormat)format);
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new JavaSoundOutput();
    }

    public int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        if (this.ulawDecoder == null) {
            try {
                ((PeakVolumeMeter)this.peakVolumeMeter).processData(buffer);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return super.doProcessData(buffer);
        }
        if (this.decodeBuffer == null) {
            this.decodeBuffer = new Buffer();
            this.decodeBuffer.setFormat(this.ulawOutputFormat);
        }
        this.decodeBuffer.setLength(0);
        this.decodeBuffer.setOffset(0);
        this.decodeBuffer.setFlags(buffer.getFlags());
        this.decodeBuffer.setTimeStamp(buffer.getTimeStamp());
        this.decodeBuffer.setSequenceNumber(buffer.getSequenceNumber());
        int n2 = this.ulawDecoder.process(buffer, this.decodeBuffer);
        if (n2 == 0) {
            try {
                ((PeakVolumeMeter)this.peakVolumeMeter).processData(this.decodeBuffer);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
            return super.doProcessData(this.decodeBuffer);
        }
        return 1;
    }

    public Object[] getControls() {
        Object[] objectArray = new Control[]{this.gainControl, this.bufferControl, this.peakVolumeMeter};
        return objectArray;
    }

    static {
        String string = null;
        String string2 = null;
        try {
            string = System.getProperty("java.version");
            int n2 = string.length() < 3 ? string.length() : 3;
            string2 = string.substring(0, n2);
        }
        catch (Throwable throwable) {
            string = null;
            string2 = null;
        }
        if (string2 == null || string2.compareTo("1.3") < 0) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jsound");
                available = true;
            }
            catch (Throwable throwable) {}
        } else {
            available = true;
        }
    }

    class PeakVolumeMeter
    implements Control,
    Owned {
        int averagePeak = 0;
        int lastPeak = 0;
        Panel component = null;
        Checkbox cbEnabled = null;
        Canvas canvas = null;
        AudioRenderer renderer;
        long lastResetTime;
        Graphics cGraphics = null;

        public PeakVolumeMeter(AudioRenderer audioRenderer) {
            this.renderer = audioRenderer;
            this.lastResetTime = System.currentTimeMillis();
        }

        public Object getOwner() {
            return this.renderer;
        }

        public Component getControlComponent() {
            if (this.component == null) {
                this.canvas = new Canvas(this){
                    private final /* synthetic */ PeakVolumeMeter this$1;
                    {
                        this.this$1 = peakVolumeMeter;
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(102, METERHEIGHT);
                    }
                };
                this.cbEnabled = new Checkbox("Peak Volume Meter", false);
                this.component = new Panel();
                this.component.add(this.cbEnabled);
                this.component.add(this.canvas);
                this.canvas.setBackground(Color.black);
            }
            return this.component;
        }

        public void processData(Buffer buffer) {
            int n2;
            boolean bl;
            AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
            int n3 = 0;
            int n4 = 0;
            int n5 = 2;
            if (this.component == null) {
                return;
            }
            if (!this.cbEnabled.getState()) {
                return;
            }
            byte[] byArray = (byte[])buffer.getData();
            if (buffer.isDiscard()) {
                return;
            }
            if (buffer.getLength() <= 0) {
                return;
            }
            if (audioFormat.getEndian() == 0) {
                n3 = 1;
            }
            boolean bl2 = bl = audioFormat.getSigned() == 1;
            if (audioFormat.getSampleSizeInBits() == 8) {
                n5 = 1;
            }
            if (bl) {
                n2 = n3;
                while (n2 < buffer.getLength()) {
                    int n6 = byArray[n2];
                    if (n6 < 0) {
                        n6 = -n6;
                    }
                    if (n6 > n4) {
                        n4 = n6;
                    }
                    n2 += n5 * 5;
                }
                n4 = n4 * 100 / 127;
            } else {
                n2 = n3;
                while (n2 < buffer.getLength()) {
                    if ((byArray[n2] & 0xFF) > n4) {
                        n4 = byArray[n2] & 0xFF;
                    }
                    n2 += n5 * 5;
                }
                n4 = n4 * 100 / 255;
            }
            this.averagePeak = (n4 + this.averagePeak) / 2;
            long l2 = System.currentTimeMillis();
            if (l2 > this.lastResetTime + 100L) {
                this.lastResetTime = l2;
                this.updatePeak(this.averagePeak);
                this.averagePeak = n4;
            }
        }

        private void updatePeak(int n2) {
            if (this.canvas == null) {
                return;
            }
            if (this.cGraphics == null) {
                this.cGraphics = this.canvas.getGraphics();
            }
            if (this.cGraphics == null) {
                return;
            }
            if (n2 > 99) {
                n2 = 99;
            }
            this.cGraphics.setColor(Color.green);
            if (n2 < 80) {
                this.cGraphics.drawLine(1, 1, n2 + 1, 1);
                this.cGraphics.drawLine(1, 2, n2 + 1, 2);
            } else {
                this.cGraphics.drawLine(1, 1, 81, 1);
                this.cGraphics.drawLine(1, 2, 81, 2);
                this.cGraphics.setColor(Color.yellow);
                if (n2 < 90) {
                    this.cGraphics.drawLine(81, 1, n2 + 1, 1);
                    this.cGraphics.drawLine(81, 2, n2 + 1, 2);
                } else {
                    this.cGraphics.drawLine(81, 1, 91, 1);
                    this.cGraphics.drawLine(81, 2, 91, 2);
                    this.cGraphics.setColor(Color.red);
                    this.cGraphics.drawLine(91, 1, n2 + 1, 1);
                    this.cGraphics.drawLine(91, 2, n2 + 1, 2);
                }
            }
            this.cGraphics.setColor(Color.black);
            this.cGraphics.drawLine(n2 + 2, 1, 102, 1);
            this.cGraphics.drawLine(n2 + 2, 2, 102, 2);
            this.lastPeak = n2;
        }
    }

    class GCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected GCA(AudioRenderer audioRenderer) {
            super(false);
            this.renderer = audioRenderer;
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }

        public float setLevel(float f2) {
            float f3 = super.setLevel(f2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(this.getDB());
            }
            return f3;
        }
    }
}

