/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.RTPTransmitter;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.RTPMediaThread;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.event.LocalPayloadChangeEvent;

public class RTPSinkStream
implements BufferTransferHandler {
    private RTPMediaThread thread = null;
    Buffer current = new Buffer();
    boolean started = false;
    Object startReq = new Integer(0);
    RTPTransmitter transmitter = null;
    RTPRawSender sender = null;
    SendSSRCInfo info = null;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    long startTime = 0L;
    long startPT = -1L;
    int rate;
    boolean mpegBFrame = false;
    boolean mpegPFrame = false;
    boolean bufSizeSet = false;
    long audioPT = 0L;
    static int THRESHOLD;
    static int LEEWAY;

    public void startStream() {
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    string = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                if (string.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
    }

    protected void setSSRCInfo(SendSSRCInfo sendSSRCInfo) {
        this.info = sendSSRCInfo;
    }

    protected void setTransmitter(RTPTransmitter rTPTransmitter) {
        this.transmitter = rTPTransmitter;
        if (this.transmitter != null) {
            this.sender = this.transmitter.getSender();
        }
    }

    public void transferData(PushBufferStream pushBufferStream) {
        try {
            Object object = this.startReq;
            synchronized (object) {
                while (!this.started) {
                    this.startPT = -1L;
                    this.startReq.wait();
                }
            }
            pushBufferStream.read(this.current);
            if (!this.current.getFormat().matches(this.info.myformat)) {
                int n2 = this.transmitter.cache.sm.formatinfo.getPayload(this.current.getFormat());
                if (n2 == -1) {
                    return;
                }
                LocalPayloadChangeEvent localPayloadChangeEvent = new LocalPayloadChangeEvent(this.transmitter.cache.sm, this.info, this.info.payloadType, n2);
                this.transmitter.cache.eventhandler.postEvent(localPayloadChangeEvent);
                this.info.payloadType = n2;
                this.info.myformat = this.current.getFormat();
            }
            if (this.info.myformat instanceof VideoFormat) {
                this.transmitVideo();
            } else if (this.info.myformat instanceof AudioFormat) {
                this.transmitAudio();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    public void stop() {
        this.started = false;
        this.startPT = -1L;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    protected void close() {
        this.stop();
    }

    private void transmitVideo() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            this.mpegBFrame = false;
            this.mpegPFrame = false;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.startPT = this.current.getTimeStamp() / 1000000L;
        }
        if (this.current.getTimeStamp() > 0L && (this.current.getFlags() & 0x60) == 0 && (this.current.getFlags() & 0x800) != 0) {
            if (mpegVideo.matches(this.info.myformat)) {
                int n2;
                byte[] byArray = (byte[])this.current.getData();
                int n3 = byArray[(n2 = this.current.getOffset()) + 2] & 7;
                if (n3 > 2) {
                    this.mpegBFrame = true;
                } else if (n3 == 2) {
                    this.mpegPFrame = true;
                }
                if (n3 > 2 || n3 == 2 && !this.mpegBFrame || n3 == 1 && !(this.mpegBFrame | this.mpegPFrame)) {
                    this.waitForPT(this.startTime, this.startPT, this.current.getTimeStamp() / 1000000L);
                }
            } else {
                this.waitForPT(this.startTime, this.startPT, this.current.getTimeStamp() / 1000000L);
            }
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    private void transmitAudio() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.audioPT = this.startPT = this.current.getTimeStamp() > 0L ? this.current.getTimeStamp() / 1000000L : 0L;
        }
        if ((this.current.getFlags() & 0x60) == 0) {
            this.audioPT = mpegAudio.matches(this.current.getFormat()) ? this.current.getTimeStamp() / 1000000L : (this.audioPT += ((AudioFormat)this.info.myformat).computeDuration(this.current.getLength()) / 1000000L);
            this.waitForPT(this.startTime, this.startPT, this.audioPT);
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    private void waitForPT(long l2, long l3, long l4) {
        long l5 = l4 - l3 - (System.currentTimeMillis() - l2);
        while (l5 > (long)LEEWAY) {
            if (l5 > (long)THRESHOLD) {
                l5 = THRESHOLD;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                break;
            }
            l5 = l4 - l3 - (System.currentTimeMillis() - l2);
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        THRESHOLD = 80;
        LEEWAY = 5;
    }
}

