/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SynchSource;
import com.sun.media.rtp.util.SSRCTable;

public class StreamSynch {
    private static SSRCTable sources;

    public StreamSynch() {
        if (sources == null) {
            sources = new SSRCTable();
        }
    }

    public void update(int n2, long l2, long l3, long l4) {
        double d2 = (double)l4 / 4.294967296E9;
        long l5 = l3 * 1000000000L + (long)(d2 * 1.0E9);
        SynchSource synchSource = (SynchSource)sources.get(n2);
        if (synchSource == null) {
            sources.put(n2, new SynchSource(n2, l2, l5));
        } else {
            synchSource.factor = (l2 - synchSource.rtpTimestamp) * (l5 - synchSource.ntpTimestamp);
            synchSource.rtpTimestamp = l2;
            synchSource.ntpTimestamp = l5;
        }
    }

    public long calcTimestamp(int n2, int n3, long l2) {
        long l3 = -1L;
        SynchSource synchSource = (SynchSource)sources.get(n2);
        if (synchSource != null) {
            long l4 = 1L;
            if (n3 >= 0 && n3 <= 5) {
                l4 = 8000L;
            } else if (n3 == 5) {
                l4 = 8000L;
            } else if (n3 == 6) {
                l4 = 16000L;
            } else if (n3 >= 7 && n3 <= 9) {
                l4 = 8000L;
            } else if (n3 >= 10 && n3 <= 11) {
                l4 = 44100L;
            } else if (n3 == 14) {
                l4 = 90000L;
            } else if (n3 == 15) {
                l4 = 8000L;
            } else if (n3 == 16) {
                l4 = 11025L;
            } else if (n3 == 17) {
                l4 = 22050L;
            } else if (n3 >= 25 && n3 <= 26) {
                l4 = 90000L;
            } else if (n3 == 28) {
                l4 = 90000L;
            } else if (n3 >= 31 && n3 <= 34) {
                l4 = 90000L;
            } else if (n3 == 42) {
                l4 = 90000L;
            }
            l3 = synchSource.ntpTimestamp + (l2 - synchSource.rtpTimestamp) * 1000000000L / l4;
        }
        return l3;
    }

    public void remove(int n2) {
        if (sources != null) {
            sources.remove(n2);
        }
    }
}

