/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

public class StatusCode {
    public static final int CONTINUE = 100;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int LOW_ON_STORAGE_SPACE = 250;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMED_OUT = 408;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LARGE = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int PARAMETER_NOT_UNDERSTOOD = 451;
    public static final int CONFERENCE_NOT_FOUND = 452;
    public static final int NOT_ENOUGH_BANDWIDTH = 453;
    public static final int SESSION_NOT_FOUND = 454;
    public static final int METHOD_NOT_VALID_IN_THIS_STATE = 455;
    public static final int HEADER_FIELD_NOT_VALID = 456;
    public static final int INVALID_RANGE = 457;
    public static final int PARAMETER_IS_READ_ONLY = 458;
    public static final int AGGREGATE_OPERATION_NOT_ALLOWED = 459;
    public static final int ONLY_AGGREGATE_OPERATION_ALLOWED = 460;
    public static final int UNSUPPORTED_TRANSPORT = 461;
    public static final int DESTINATION_UNREACHABLE = 462;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIME_OUT = 504;
    public static final int RTSP_VERSION_NOT_SUPPORTED = 505;
    public static final int OPTION_NOT_SUPPORTED = 551;
    private int code;

    public StatusCode(int n2) {
        this.code = n2;
    }

    public static String getStatusText(int n2) {
        String string;
        switch (n2) {
            case 100: {
                string = "Continue";
                break;
            }
            case 200: {
                string = "Ok";
                break;
            }
            case 201: {
                string = "Created";
                break;
            }
            case 250: {
                string = "Low on storage space";
                break;
            }
            case 300: {
                string = "Multiple choices";
                break;
            }
            case 301: {
                string = "Moved permanently";
                break;
            }
            case 302: {
                string = "Moved temporarily";
                break;
            }
            case 303: {
                string = "See other";
                break;
            }
            case 304: {
                string = "Not modified";
                break;
            }
            case 305: {
                string = "Use proxy";
                break;
            }
            case 400: {
                string = "Bad request";
                break;
            }
            case 401: {
                string = "Unauthorized";
                break;
            }
            case 402: {
                string = "Payment required";
                break;
            }
            case 403: {
                string = "Forbidden";
                break;
            }
            case 404: {
                string = "Not found";
                break;
            }
            case 405: {
                string = "Method not allowed";
                break;
            }
            case 406: {
                string = "Not acceptable";
                break;
            }
            case 407: {
                string = "Proxy authentication required";
                break;
            }
            case 408: {
                string = "Request timed out";
                break;
            }
            case 410: {
                string = "Gone";
                break;
            }
            case 411: {
                string = "Length required";
                break;
            }
            case 412: {
                string = "Precondition failed";
                break;
            }
            case 413: {
                string = "Request entity too large";
                break;
            }
            case 414: {
                string = "Request URI too large";
                break;
            }
            case 415: {
                string = "Unsupported media type";
                break;
            }
            case 451: {
                string = "Parameter not understood";
                break;
            }
            case 452: {
                string = "Conference not found";
                break;
            }
            case 453: {
                string = "Not enough bandwidth";
                break;
            }
            case 454: {
                string = "Session not found";
                break;
            }
            case 455: {
                string = "Method not valid in this state";
                break;
            }
            case 456: {
                string = "Header field not valid";
                break;
            }
            case 457: {
                string = "Invalid range";
                break;
            }
            case 458: {
                string = "Parameter is read only";
                break;
            }
            case 459: {
                string = "Aggregate operation not allowed";
                break;
            }
            case 460: {
                string = "Only aggregate operation allowed";
                break;
            }
            case 461: {
                string = "Unsupported transport";
                break;
            }
            case 462: {
                string = "Destination unreachable";
                break;
            }
            case 500: {
                string = "Internal server error";
                break;
            }
            case 501: {
                string = "Not implemented";
                break;
            }
            case 502: {
                string = "Bad gateway";
                break;
            }
            case 503: {
                string = "Service unavailable";
                break;
            }
            case 504: {
                string = "Gateway time-out";
                break;
            }
            case 505: {
                string = "RTSP version not supported";
                break;
            }
            case 551: {
                string = "Option not supported";
                break;
            }
            default: {
                string = "Unknown status code: " + n2;
            }
        }
        return string;
    }
}

